/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.ResourceBundle;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.LinguServices;
import org.languagetool.UserConfig;
import org.languagetool.rules.AbstractStyleTooOftenUsedWordRule;
import org.languagetool.rules.Rule;

public class StyleTooOftenUsedAdjectiveRule
extends AbstractStyleTooOftenUsedWordRule {
    private static final int DEFAULT_MIN_PERCENT = 5;

    public StyleTooOftenUsedAdjectiveRule(ResourceBundle messages, Language lang, UserConfig userConfig) {
        super(messages, lang, userConfig, 5);
        LinguServices linguServices;
        if (userConfig != null && (linguServices = userConfig.getLinguServices()) != null) {
            linguServices.setThesaurusRelevantRule((Rule)this);
        }
    }

    protected String getLimitMessage(int limit) {
        return "Das Adjektiv wird h\u00e4ufiger verwendet als " + limit + "% aller Adjektive . M\u00f6glicherweise ist es besser es durch ein Synonym zu ersetzen.";
    }

    public String getId() {
        return "TOO_OFTEN_USED_ADJECTIVE_DE";
    }

    public String getDescription() {
        return "Statistische Stilanalyse: Zu h\u00e4ufig genutztes Adjektiv";
    }

    public String getConfigureText() {
        return "Anzeigen wenn ein Adjektiv h\u00e4ufiger verwendet wird als ...% aller Adjektive:";
    }

    protected boolean isToCountedWord(AnalyzedTokenReadings token) {
        return token.hasPosTagStartingWith("ADJ:");
    }

    protected boolean isException(AnalyzedTokenReadings token) {
        return token.hasPosTagStartingWith("PRO:") || token.hasPosTagStartingWith("ADV:") || token.hasPosTagStartingWith("ZUS");
    }

    protected String toAddedLemma(AnalyzedTokenReadings token) {
        return this.getLemmaForPosTagStartsWith("ADJ:", token);
    }
}

