/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import com.hankcs.algorithm.AhoCorasickDoubleArrayTrie;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.languagetool.JLanguageTool;
import org.languagetool.synthesis.GermanSynthesizer;
import org.languagetool.tools.StringTools;

class SpellingData {
    private final AhoCorasickDoubleArrayTrie<String> trie = new AhoCorasickDoubleArrayTrie();
    private final AhoCorasickDoubleArrayTrie<String> sentenceStartTrie = new AhoCorasickDoubleArrayTrie();

    SpellingData(String filePath) {
        this.trie.build(SpellingData.getCoherencyMap(filePath, false));
        this.sentenceStartTrie.build(SpellingData.getCoherencyMap(filePath, true));
    }

    @NotNull
    private static Map<String, String> getCoherencyMap(String filePath, boolean sentStartMode) {
        List lines = JLanguageTool.getDataBroker().getFromResourceDirAsLines(filePath);
        HashMap<String, String> coherencyMap = new HashMap<String, String>();
        for (String line : lines) {
            if (line.startsWith("#")) continue;
            String[] parts = line.split(";");
            if (parts.length < 2) {
                throw new RuntimeException("Unexpected format in file " + filePath + ": " + line);
            }
            String oldSpelling = parts[0];
            String newSpelling = parts[1];
            SpellingData.sanityChecks(filePath, line, oldSpelling, newSpelling, coherencyMap);
            if (sentStartMode && StringTools.startsWithLowercase((String)oldSpelling) && StringTools.startsWithLowercase((String)newSpelling)) {
                coherencyMap.put(StringTools.uppercaseFirstChar((String)oldSpelling), StringTools.uppercaseFirstChar((String)newSpelling));
            } else {
                coherencyMap.put(oldSpelling, newSpelling);
            }
            if (!oldSpelling.contains("\u00df") || !oldSpelling.replace("\u00df", "ss").equals(newSpelling)) continue;
            try {
                String[] forms;
                for (String form : forms = GermanSynthesizer.INSTANCE.synthesizeForPosTags(oldSpelling, s -> true)) {
                    if (form.contains("ss")) continue;
                    coherencyMap.put(form, form.replace("\u00df", "ss"));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return coherencyMap;
    }

    private static void sanityChecks(String filePath, String line, String oldSpelling, String newSpelling, Map<String, String> coherencyMap) {
        if (oldSpelling.equals(newSpelling)) {
            throw new RuntimeException("Old and new spelling are the same in " + filePath + ": " + line);
        }
        String lookup = coherencyMap.get(newSpelling);
        if (lookup != null && lookup.equals(oldSpelling)) {
            throw new RuntimeException("Contradictory entry in " + filePath + ": '" + oldSpelling + "' suggests '" + lookup + "' and vice versa");
        }
        if (coherencyMap.containsKey(oldSpelling) && !coherencyMap.get(oldSpelling).equals(newSpelling)) {
            throw new RuntimeException("Duplicate key in " + filePath + ": " + oldSpelling + ", val: " + coherencyMap.get(oldSpelling) + " vs. " + newSpelling);
        }
    }

    public AhoCorasickDoubleArrayTrie<String> getTrie() {
        return this.trie;
    }

    public AhoCorasickDoubleArrayTrie<String> getSentenceStartTrie() {
        return this.sentenceStartTrie;
    }
}

