/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.ReadabilityRule;
import org.languagetool.rules.de.GermanTools;

public class GermanReadabilityRule
extends ReadabilityRule {
    private final boolean tooEasyTest;

    public GermanReadabilityRule(ResourceBundle messages, Language lang, UserConfig userConfig, boolean tooEasyTest) {
        this(messages, lang, userConfig, tooEasyTest, -1, false);
    }

    public GermanReadabilityRule(ResourceBundle messages, Language lang, UserConfig userConfig, boolean tooEasyTest, int level) {
        this(messages, lang, userConfig, tooEasyTest, level, false);
    }

    public GermanReadabilityRule(ResourceBundle messages, Language lang, UserConfig userConfig, boolean tooEasyTest, boolean defaultOn) {
        this(messages, lang, userConfig, tooEasyTest, -1, defaultOn);
    }

    public GermanReadabilityRule(ResourceBundle messages, Language lang, UserConfig userConfig, boolean tooEasyTest, int level, boolean defaultOn) {
        super(messages, lang, userConfig, tooEasyTest, level, defaultOn);
        super.setCategory(new Category(new CategoryId("CREATIVE_WRITING"), messages.getString("category_creative_writing"), Category.Location.INTERNAL, false));
        this.tooEasyTest = tooEasyTest;
    }

    public String getId() {
        return this.getId(this.tooEasyTest);
    }

    public String getId(boolean tooEasyTest) {
        if (tooEasyTest) {
            return "READABILITY_RULE_SIMPLE_DE";
        }
        return "READABILITY_RULE_DIFFICULT_DE";
    }

    public String getDescription() {
        if (this.tooEasyTest) {
            return "Lesbarkeit: Zu einfacher Text";
        }
        return "Lesbarkeit: Zu schwieriger Text";
    }

    public String printMessageLevel(int level) {
        String sLevel = null;
        if (level == 0) {
            sLevel = "Sehr schwer";
        } else if (level == 1) {
            sLevel = "Schwer";
        } else if (level == 2) {
            sLevel = "Mittelschwer";
        } else if (level == 3) {
            sLevel = "Mittel";
        } else if (level == 4) {
            sLevel = "Mittelleicht";
        } else if (level == 5) {
            sLevel = "Leicht";
        } else if (level == 6) {
            sLevel = "Sehr leicht";
        }
        if (sLevel != null) {
            return " {Grad " + level + ": " + sLevel + "}";
        }
        return "";
    }

    protected String getMessage(int level, int fre, int als, int asw) {
        String few;
        String simple;
        if (this.tooEasyTest) {
            simple = "einfach";
            few = "wenige";
        } else {
            simple = "schwierig";
            few = "viele";
        }
        return "Lesbarkeit: Der Text dieses Absatzes ist zu " + simple + this.printMessageLevel(level) + ". Zu " + few + " W\u00f6rter pro Satz und zu " + few + " Silben pro Wort.";
    }

    public String getConfigureText() {
        return "Grad der Lesbarkeit 0 (sehr schwierig) bis 6 (sehr einfach):";
    }

    public double getFleschReadingEase(double asl, double asw) {
        return 180.0 - asl - 58.5 * asw;
    }

    protected int simpleSyllablesCount(String word) {
        if (word.length() == 0) {
            return 0;
        }
        int nSyllables = 0;
        if (GermanTools.isVowel(word.charAt(0))) {
            ++nSyllables;
        }
        boolean lastDouble = false;
        for (int i = 1; i < word.length(); ++i) {
            char c = word.charAt(i);
            if (GermanTools.isVowel(c)) {
                char cl = word.charAt(i - 1);
                if (lastDouble) {
                    ++nSyllables;
                    lastDouble = false;
                    continue;
                }
                if ((c == 'i' || c == 'y') && (cl == 'a' || cl == 'e' || cl == 'A' || cl == 'E') || c == 'u' && (cl == 'a' || cl == 'e' || cl == 'o' || cl == 'A' || cl == 'E' || cl == 'O') || c == 'e' && (cl == 'e' || cl == 'i' || cl == 'E' || cl == 'I') || c == 'a' && (cl == 'a' || cl == 'A')) {
                    lastDouble = true;
                    continue;
                }
                ++nSyllables;
                lastDouble = false;
                continue;
            }
            lastDouble = false;
        }
        return nSyllables == 0 ? 1 : nSyllables;
    }
}

