/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import com.hankcs.algorithm.AhoCorasickDoubleArrayTrie;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.languagetool.JLanguageTool;
import org.languagetool.synthesis.GermanSynthesizer;

class SpellingData {
    private final AhoCorasickDoubleArrayTrie<String> trie = new AhoCorasickDoubleArrayTrie();

    SpellingData(String filePath) {
        List lines = JLanguageTool.getDataBroker().getFromResourceDirAsLines(filePath);
        HashMap<String, String> coherencyMap = new HashMap<String, String>();
        for (String line : lines) {
            if (line.startsWith("#")) continue;
            String[] parts = line.split(";");
            if (parts.length < 2) {
                throw new RuntimeException("Unexpected format in file " + filePath + ": " + line);
            }
            String oldSpelling = parts[0];
            String newSpelling = parts[1];
            String lookup = (String)coherencyMap.get(newSpelling);
            if (lookup != null && lookup.equals(oldSpelling)) {
                throw new RuntimeException("Contradictory entry in " + filePath + ": '" + oldSpelling + "' suggests '" + lookup + "' and vice versa");
            }
            if (coherencyMap.containsKey(oldSpelling) && !((String)coherencyMap.get(oldSpelling)).equals(newSpelling)) {
                throw new RuntimeException("Duplicate key in " + filePath + ": " + oldSpelling + ", val: " + (String)coherencyMap.get(oldSpelling) + " vs. " + newSpelling);
            }
            coherencyMap.put(oldSpelling, newSpelling);
            if (!oldSpelling.contains("\u00df") || !oldSpelling.replaceAll("\u00df", "ss").equals(newSpelling)) continue;
            try {
                String[] forms;
                for (String form : forms = GermanSynthesizer.INSTANCE.synthesizeForPosTags(oldSpelling, s -> true)) {
                    if (form.contains("ss")) continue;
                    coherencyMap.put(form, form.replaceAll("\u00df", "ss"));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.trie.build(coherencyMap);
    }

    public AhoCorasickDoubleArrayTrie<String> getTrie() {
        return this.trie;
    }
}

