/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.ResourceBundle;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.tools.Tools;

public class SentenceWhitespaceRule
extends org.languagetool.rules.SentenceWhitespaceRule {
    public SentenceWhitespaceRule(ResourceBundle messages) {
        super(messages);
        super.setCategory(Categories.MISC.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Whitespace);
        this.setUrl(Tools.getUrl((String)"https://languagetool.org/insights/de/beitrag/grammatik-leerzeichen/#fehler-1-leerzeichen-vor-und-nach-satzzeichen"));
        this.addExamplePair(Example.wrong((String)"Hier steht ein Satz.<marker>Das</marker> ist ein weiterer Satz."), Example.fixed((String)"Hier steht ein Satz.<marker> Das</marker> ist ein weiterer Satz."));
    }

    public String getId() {
        return "DE_SENTENCE_WHITESPACE";
    }

    public String getDescription() {
        return "Fehlendes Leerzeichen zwischen S\u00e4tzen oder nach Ordnungszahlen";
    }

    public String getMessage(boolean prevSentenceEndsWithNumber) {
        if (prevSentenceEndsWithNumber) {
            return "F\u00fcgen Sie nach Ordnungszahlen (1., 2. usw.) ein Leerzeichen ein.";
        }
        return "F\u00fcgen Sie zwischen S\u00e4tzen ein Leerzeichen ein.";
    }
}

