/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.de.AgreementRule;
import org.languagetool.tagging.de.AnalyzedGermanToken;
import org.languagetool.tagging.de.GermanToken;

class AgreementTools {
    private AgreementTools() {
    }

    static Set<String> getAgreementCategories(AnalyzedTokenReadings aToken, Set<AgreementRule.GrammarCategory> omit, boolean skipSol) {
        HashSet<String> set = new HashSet<String>();
        List readings = aToken.getReadings();
        for (AnalyzedToken tmpReading : readings) {
            AnalyzedGermanToken reading;
            if (skipSol && tmpReading.getPOSTag() != null && tmpReading.getPOSTag().endsWith(":SOL") || (reading = new AnalyzedGermanToken(tmpReading)).getCasus() == null && reading.getNumerus() == null && reading.getGenus() == null) continue;
            if (reading.getGenus() == GermanToken.Genus.ALLGEMEIN && tmpReading.getPOSTag() != null && !tmpReading.getPOSTag().endsWith(":STV") && !AgreementTools.possessiveSpecialCase(aToken, tmpReading)) {
                if (reading.getDetermination() == null) {
                    set.add(AgreementTools.makeString(reading.getCasus(), reading.getNumerus(), GermanToken.Genus.MASKULINUM, GermanToken.Determination.DEFINITE, omit));
                    set.add(AgreementTools.makeString(reading.getCasus(), reading.getNumerus(), GermanToken.Genus.MASKULINUM, GermanToken.Determination.INDEFINITE, omit));
                    set.add(AgreementTools.makeString(reading.getCasus(), reading.getNumerus(), GermanToken.Genus.FEMININUM, GermanToken.Determination.DEFINITE, omit));
                    set.add(AgreementTools.makeString(reading.getCasus(), reading.getNumerus(), GermanToken.Genus.FEMININUM, GermanToken.Determination.INDEFINITE, omit));
                    set.add(AgreementTools.makeString(reading.getCasus(), reading.getNumerus(), GermanToken.Genus.NEUTRUM, GermanToken.Determination.DEFINITE, omit));
                    set.add(AgreementTools.makeString(reading.getCasus(), reading.getNumerus(), GermanToken.Genus.NEUTRUM, GermanToken.Determination.INDEFINITE, omit));
                    continue;
                }
                set.add(AgreementTools.makeString(reading.getCasus(), reading.getNumerus(), GermanToken.Genus.MASKULINUM, reading.getDetermination(), omit));
                set.add(AgreementTools.makeString(reading.getCasus(), reading.getNumerus(), GermanToken.Genus.FEMININUM, reading.getDetermination(), omit));
                set.add(AgreementTools.makeString(reading.getCasus(), reading.getNumerus(), GermanToken.Genus.NEUTRUM, reading.getDetermination(), omit));
                continue;
            }
            if (reading.getDetermination() == null || "jed".equals(tmpReading.getLemma()) || "manch".equals(tmpReading.getLemma())) {
                set.add(AgreementTools.makeString(reading.getCasus(), reading.getNumerus(), reading.getGenus(), GermanToken.Determination.DEFINITE, omit));
                set.add(AgreementTools.makeString(reading.getCasus(), reading.getNumerus(), reading.getGenus(), GermanToken.Determination.INDEFINITE, omit));
                continue;
            }
            set.add(AgreementTools.makeString(reading.getCasus(), reading.getNumerus(), reading.getGenus(), reading.getDetermination(), omit));
        }
        return set;
    }

    static Set<String> getAgreementSOLCategories(AnalyzedTokenReadings aToken, Set<AgreementRule.GrammarCategory> omit) {
        HashSet<String> set = new HashSet<String>();
        List readings = aToken.getReadings();
        for (AnalyzedToken tmpReading : readings) {
            AnalyzedGermanToken reading;
            if (tmpReading.getPOSTag() != null && !tmpReading.getPOSTag().endsWith(":SOL") || (reading = new AnalyzedGermanToken(tmpReading)).getCasus() == null && reading.getNumerus() == null && reading.getGenus() == null) continue;
            set.add(AgreementTools.makeString(reading.getCasus(), reading.getNumerus(), reading.getGenus(), GermanToken.Determination.DEFINITE, omit));
            set.add(AgreementTools.makeString(reading.getCasus(), reading.getNumerus(), reading.getGenus(), GermanToken.Determination.INDEFINITE, omit));
        }
        return set;
    }

    private static boolean possessiveSpecialCase(AnalyzedTokenReadings aToken, AnalyzedToken tmpReading) {
        return aToken.hasPosTagStartingWith("PRO:POS") && StringUtils.equalsAny((CharSequence)tmpReading.getLemma(), (CharSequence[])new CharSequence[]{"ich", "sich"});
    }

    private static String makeString(GermanToken.Kasus casus, GermanToken.Numerus num, GermanToken.Genus gen, GermanToken.Determination determination, Set<AgreementRule.GrammarCategory> omit) {
        ArrayList<String> l = new ArrayList<String>();
        if (casus != null && !omit.contains((Object)AgreementRule.GrammarCategory.KASUS)) {
            l.add(casus.toString());
        }
        if (num != null && !omit.contains((Object)AgreementRule.GrammarCategory.NUMERUS)) {
            l.add(num.toString());
        }
        if (gen != null && !omit.contains((Object)AgreementRule.GrammarCategory.GENUS)) {
            l.add(gen.toString());
        }
        if (determination != null) {
            l.add(determination.toString());
        }
        return String.join((CharSequence)"/", l);
    }
}

