/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.UserConfig;
import org.languagetool.chunking.Chunker;
import org.languagetool.chunking.GermanChunker;
import org.languagetool.language.Contributor;
import org.languagetool.language.Contributors;
import org.languagetool.language.GermanyGerman;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.EmptyLineRule;
import org.languagetool.rules.Example;
import org.languagetool.rules.LongParagraphRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.PunctuationMarkAtParagraphEnd;
import org.languagetool.rules.Rule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WhiteSpaceAtBeginOfParagraph;
import org.languagetool.rules.WhiteSpaceBeforeParagraphEnd;
import org.languagetool.rules.de.AgreementRule;
import org.languagetool.rules.de.AgreementRule2;
import org.languagetool.rules.de.CaseRule;
import org.languagetool.rules.de.CompoundCoherencyRule;
import org.languagetool.rules.de.CompoundInfinitivRule;
import org.languagetool.rules.de.ConjunctionAtBeginOfSentenceRule;
import org.languagetool.rules.de.DashRule;
import org.languagetool.rules.de.DuUpperLowerCaseRule;
import org.languagetool.rules.de.GermanCommaWhitespaceRule;
import org.languagetool.rules.de.GermanConfusionProbabilityRule;
import org.languagetool.rules.de.GermanDoublePunctuationRule;
import org.languagetool.rules.de.GermanFillerWordsRule;
import org.languagetool.rules.de.GermanParagraphRepeatBeginningRule;
import org.languagetool.rules.de.GermanReadabilityRule;
import org.languagetool.rules.de.GermanRepeatedWordsRule;
import org.languagetool.rules.de.GermanSpellerRule;
import org.languagetool.rules.de.GermanStyleRepeatedWordRule;
import org.languagetool.rules.de.GermanUnpairedBracketsRule;
import org.languagetool.rules.de.GermanWordRepeatBeginningRule;
import org.languagetool.rules.de.GermanWordRepeatRule;
import org.languagetool.rules.de.GermanWrongWordInContextRule;
import org.languagetool.rules.de.LongSentenceRule;
import org.languagetool.rules.de.MissingCommaRelativeClauseRule;
import org.languagetool.rules.de.MissingVerbRule;
import org.languagetool.rules.de.NonSignificantVerbsRule;
import org.languagetool.rules.de.OldSpellingRule;
import org.languagetool.rules.de.PassiveSentenceRule;
import org.languagetool.rules.de.ProhibitedCompoundRule;
import org.languagetool.rules.de.RedundantModalOrAuxiliaryVerb;
import org.languagetool.rules.de.SentenceWhitespaceRule;
import org.languagetool.rules.de.SentenceWithManRule;
import org.languagetool.rules.de.SentenceWithModalVerbRule;
import org.languagetool.rules.de.SimilarNameRule;
import org.languagetool.rules.de.SimpleReplaceRule;
import org.languagetool.rules.de.StyleRepeatedSentenceBeginning;
import org.languagetool.rules.de.StyleRepeatedVeryShortSentences;
import org.languagetool.rules.de.SubjectVerbAgreementRule;
import org.languagetool.rules.de.UnitConversionRule;
import org.languagetool.rules.de.UnnecessaryPhraseRule;
import org.languagetool.rules.de.UpperCaseNgramRule;
import org.languagetool.rules.de.VerbAgreementRule;
import org.languagetool.rules.de.WiederVsWiderRule;
import org.languagetool.rules.de.WordCoherencyRule;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.synthesis.GermanSynthesizer;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.de.GermanTagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.rules.de.GermanRuleDisambiguator;
import org.languagetool.tokenizers.CompoundWordTokenizer;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.de.GermanCompoundTokenizer;
import org.languagetool.tokenizers.de.GermanWordTokenizer;
import org.languagetool.tools.Tools;

public class German
extends Language
implements AutoCloseable {
    private LanguageModel languageModel;

    @Deprecated
    public German() {
    }

    public Language getDefaultLanguageVariant() {
        return GermanyGerman.INSTANCE;
    }

    public SpellingCheckRule createDefaultSpellingRule(ResourceBundle messages) throws IOException {
        return new GermanSpellerRule(messages, this);
    }

    @NotNull
    public GermanSpellerRule getDefaultSpellingRule() {
        return (GermanSpellerRule)Objects.requireNonNull(super.getDefaultSpellingRule());
    }

    public Disambiguator createDefaultDisambiguator() {
        return new GermanRuleDisambiguator();
    }

    @Nullable
    public Chunker createDefaultPostDisambiguationChunker() {
        return new GermanChunker();
    }

    public String getName() {
        return "German";
    }

    public String getShortCode() {
        return "de";
    }

    public String[] getCountries() {
        return new String[]{"LU", "LI", "BE"};
    }

    @NotNull
    public Tagger createDefaultTagger() {
        return GermanTagger.INSTANCE;
    }

    @Nullable
    public Synthesizer createDefaultSynthesizer() {
        return GermanSynthesizer.INSTANCE;
    }

    public SentenceTokenizer createDefaultSentenceTokenizer() {
        return new SRXSentenceTokenizer((Language)this);
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Jan Schreiber"), Contributors.DANIEL_NABER};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        return Arrays.asList(new Rule[]{new GermanCommaWhitespaceRule(messages, Example.wrong((String)"Die Partei<marker> ,</marker> die die letzte Wahl gewann."), Example.fixed((String)"Die Partei<marker>,</marker> die die letzte Wahl gewann."), Tools.getUrl((String)"https://languagetool.org/insights/de/beitrag/grammatik-leerzeichen/#fehler-1-leerzeichen-vor-und-nach-satzzeichen")), new GermanUnpairedBracketsRule(messages, this), new UppercaseSentenceStartRule(messages, (Language)this, Example.wrong((String)"Das Haus ist alt. <marker>es</marker> wurde 1950 gebaut."), Example.fixed((String)"Das Haus ist alt. <marker>Es</marker> wurde 1950 gebaut."), Tools.getUrl((String)"https://languagetool.org/insights/de/beitrag/gross-klein-schreibung-rechtschreibung/#1-satzanf%C3%A4nge-schreiben-wir-gro%C3%9F")), new MultipleWhitespaceRule(messages, (Language)this), new WhiteSpaceBeforeParagraphEnd(messages, (Language)this), new WhiteSpaceAtBeginOfParagraph(messages), new EmptyLineRule(messages, (Language)this), new LongParagraphRule(messages, (Language)this, userConfig), new PunctuationMarkAtParagraphEnd(messages, (Language)this), new SimpleReplaceRule(messages, this), new OldSpellingRule(messages), new SentenceWhitespaceRule(messages), new GermanDoublePunctuationRule(messages), new MissingVerbRule(messages, this), new GermanWordRepeatRule(messages, this), new GermanWordRepeatBeginningRule(messages, this), new GermanWrongWordInContextRule(messages), new AgreementRule(messages, this), new AgreementRule2(messages, this), new CaseRule(messages, this), new DashRule(messages), new VerbAgreementRule(messages, this), new SubjectVerbAgreementRule(messages, this), new WordCoherencyRule(messages), new SimilarNameRule(messages), new WiederVsWiderRule(messages), new GermanStyleRepeatedWordRule(messages, this, userConfig), new CompoundCoherencyRule(messages), new LongSentenceRule(messages, userConfig, 40), new GermanFillerWordsRule(messages, this, userConfig), new PassiveSentenceRule(messages, this, userConfig), new SentenceWithModalVerbRule(messages, this, userConfig), new SentenceWithManRule(messages, this, userConfig), new ConjunctionAtBeginOfSentenceRule(messages, this, userConfig), new NonSignificantVerbsRule(messages, this, userConfig), new UnnecessaryPhraseRule(messages, this, userConfig), new GermanParagraphRepeatBeginningRule(messages, this), new DuUpperLowerCaseRule(messages), new UnitConversionRule(messages), new MissingCommaRelativeClauseRule(messages), new MissingCommaRelativeClauseRule(messages, true), new RedundantModalOrAuxiliaryVerb(messages), new GermanReadabilityRule(messages, this, userConfig, true), new GermanReadabilityRule(messages, this, userConfig, false), new CompoundInfinitivRule(messages, this, userConfig), new StyleRepeatedVeryShortSentences(messages, this), new StyleRepeatedSentenceBeginning(messages), new GermanRepeatedWordsRule(messages)});
    }

    public CompoundWordTokenizer getNonStrictCompoundSplitter() {
        GermanCompoundTokenizer tokenizer = GermanCompoundTokenizer.getNonStrictInstance();
        return word -> new ArrayList<String>(tokenizer.tokenize(word));
    }

    public GermanCompoundTokenizer getStrictCompoundTokenizer() {
        return GermanCompoundTokenizer.getStrictInstance();
    }

    public synchronized LanguageModel getLanguageModel(File indexDir) throws IOException {
        this.languageModel = this.initLanguageModel(indexDir, this.languageModel);
        return this.languageModel;
    }

    public List<Rule> getRelevantLanguageModelRules(ResourceBundle messages, LanguageModel languageModel, UserConfig userConfig) throws IOException {
        return Arrays.asList(new Rule[]{new UpperCaseNgramRule(messages, languageModel, this), new GermanConfusionProbabilityRule(messages, languageModel, this), new ProhibitedCompoundRule(messages, languageModel, userConfig)});
    }

    public Tokenizer createDefaultWordTokenizer() {
        return new GermanWordTokenizer();
    }

    @Override
    public void close() throws Exception {
        if (this.languageModel != null) {
            this.languageModel.close();
        }
    }

    public String getOpeningDoubleQuote() {
        return "\u201e";
    }

    public String getClosingDoubleQuote() {
        return "\u201c";
    }

    public String getOpeningSingleQuote() {
        return "\u201a";
    }

    public String getClosingSingleQuote() {
        return "\u2018";
    }

    public boolean isAdvancedTypographyEnabled() {
        return true;
    }

    public String toAdvancedTypography(String input) {
        String output = super.toAdvancedTypography(input);
        output = output.replaceAll("\\b([a-zA-Z]\\.)([a-zA-Z]\\.)", "$1\u00a0$2");
        output = output.replaceAll("\\b([a-zA-Z]\\.)([a-zA-Z]\\.)", "$1\u00a0$2");
        return output;
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.ActivelyMaintained;
    }

    protected int getPriorityForId(String id) {
        switch (id) {
            case "DE_PROHIBITED_PHRASE": {
                return 11;
            }
            case "WRONG_SPELLING_PREMIUM_INTERNAL": {
                return 10;
            }
            case "OLD_SPELLING_INTERNAL": {
                return 10;
            }
            case "DE_COMPOUNDS": {
                return 10;
            }
            case "TELEFON_NR": {
                return 10;
            }
            case "IRGEND_COMPOUND": {
                return 10;
            }
            case "DA_DURCH": {
                return 2;
            }
            case "BEI_GOOGLE": {
                return 2;
            }
            case "EINE_ORIGINAL_RECHNUNG_TEST": {
                return 2;
            }
            case "VONSTATTEN_GEHEN": {
                return 2;
            }
            case "VERWECHSLUNG_MIR_DIR_MIR_DIE": {
                return 1;
            }
            case "ERNEUERBARE_ENERGIEN": {
                return 1;
            }
            case "DRIVE_IN": {
                return 1;
            }
            case "AN_STATT": {
                return 1;
            }
            case "VOR_BEI": {
                return 1;
            }
            case "SUB_VER_KLEIN": {
                return 1;
            }
            case "ALLES_GUTE": {
                return 1;
            }
            case "NEUN_NEUEN": {
                return 1;
            }
            case "VERWANDET_VERWANDTE": {
                return 1;
            }
            case "IN_DEUTSCHE_SPRACHE": {
                return 1;
            }
            case "SCHMIERE_STEHEN": {
                return 1;
            }
            case "UEBER_EIN_MANGEL": {
                return 1;
            }
            case "SEIT_LAENGEREN": {
                return 1;
            }
            case "WIR_GEFUEHL": {
                return 1;
            }
            case "VORHER_NACHHER_BILD": {
                return 1;
            }
            case "SEIT_KLEIN_AUF": {
                return 1;
            }
            case "SEIT_GEBURT_AN": {
                return 1;
            }
            case "WO_VON": {
                return 1;
            }
            case "ICH_BIN_STAND_JETZT_KOMMA": {
                return 1;
            }
            case "EIN_LOGGEN": {
                return 1;
            }
            case "ZU_GEN\u00dcGE": {
                return 1;
            }
            case "SEIT_BEKANNT_WERDEN": {
                return 1;
            }
            case "IMPFLICHT": {
                return 1;
            }
            case "NULL_KOMMA_NICHTS": {
                return 1;
            }
            case "ZWEI_AN_HALB": {
                return 1;
            }
            case "BLUETOOTH_LAUTSPRECHER": {
                return 1;
            }
            case "KOENNT_ICH": {
                return 1;
            }
            case "WIR_HABE": {
                return 1;
            }
            case "DAS_IST_GLAUBE_ICH_EGAL": {
                return 1;
            }
            case "ICH_KOENNT": {
                return 1;
            }
            case "HAT_DU": {
                return 1;
            }
            case "HAST_DICH": {
                return 1;
            }
            case "GRUNDE": {
                return 1;
            }
            case "EIN_FACH": {
                return 1;
            }
            case "WOGEN_SUBST": {
                return 1;
            }
            case "SO_WIES_IST": {
                return 1;
            }
            case "SICH_SICHT": {
                return 1;
            }
            case "MIT_VERANTWORTLICH": {
                return 1;
            }
            case "VOR_LACHEN": {
                return 1;
            }
            case "TOUREN_SUBST": {
                return 1;
            }
            case "AUF_DR\u00c4NGEN": {
                return 1;
            }
            case "AUF_ZACK": {
                return 1;
            }
            case "UNTER_DRUCK": {
                return 1;
            }
            case "ZUCCHINIS": {
                return 1;
            }
            case "PASSWORTE": {
                return 1;
            }
            case "ANGL_PA_ED_UNANGEMESSEN": {
                return 1;
            }
            case "ANFUEHRUNGSZEICHEN_DE_AT": {
                return 1;
            }
            case "ANFUEHRUNGSZEICHEN_CH_FR": {
                return 1;
            }
            case "EMAIL": {
                return 1;
            }
            case "IM_STICH_LASSEN": {
                return 1;
            }
            case "ZULANGE": {
                return 1;
            }
            case "ROCK_N_ROLL": {
                return 1;
            }
            case "JOE_BIDEN": {
                return 1;
            }
            case "RESOURCE_RESSOURCE": {
                return 1;
            }
            case "DE_PROHIBITED_COMPOUNDS": {
                return 1;
            }
            case "ANS_OHNE_APOSTROPH": {
                return 1;
            }
            case "DIESEN_JAHRES": {
                return 1;
            }
            case "TAG_EIN_TAG_AUS": {
                return 1;
            }
            case "WERT_SEIN": {
                return 1;
            }
            case "EBEN_FALLS": {
                return 1;
            }
            case "IN_UND_AUSWENDIG": {
                return 1;
            }
            case "HIER_MIT": {
                return 1;
            }
            case "HIER_FUER": {
                return 1;
            }
            case "MIT_REISSEN": {
                return 1;
            }
            case "JEDEN_FALLS": {
                return 1;
            }
            case "MOEGLICHER_WEISE_ETC": {
                return 1;
            }
            case "UST_ID": {
                return 1;
            }
            case "INS_FITNESS": {
                return 1;
            }
            case "MIT_UNTER": {
                return 1;
            }
            case "SEIT_VS_SEID": {
                return 1;
            }
            case "ZU_KOMMEN_LASSEN": {
                return 1;
            }
            case "ZU_SCHICKEN_LASSEN": {
                return 1;
            }
            case "IM_UM": {
                return 1;
            }
            case "EINEN_VERSUCH_WERT": {
                return 1;
            }
            case "DASS_DAS_PA2_DAS_PROIND": {
                return 1;
            }
            case "AUF_BITTEN": {
                return 1;
            }
            case "MEINET_WEGEN": {
                return 1;
            }
            case "FUER_INBESONDERE": {
                return 1;
            }
            case "COVID_19": {
                return 1;
            }
            case "DA_VOR": {
                return 1;
            }
            case "KLEINSCHREIBUNG_MAL": {
                return 1;
            }
            case "VERINF_DAS_DASS_SUB": {
                return 1;
            }
            case "IM_ALTER": {
                return 1;
            }
            case "DAS_ALTER": {
                return 1;
            }
            case "VER_INF_PKT_VER_INF": {
                return 1;
            }
            case "DASS_MIT_VERB": {
                return 1;
            }
            case "AB_TEST": {
                return 1;
            }
            case "BZGL_ABK": {
                return 1;
            }
            case "DURCH_WACHSEN": {
                return 1;
            }
            case "ICH_WARTE": {
                return 1;
            }
            case "RUNDUM_SORGLOS_PAKET": {
                return 1;
            }
            case "MIT_FREUNDLICHEN_GRUESSE": {
                return 1;
            }
            case "OK": {
                return 1;
            }
            case "EINE_ORIGINAL_RECHNUNG": {
                return 1;
            }
            case "VALENZ_TEST": {
                return 1;
            }
            case "WAEHRUNGSANGABEN_CHF": {
                return 1;
            }
            case "FALSCHES_ANFUEHRUNGSZEICHEN": {
                return -1;
            }
            case "VER_KOMMA_PRO_RIN": {
                return -1;
            }
            case "DE_PROHIBITED_COMPOUNDS_PREMIUM": {
                return -1;
            }
            case "VER_INF_VER_INF": {
                return -1;
            }
            case "DE_COMPOUND_COHERENCY": {
                return -1;
            }
            case "GEFEATURED": {
                return -1;
            }
            case "NUMBER_SUB": {
                return -1;
            }
            case "VER123_VERAUXMOD": {
                return -1;
            }
            case "DE_AGREEMENT": {
                return -1;
            }
            case "DE_AGREEMENT2": {
                return -1;
            }
            case "CONFUSION_RULE": {
                return -1;
            }
            case "KOMMA_NEBEN_UND_HAUPTSATZ": {
                return -1;
            }
            case "FALSCHES_RELATIVPRONOMEN": {
                return -1;
            }
            case "AKZENT_STATT_APOSTROPH": {
                return -1;
            }
            case "BEENDE_IST_SENTEND": {
                return -1;
            }
            case "VER_ADJ_ZU_SCHLAFEN": {
                return -1;
            }
            case "MIO_PUNKT": {
                return -1;
            }
            case "AUSLASSUNGSPUNKTE_LEERZEICHEN": {
                return -1;
            }
            case "IM_ERSCHEINUNG": {
                return -1;
            }
            case "SPACE_BEFORE_OG": {
                return -1;
            }
            case "VERSEHENTLICHERWEISE": {
                return -1;
            }
            case "VERMOD_SKIP_VER_PKT": {
                return -1;
            }
            case "EINZELBUCHSTABE_PREMIUM": {
                return -1;
            }
            case "ART_IND_ADJ_SUB": {
                return -2;
            }
            case "KATARI": {
                return -2;
            }
            case "SCHOENE_WETTER": {
                return -2;
            }
            case "MEIN_KLEIN_HAUS": {
                return -2;
            }
            case "UNPAIRED_BRACKETS": {
                return -2;
            }
            case "ICH_GLAUBE_FUER_EUCH": {
                return -2;
            }
            case "OBJECT_AGREEMENT": {
                return -2;
            }
            case "ICH_INF_PREMIUM": {
                return -2;
            }
            case "MEHRERE_WOCHE_PREMIUM": {
                return -2;
            }
            case "DOPPELTER_NOMINATIV": {
                return -2;
            }
            case "KUDAMM": {
                return -2;
            }
            case "ALTERNATIVEN_FUER_ANGLIZISMEN": {
                return -2;
            }
            case "ANGLIZISMUS_INTERNAL": {
                return -2;
            }
            case "DOPPELUNG_VER_MOD_AUX": {
                return -2;
            }
            case "AERZTEN_INNEN": {
                return -2;
            }
            case "ANGLIZISMEN": {
                return -2;
            }
            case "ANGLIZISMUS_PA_MIT_ED": {
                return -2;
            }
            case "MEINSTE": {
                return -2;
            }
            case "ZAHL_IM_WORT": {
                return -2;
            }
            case "ICH_LIEBS": {
                return -2;
            }
            case "ICH_GEHE_DU_BLEIBST": {
                return -3;
            }
            case "GERMAN_SPELLER_RULE": {
                return -3;
            }
            case "AUSTRIAN_GERMAN_SPELLER_RULE": {
                return -3;
            }
            case "SWISS_GERMAN_SPELLER_RULE": {
                return -3;
            }
            case "DE_VERBAGREEMENT": {
                return -4;
            }
            case "PUNKT_ENDE_DIREKTE_REDE": {
                return -4;
            }
            case "LEERZEICHEN_NACH_VOR_ANFUEHRUNGSZEICHEN": {
                return -4;
            }
            case "ZEICHENSETZUNG_DIREKTE_REDE": {
                return -4;
            }
            case "GROSSSCHREIBUNG_WOERTLICHER_REDE": {
                return -4;
            }
            case "IM_IHM": {
                return -4;
            }
            case "IN_UNKNOWNKLEIN_VER": {
                return -4;
            }
            case "SEHR_GEEHRTER_NAME": {
                return -4;
            }
            case "DE_PHRASE_REPETITION": {
                return -4;
            }
            case "FRAGEZEICHEN_NACH_DIREKTER_REDE": {
                return -4;
            }
            case "PUNCTUATION_PARAGRAPH_END": {
                return -4;
            }
            case "TEST_F_ANSTATT_PH": {
                return -4;
            }
            case "DAS_WETTER_IST": {
                return -5;
            }
            case "VEREIZ_VERINF_PKT": {
                return -5;
            }
            case "WER_STARK_SCHWITZ": {
                return -5;
            }
            case "VERBEN_PRAEFIX_AUS": {
                return -5;
            }
            case "ANFUEHRUNG_VERSCHACHTELT": {
                return -5;
            }
            case "SATZBAU_AN_DEN_KOMMT": {
                return -5;
            }
            case "SUBJECT_VERB_AGREEMENT": {
                return -5;
            }
            case "SAGT_SAGT": {
                return -9;
            }
            case "PUNKT_ENDE_ABSATZ": {
                return -10;
            }
            case "KOMMA_VOR_RELATIVSATZ": {
                return -10;
            }
            case "VON_LEBENSLAEUFE": {
                return -12;
            }
            case "ZUSAMMENGESETZTE_VERBEN": {
                return -12;
            }
            case "PRP_VER_PRGK": {
                return -13;
            }
            case "COMMA_IN_FRONT_RELATIVE_CLAUSE": {
                return -13;
            }
            case "SAGT_RUFT": {
                return -13;
            }
            case "KOMMA_ZWISCHEN_HAUPT_UND_NEBENSATZ_2": {
                return -14;
            }
            case "BEI_VERB": {
                return -14;
            }
            case "MODALVERB_FLEKT_VERB": {
                return -14;
            }
            case "DATIV_NACH_PRP": {
                return -14;
            }
            case "DAT_ODER_AKK_NACH_PRP": {
                return -14;
            }
            case "SENT_START_SIN_PLU": {
                return -14;
            }
            case "SENT_START_PLU_SIN": {
                return -14;
            }
            case "VER_INFNOMEN": {
                return -14;
            }
            case "GERMAN_WORD_REPEAT_RULE": {
                return -15;
            }
            case "TOO_LONG_PARAGRAPH": {
                return -15;
            }
            case "ALL_UPPERCASE": {
                return -15;
            }
            case "NUR_LEDIGLICH": {
                return -16;
            }
            case "COMMA_BEHIND_RELATIVE_CLAUSE": {
                return -52;
            }
            case "DOPPELUNG_MODALVERB": {
                return -52;
            }
            case "VER_DOPPELUNG": {
                return -52;
            }
            case "DEF_ARTIKEL_INDEF_ADJ": {
                return -52;
            }
            case "PRP_ADJ_AGREEMENT": {
                return -52;
            }
            case "SIE_WOLLTEN_SIND": {
                return -52;
            }
            case "ART_ADJ_SOL": {
                return -52;
            }
            case "WURDEN_WORDEN_1": {
                return -52;
            }
            case "WAR_WAHR": {
                return -52;
            }
            case "KOMMA_ZWISCHEN_HAUPT_UND_NEBENSATZ": {
                return -53;
            }
            case "VERB_IST": {
                return -53;
            }
            case "WAR_WERDEN": {
                return -53;
            }
            case "INF_VER_MOD": {
                return -53;
            }
            case "VERB_FEM_SUBST": {
                return -54;
            }
            case "SUBJUNKTION_KOMMA_2": {
                return -54;
            }
            case "DOPPELUNG_GLEICHES_VERB": {
                return -55;
            }
            case "FEHLENDES_NOMEN": {
                return -60;
            }
            case "REPETITIONS_STYLE": {
                return -60;
            }
            case "MAN_SIEHT_SEHR_SCHOEN": {
                return -14;
            }
            case "TYPOGRAPHY": {
                return -14;
            }
            case "COLLOQUIALISMS": {
                return -15;
            }
            case "STYLE": {
                return -15;
            }
            case "REDUNDANCY": {
                return -15;
            }
            case "GENDER_NEUTRALITY": {
                return -15;
            }
        }
        if (id.startsWith("CONFUSION_RULE_")) {
            return -1;
        }
        if (id.startsWith("AI_DE_HYDRA_LEO")) {
            if (id.startsWith("AI_DE_HYDRA_LEO_MISSING_COMMA")) {
                return -51;
            }
            if (id.startsWith("AI_DE_HYDRA_LEO_CP")) {
                return 2;
            }
            if (id.startsWith("AI_DE_HYDRA_LEO_DATAKK")) {
                return 1;
            }
            return -11;
        }
        if (id.startsWith("AI_DE_KOMMA")) {
            return -52;
        }
        return super.getPriorityForId(id);
    }

    public boolean hasMinMatchesRules() {
        return true;
    }
}

