/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import morfologik.speller.Speller;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.AbstractStyleRepeatedWordRule;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.spelling.morfologik.MorfologikSpeller;
import org.languagetool.tools.StringTools;

public class GermanStyleRepeatedWordRule
extends AbstractStyleRepeatedWordRule {
    private static final String SYNONYMS_URL = "https://www.openthesaurus.de/synonyme/";
    private Speller speller = null;

    public GermanStyleRepeatedWordRule(ResourceBundle messages, Language lang, UserConfig userConfig) {
        super(messages, lang, userConfig);
        super.setCategory(Categories.STYLE.getCategory(messages));
        this.addExamplePair(Example.wrong((String)"Ich gehe zum Supermarkt, danach <marker>gehe</marker> ich nach Hause."), Example.fixed((String)"Ich gehe zum Supermarkt, danach nach Hause."));
    }

    public String getId() {
        return "STYLE_REPEATED_WORD_RULE_DE";
    }

    public String getDescription() {
        return "Wiederholte Worte in aufeinanderfolgenden S\u00e4tzen";
    }

    protected String messageSameSentence() {
        return "M\u00f6gliches Stilproblem: Das Wort wird bereits im selben Satz verwendet.";
    }

    protected String messageSentenceBefore() {
        return "M\u00f6gliches Stilproblem: Das Wort wird bereits in einem vorhergehenden Satz verwendet.";
    }

    protected String messageSentenceAfter() {
        return "M\u00f6gliches Stilproblem: Das Wort wird bereits in einem nachfolgenden Satz verwendet.";
    }

    private boolean isCorrectSpell(String word) {
        word = StringTools.uppercaseFirstChar((String)word);
        if (this.linguServices == null && this.speller == null) {
            this.speller = new Speller(MorfologikSpeller.getDictionaryWithCaching((String)"/de/hunspell/de_DE.dict"));
        }
        if (this.linguServices == null && this.speller != null) {
            return !this.speller.isMisspelled(word);
        }
        if (this.linguServices != null) {
            return this.linguServices.isCorrectSpell(word, this.lang);
        }
        throw new IllegalStateException("LinguServices or Speller must be not null to check spelling in CompoundInfinitivRule");
    }

    private static boolean isUnknownWord(AnalyzedTokenReadings token) {
        return token.isPosTagUnknown() && token.getToken().length() > 2 && token.getToken().matches("^[A-Za-z\u00c4\u00d6\u00dc\u00e4\u00f6\u00fc\u00df]+$");
    }

    protected boolean isTokenToCheck(AnalyzedTokenReadings token) {
        return (token.matchesPosTagRegex("(SUB|EIG|VER|ADJ):.*") && !token.matchesPosTagRegex("(PRO|A(RT|DV)|VER:(AUX|MOD)):.*") || GermanStyleRepeatedWordRule.isUnknownWord(token)) && !StringUtils.equalsAny((CharSequence)token.getToken(), (CharSequence[])new CharSequence[]{"sicher", "weit", "Sie", "Ich", "Euch", "Eure", "all"});
    }

    protected boolean isTokenPair(AnalyzedTokenReadings[] tokens, int n, boolean before) {
        return before ? tokens[n - 2].hasPosTagStartingWith("SUB") && tokens[n - 1].hasPosTagStartingWith("PRP") && tokens[n].hasPosTagStartingWith("SUB") || !tokens[n - 2].getToken().equals("hart") && !tokens[n - 1].getToken().equals("auf") && !tokens[n].getToken().equals("hart") : tokens[n].hasPosTagStartingWith("SUB") && tokens[n + 1].hasPosTagStartingWith("PRP") && tokens[n + 2].hasPosTagStartingWith("SUB") || !tokens[n].getToken().equals("hart") && !tokens[n - 1].getToken().equals("auf") && !tokens[n + 2].getToken().equals("hart");
    }

    private boolean isSecondPartofWord(String testTokenText, String tokenText) {
        if (testTokenText.length() - tokenText.length() < 3) {
            return false;
        }
        if (StringTools.uppercaseFirstChar((String)testTokenText).startsWith(StringTools.uppercaseFirstChar((String)tokenText))) {
            String word = testTokenText.substring(tokenText.length());
            if (this.isCorrectSpell(word)) {
                return true;
            }
            return word.startsWith("s") && this.isCorrectSpell(word = word.substring(1));
        }
        if (testTokenText.endsWith(StringTools.lowercaseFirstChar((String)tokenText))) {
            String word = testTokenText.substring(0, testTokenText.length() - tokenText.length());
            if (this.isCorrectSpell(word)) {
                return true;
            }
            return word.endsWith("s") && this.isCorrectSpell(word = word.substring(word.length() - 1));
        }
        return false;
    }

    protected boolean isPartOfWord(String testTokenText, String tokenText) {
        if (testTokenText.length() < 3 || tokenText.length() < 3) {
            return false;
        }
        if (testTokenText.length() > tokenText.length()) {
            return this.isSecondPartofWord(testTokenText, tokenText);
        }
        return this.isSecondPartofWord(tokenText, testTokenText);
    }

    protected boolean isExceptionPair(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2) {
        return token1.hasLemma("nah") && token1.hasLemma("n\u00e4chst") && !token2.hasLemma("n\u00e4chst") || token2.hasLemma("nah") && token2.hasLemma("n\u00e4chst") && !token1.hasLemma("n\u00e4chst");
    }

    protected URL setURL(AnalyzedTokenReadings token) throws MalformedURLException {
        if (token != null) {
            List readings = token.getReadings();
            ArrayList<String> lemmas = new ArrayList<String>();
            for (AnalyzedToken reading : readings) {
                String lemma = reading.getLemma();
                if (lemma == null) continue;
                lemmas.add(lemma);
            }
            if (lemmas.size() == 1) {
                return new URL(SYNONYMS_URL + (String)lemmas.get(0));
            }
            return new URL(SYNONYMS_URL + token.getToken());
        }
        return null;
    }
}

