/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;

public class StyleRepeatedSentenceBeginning
extends TextLevelRule {
    private static final int MIN_REPEATED = 3;

    public StyleRepeatedSentenceBeginning(ResourceBundle messages) {
        super(messages);
        super.setCategory(new Category(new CategoryId("CREATIVE_WRITING"), messages.getString("category_creative_writing"), Category.Location.INTERNAL, false));
        this.setDefaultOff();
        this.setLocQualityIssueType(ITSIssueType.Style);
        this.addExamplePair(Example.wrong((String)"<marker>Das Auto</marker> kam n\u00e4her. <marker>Der Hund</marker> lief langsam \u00fcber die Stra\u00dfe. <marker>Die Reifen</marker> quietschten."), Example.fixed((String)"Das Auto kam n\u00e4her. Langsam lief der Hund \u00fcber die Stra\u00dfe. Die Reifen quietschten."));
    }

    public RuleMatch[] match(List<AnalyzedSentence> sentences) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        if (sentences.size() < 3) {
            return this.toRuleMatchArray(ruleMatches);
        }
        ArrayList<Integer> startPos = new ArrayList<Integer>();
        ArrayList<Integer> endPos = new ArrayList<Integer>();
        ArrayList<AnalyzedSentence> repeatedSentences = new ArrayList<AnalyzedSentence>();
        int pos = 0;
        int nRepeated = 0;
        for (AnalyzedSentence sentence : sentences) {
            AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
            if (tokens[1].hasPosTagStartingWith("ART:DEF:NOM") || tokens[1].hasPosTagStartingWith("ART:IND:NOM")) {
                boolean noSub = true;
                for (int i = 2; i < tokens.length && !tokens[i].hasPosTagStartingWith("VER"); ++i) {
                    if (!tokens[i].hasPosTagStartingWith("SUB")) continue;
                    noSub = false;
                    endPos.add(tokens[i].getEndPos() + pos);
                    break;
                }
                if (noSub) {
                    endPos.add(tokens[1].getEndPos() + pos);
                }
                repeatedSentences.add(sentence);
                startPos.add(tokens[1].getStartPos() + pos);
                ++nRepeated;
            } else if (tokens[1].hasPosTagStartingWith("PRO:PER:NOM")) {
                repeatedSentences.add(sentence);
                startPos.add(tokens[1].getStartPos() + pos);
                endPos.add(tokens[1].getEndPos() + pos);
                ++nRepeated;
            } else {
                if (nRepeated >= 3) {
                    for (int i = 0; i < repeatedSentences.size(); ++i) {
                        RuleMatch ruleMatch = new RuleMatch((Rule)this, (AnalyzedSentence)repeatedSentences.get(i), ((Integer)startPos.get(i)).intValue(), ((Integer)endPos.get(i)).intValue(), this.getDescription());
                        ruleMatches.add(ruleMatch);
                    }
                }
                repeatedSentences.clear();
                startPos.clear();
                endPos.clear();
                nRepeated = 0;
            }
            pos += sentence.getCorrectedTextLength();
        }
        if (nRepeated >= 3) {
            for (int i = 0; i < repeatedSentences.size(); ++i) {
                RuleMatch ruleMatch = new RuleMatch((Rule)this, (AnalyzedSentence)repeatedSentences.get(i), ((Integer)startPos.get(i)).intValue(), ((Integer)endPos.get(i)).intValue(), this.getDescription());
                ruleMatches.add(ruleMatch);
            }
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    public int minToCheckParagraph() {
        return 3;
    }

    public String getId() {
        return "STYLE_REPEATED_SENTENCE_BEGINNING";
    }

    public String getDescription() {
        return "Subjekt als wiederholter Satzanfang";
    }
}

