/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.language.German;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.de.CaseRuleAntiPatterns;
import org.languagetool.rules.de.CaseRuleExceptions;
import org.languagetool.rules.de.GermanHelper;
import org.languagetool.rules.de.GermanSpellerRule;
import org.languagetool.rules.de.LanguageNames;
import org.languagetool.rules.patterns.StringMatcher;
import org.languagetool.tagging.de.GermanTagger;
import org.languagetool.tagging.de.GermanToken;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tools.StringTools;
import org.languagetool.tools.Tools;

public class CaseRule
extends Rule {
    private static final Pattern NUMERALS_EN = Pattern.compile("[a-z]|[0-9]+|(m{0,4}(c[md]|d?c{0,3})(x[cl]|l?x{0,3})(i[xv]|v?i{0,3}))$");
    private static final Set<String> nounIndicators = new HashSet<String>();
    private static final String UPPERCASE_MESSAGE = "Au\u00dfer am Satzanfang werden nur Nomen und Eigennamen gro\u00dfgeschrieben.";
    private static final String LOWERCASE_MESSAGE = "Falls es sich um ein substantiviertes Verb handelt, wird es gro\u00dfgeschrieben.";
    private static final String COLON_MESSAGE = "Folgt dem Doppelpunkt weder ein Substantiv noch eine w\u00f6rtliche Rede oder ein vollst\u00e4ndiger Hauptsatz, schreibt man klein weiter.";
    private static final String[] SENTENCE_START_EXCEPTIONS;
    private static final String[] UNDEFINED_QUANTIFIERS;
    private static final String[] INTERROGATIVE_PARTICLES;
    private static final String[] POSSESSIVE_INDICATORS;
    private static final String[] DAS_VERB_EXCEPTIONS;
    private static final String[] exceptions;
    private static final Set<StringMatcher[]> exceptionPatterns;
    private static final Set<String> substVerbenExceptions;
    private final GermanTagger tagger;
    private final GermanSpellerRule speller;
    private final Supplier<List<DisambiguationPatternRule>> antiPatterns;

    public CaseRule(ResourceBundle messages, German german) {
        super.setCategory(Categories.CASING.getCategory(messages));
        this.tagger = (GermanTagger)german.getTagger();
        this.speller = new GermanSpellerRule(JLanguageTool.getMessageBundle(), german);
        this.antiPatterns = CaseRule.cacheAntiPatterns((Language)german, CaseRuleAntiPatterns.ANTI_PATTERNS);
        this.addExamplePair(Example.wrong((String)"<marker>Das laufen</marker> f\u00e4llt mir schwer."), Example.fixed((String)"<marker>Das Laufen</marker> f\u00e4llt mir schwer."));
    }

    public String getId() {
        return "DE_CASE";
    }

    public int estimateContextForSureMatch() {
        return CaseRuleAntiPatterns.ANTI_PATTERNS.stream().mapToInt(List::size).max().orElse(0);
    }

    public URL getUrl() {
        return Tools.getUrl((String)"https://dict.leo.org/grammatik/deutsch/Rechtschreibung/Regeln/Gross-klein/index.html");
    }

    public String getDescription() {
        return "Gro\u00dfschreibung von Nomen und substantivierten Verben";
    }

    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = this.getSentenceWithImmunization(sentence).getTokensWithoutWhitespace();
        boolean prevTokenIsDas = false;
        boolean isPrecededByModalOrAuxiliary = false;
        for (int i = 0; i < tokens.length; ++i) {
            boolean isBaseform;
            String posToken = tokens[i].getAnalyzedToken(0).getPOSTag();
            if ("SENT_START".equals(posToken)) continue;
            if (i == 1) {
                prevTokenIsDas = nounIndicators.contains(tokens[1].getToken().toLowerCase());
                continue;
            }
            if (i > 0 && (this.isSalutation(tokens[i - 1].getToken()) || this.isCompany(tokens[i - 1].getToken())) || i > 2 && NUMERALS_EN.matcher(tokens[i - 1].getToken()).matches() && this.isDot(tokens[i - 2].getToken()) && NUMERALS_EN.matcher(tokens[i - 3].getToken()).matches()) continue;
            AnalyzedTokenReadings analyzedToken = tokens[i];
            String token = analyzedToken.getToken();
            boolean bl = isBaseform = analyzedToken.getReadingsLength() >= 1 && analyzedToken.hasLemma(token);
            if ((analyzedToken.getAnalyzedToken(0).getPOSTag() == null || GermanHelper.hasReadingOfType(analyzedToken, GermanToken.POSType.VERB)) && isBaseform) {
                boolean nextTokenIsPersonalOrReflexivePronoun = false;
                if (i < tokens.length - 1) {
                    AnalyzedTokenReadings nextToken = tokens[i + 1];
                    boolean bl2 = nextTokenIsPersonalOrReflexivePronoun = nextToken.hasPartialPosTag("PRO:PER") || StringUtils.equalsAny((CharSequence)nextToken.getToken(), (CharSequence[])new CharSequence[]{"sich", "Sie"});
                    if (nextToken.hasPosTag("PKT") || prevTokenIsDas && (StringUtils.equalsAny((CharSequence)nextToken.getToken(), (CharSequence[])DAS_VERB_EXCEPTIONS) || this.isFollowedByRelativeOrSubordinateClause(i, tokens)) || i > 1 && this.hasPartialTag(tokens[i - 2], "VER:AUX", "VER:MOD")) continue;
                }
                if (this.isPrevProbablyRelativePronoun(tokens, i) || prevTokenIsDas && this.getTokensWithPosTagStartingWithCount(tokens, "VER") == 1) continue;
                this.potentiallyAddLowercaseMatch(ruleMatches, tokens[i], prevTokenIsDas, token, nextTokenIsPersonalOrReflexivePronoun, sentence);
            }
            prevTokenIsDas = nounIndicators.contains(tokens[i].getToken().toLowerCase());
            if (analyzedToken.matchesPosTagRegex("VER:(MOD|AUX):[1-3]:.*")) {
                isPrecededByModalOrAuxiliary = true;
            }
            AnalyzedTokenReadings lowercaseReadings = this.tagger.lookup(token.toLowerCase());
            if (!this.hasNounReading(analyzedToken) ? analyzedToken.hasPosTagStartingWith("SUB:") && i < tokens.length - 1 && Character.isLowerCase(tokens[i + 1].getToken().charAt(0)) && tokens[i + 1].matchesPosTagRegex("(VER:[123]:|PA2).+") : !this.isPotentialUpperCaseError(i, tokens, lowercaseReadings, isPrecededByModalOrAuxiliary)) continue;
            if (analyzedToken.getAnalyzedToken(0).getPOSTag() == null && lowercaseReadings == null || analyzedToken.getAnalyzedToken(0).getPOSTag() == null && lowercaseReadings != null && (lowercaseReadings.getAnalyzedToken(0).getPOSTag() == null || analyzedToken.getToken().endsWith("innen"))) continue;
            this.potentiallyAddUppercaseMatch(ruleMatches, tokens, i, analyzedToken, token, lowercaseReadings, sentence);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private int getTokensWithPosTagStartingWithCount(AnalyzedTokenReadings[] tokens, String partialPosTag) {
        return Arrays.stream(tokens).filter(token -> token.hasPosTagStartingWith(partialPosTag)).mapToInt(e -> 1).sum();
    }

    private boolean isPotentialUpperCaseError(int pos, AnalyzedTokenReadings[] tokens, AnalyzedTokenReadings lowercaseReadings, boolean isPrecededByModalOrAuxiliary) {
        boolean isPotentialError;
        if (pos <= 1) {
            return false;
        }
        if ("zu".equals(tokens[pos - 1].getToken()) && !tokens[pos].matchesPosTagRegex(".*(NEU|MAS|FEM)$") && lowercaseReadings != null && lowercaseReadings.hasPosTagStartingWith("VER:INF")) {
            return true;
        }
        if (tokens[pos].getToken().matches(".+verhalten")) {
            return false;
        }
        boolean bl = isPotentialError = pos < tokens.length - 3 && tokens[pos + 1].getToken().equals(",") && StringUtils.equalsAny((CharSequence)tokens[pos + 2].getToken(), (CharSequence[])INTERROGATIVE_PARTICLES) && tokens[pos - 1].hasPosTagStartingWith("VER:MOD") && !tokens[pos - 1].hasLemma("m\u00f6gen") && !tokens[pos + 3].getToken().equals("zum");
        if (!isPotentialError && lowercaseReadings != null && tokens[pos].hasAnyPartialPosTag(new String[]{"SUB:NOM:SIN:NEU:INF", "SUB:DAT:PLU:"}) && ("zu".equals(tokens[pos - 1].getToken()) || this.hasPartialTag(tokens[pos - 1], "SUB", "EIG", "VER:AUX:3:", "ADV:TMP", "ABK"))) {
            isPotentialError |= lowercaseReadings.hasPosTag("PA2:PRD:GRU:VER") && !tokens[pos - 1].hasPosTagStartingWith("VER:AUX:3") && !lowercaseReadings.hasPosTag("VER:3:PLU:PRT:NON");
            isPotentialError |= !(pos < tokens.length - 2 && !",".equals(tokens[pos + 1].getToken()) || !"zu".equals(tokens[pos - 1].getToken()) && !isPrecededByModalOrAuxiliary || !tokens[pos].getToken().startsWith("\u00dcber") || !lowercaseReadings.hasAnyPartialPosTag(new String[]{"VER:INF:", "PA2:PRD:GRU:VER"}));
        }
        return isPotentialError;
    }

    public List<DisambiguationPatternRule> getAntiPatterns() {
        return this.antiPatterns.get();
    }

    private boolean isPrevProbablyRelativePronoun(AnalyzedTokenReadings[] tokens, int i) {
        return i >= 3 && tokens[i - 1].getToken().equals("das") && tokens[i - 2].getToken().equals(",") && tokens[i - 3].matchesPosTagRegex("SUB:...:SIN:NEU");
    }

    private boolean isSalutation(String token) {
        return StringUtils.equalsAny((CharSequence)token, (CharSequence[])new CharSequence[]{"Herr", "Hr", "Herrn", "Frau", "Fr", "Fr\u00e4ulein"});
    }

    private boolean isCompany(String token) {
        return StringUtils.equalsAny((CharSequence)token, (CharSequence[])new CharSequence[]{"Firma", "Familie", "Unternehmen", "Firmen", "B\u00e4ckerei", "Metzgerei", "Fa"});
    }

    private boolean isDot(String token) {
        return token.equals(".");
    }

    private boolean hasNounReading(AnalyzedTokenReadings readings) {
        if (readings != null) {
            if (readings.hasPosTagStartingWith("ABK") && readings.hasPartialPosTag("SUB")) {
                return true;
            }
            AnalyzedTokenReadings allReadings = this.lookup(readings.getToken().replaceAll("\\u00AD", ""));
            if (allReadings != null) {
                for (AnalyzedToken reading : allReadings) {
                    String posTag = reading.getPOSTag();
                    if (posTag == null || !posTag.contains("SUB:") || posTag.contains(":ADJ")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void potentiallyAddLowercaseMatch(List<RuleMatch> ruleMatches, AnalyzedTokenReadings tokenReadings, boolean prevTokenIsDas, String token, boolean nextTokenIsPersonalOrReflexivePronoun, AnalyzedSentence sentence) {
        if (prevTokenIsDas && !nextTokenIsPersonalOrReflexivePronoun && Character.isLowerCase(token.charAt(0)) && !substVerbenExceptions.contains(token) && tokenReadings.hasPosTagStartingWith("VER:INF") && !tokenReadings.isIgnoredBySpeller() && !tokenReadings.isImmunized()) {
            this.addRuleMatch(ruleMatches, sentence, LOWERCASE_MESSAGE, tokenReadings, StringTools.uppercaseFirstChar((String)tokenReadings.getToken()));
        }
    }

    private void potentiallyAddUppercaseMatch(List<RuleMatch> ruleMatches, AnalyzedTokenReadings[] tokens, int i, AnalyzedTokenReadings analyzedToken, String token, AnalyzedTokenReadings lowercaseReadings, AnalyzedSentence sentence) {
        boolean isUpperFirst = Character.isUpperCase(token.charAt(0));
        String lcWord = StringTools.lowercaseFirstChar((String)tokens[i].getToken());
        if (!(!isUpperFirst || token.length() <= 1 || tokens[i].isIgnoredBySpeller() || tokens[i].isImmunized() || StringUtils.equalsAny((CharSequence)tokens[i - 1].getToken(), (CharSequence[])SENTENCE_START_EXCEPTIONS) || StringUtils.equalsAny((CharSequence)token, (CharSequence[])exceptions) || StringTools.isAllUppercase((String)token) || this.isLanguage(i, tokens, token) || this.isProbablyCity(i, tokens, token) || GermanHelper.hasReadingOfType(analyzedToken, GermanToken.POSType.PROPER_NOUN) || analyzedToken.isSentenceEnd() || this.isEllipsis(i, tokens) || this.isNumbering(i, tokens) || this.isNominalization(i, tokens, token, lowercaseReadings) || this.isAdverbAndNominalization(i, tokens) || this.isSpecialCase(i, tokens) || this.isAdjectiveAsNoun(i, tokens, lowercaseReadings) || this.isSingularImperative(lowercaseReadings, tokens[i]) || this.isExceptionPhrase(i, tokens) || i == 2 && "\u201c".equals(tokens[i - 1].getToken()) || this.isCaseTypo(tokens[i].getToken()) || this.followedByGenderGap(tokens, i) || this.isNounWithVerbReading(i, tokens) || this.speller.isMisspelled(lcWord))) {
            if (":".equals(tokens[i - 1].getToken())) {
                AnalyzedTokenReadings[] subarray = new AnalyzedTokenReadings[i];
                System.arraycopy(tokens, 0, subarray, 0, i);
                if (!this.isVerbFollowing(i, tokens, lowercaseReadings) && this.getTokensWithPosTagStartingWithCount(subarray, "VER") != 0) {
                    this.addRuleMatch(ruleMatches, sentence, COLON_MESSAGE, tokens[i], lcWord);
                }
                return;
            }
            this.addRuleMatch(ruleMatches, sentence, UPPERCASE_MESSAGE, tokens[i], lcWord);
        }
    }

    private boolean followedByGenderGap(AnalyzedTokenReadings[] tokens, int i) {
        return i + 2 < tokens.length && tokens[i + 1].getToken().equals(":") && tokens[i + 2].getToken().matches("in|innen");
    }

    private boolean isCaseTypo(String token) {
        return token.matches("[A-Z\u00d6\u00c4\u00dc][A-Z\u00d6\u00c4\u00dc][a-z\u00f6\u00e4\u00fc\u00df-]+");
    }

    private boolean isSingularImperative(AnalyzedTokenReadings lowercaseReadings, AnalyzedTokenReadings token) {
        return lowercaseReadings != null && lowercaseReadings.hasPosTagStartingWith("VER:IMP:SIN") && !"Ein".equals(token.getToken()) && !"Eine".equals(token.getToken());
    }

    private boolean isNounWithVerbReading(int i, AnalyzedTokenReadings[] tokens) {
        return tokens[i].hasPosTagStartingWith("SUB") && tokens[i].hasPosTagStartingWith("VER:INF");
    }

    private boolean isVerbFollowing(int i, AnalyzedTokenReadings[] tokens, AnalyzedTokenReadings lowercaseReadings) {
        AnalyzedTokenReadings[] subarray = new AnalyzedTokenReadings[tokens.length - i];
        System.arraycopy(tokens, i, subarray, 0, subarray.length);
        if (lowercaseReadings != null) {
            subarray[0] = lowercaseReadings;
        }
        return this.getTokensWithPosTagStartingWithCount(subarray, "VER:") != 0;
    }

    private void addRuleMatch(List<RuleMatch> ruleMatches, AnalyzedSentence sentence, String msg, AnalyzedTokenReadings tokenReadings, String fixedWord) {
        RuleMatch ruleMatch = new RuleMatch((Rule)this, sentence, tokenReadings.getStartPos(), tokenReadings.getEndPos(), msg);
        ruleMatch.setSuggestedReplacement(fixedWord);
        ruleMatches.add(ruleMatch);
    }

    private boolean isNumbering(int i, AnalyzedTokenReadings[] tokens) {
        return i >= 2 && StringUtils.equalsAny((CharSequence)tokens[i - 1].getToken(), (CharSequence[])new CharSequence[]{")", "]"}) && NUMERALS_EN.matcher(tokens[i - 2].getToken()).matches() && (i <= 3 || !tokens[i - 3].getToken().equals("(") || !tokens[i - 4].hasPosTagStartingWith("SUB:"));
    }

    private boolean isEllipsis(int i, AnalyzedTokenReadings[] tokens) {
        return StringUtils.equalsAny((CharSequence)tokens[i - 1].getToken(), (CharSequence[])new CharSequence[]{"]", ")"}) && (i == 4 && tokens[i - 2].getToken().equals("\u2026") || i == 6 && tokens[i - 2].getToken().equals("."));
    }

    private boolean isNominalization(int i, AnalyzedTokenReadings[] tokens, String token, AnalyzedTokenReadings lowercaseReadings) {
        AnalyzedTokenReadings nextReadings;
        AnalyzedTokenReadings analyzedTokenReadings = nextReadings = i < tokens.length - 1 ? tokens[i + 1] : null;
        if (!(!StringTools.startsWithUppercase((String)token) || this.isNumber(token) || this.hasNounReading(nextReadings) || nextReadings != null && StringUtils.isNumeric((CharSequence)nextReadings.getToken()) || token.matches("Alle[nm]"))) {
            String prevTokenStr;
            if (lowercaseReadings != null && lowercaseReadings.hasPosTag("PRP:LOK+TMP+CAU:DAT+AKK")) {
                return false;
            }
            AnalyzedTokenReadings prevToken = i > 0 ? tokens[i - 1] : null;
            AnalyzedTokenReadings prevPrevToken = i >= 2 ? tokens[i - 2] : null;
            AnalyzedTokenReadings prevPrevPrevToken = i >= 3 ? tokens[i - 3] : null;
            String string = prevTokenStr = prevToken != null ? prevToken.getToken() : "";
            if (StringUtils.equalsAny((CharSequence)prevTokenStr, (CharSequence[])new CharSequence[]{"und", "oder", "beziehungsweise"}) && prevPrevToken != null && tokens[i].hasPartialPosTag("SUB") && tokens[i].hasPartialPosTag(":ADJ") || prevPrevToken.hasPartialPosTag("SUB") && !this.hasNounReading(nextReadings) && lowercaseReadings != null && lowercaseReadings.hasPartialPosTag("ADJ") && !prevTokenStr.equals(",")) {
                return true;
            }
            if (lowercaseReadings != null && lowercaseReadings.hasPosTag("PA1:PRD:GRU:VER")) {
                return false;
            }
            return prevToken != null && prevTokenStr.matches("irgendwelche|irgendwas|irgendein|weniger?|einiger?|mehr|aufs") && tokens[i].hasPartialPosTag("SUB") || this.isNumber(prevTokenStr) || this.hasPartialTag(prevToken, "ART", "PRO:") && ((i >= 4 || tokens.length <= 4) && prevToken.getReadings().size() != 1 && !prevPrevToken.hasLemma("sein") || !prevToken.hasPosTagStartingWith("PRO:PER:NOM:")) && !prevToken.hasPartialPosTag(":STD") || this.hasPartialTag(prevPrevPrevToken, "ART") && this.hasPartialTag(prevPrevToken, "PRP") && this.hasPartialTag(prevToken, "SUB") || this.hasPartialTag(prevPrevToken, "PRO:", "PRP") && this.hasPartialTag(prevToken, "ADJ", "ADV", "PA2", "PA1") || this.hasPartialTag(prevPrevPrevToken, "PRO:", "PRP") && this.hasPartialTag(prevPrevToken, "ADJ", "ADV") && this.hasPartialTag(prevToken, "ADJ", "ADV", "PA2") || tokens[i].hasPosTagStartingWith("SUB:") && this.hasPartialTag(prevToken, "GEN") && !this.hasPartialTag(nextReadings, "PKT");
        }
        return false;
    }

    private boolean isNumber(String token) {
        if (StringUtils.isNumeric((CharSequence)token)) {
            return true;
        }
        AnalyzedTokenReadings lookup = this.lookup(StringTools.lowercaseFirstChar((String)token));
        return lookup != null && lookup.hasPosTag("ZAL");
    }

    private boolean isAdverbAndNominalization(int i, AnalyzedTokenReadings[] tokens) {
        String prevPrevToken = i > 1 ? tokens[i - 2].getToken() : "";
        AnalyzedTokenReadings prevToken = i > 0 ? tokens[i - 1] : null;
        String token = tokens[i].getToken();
        AnalyzedTokenReadings nextReadings = i < tokens.length - 1 ? tokens[i + 1] : null;
        return "das".equalsIgnoreCase(prevPrevToken) && this.hasPartialTag(prevToken, "ADV") && StringTools.startsWithUppercase((String)token) && !this.hasNounReading(nextReadings);
    }

    private boolean hasPartialTag(AnalyzedTokenReadings token, String ... posTags) {
        if (token != null) {
            for (String posTag : posTags) {
                if (!token.hasPartialPosTag(posTag)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSpecialCase(int i, AnalyzedTokenReadings[] tokens) {
        String prevToken = i > 1 ? tokens[i - 1].getToken() : "";
        String token = tokens[i].getToken();
        AnalyzedTokenReadings nextReadings = i < tokens.length - 1 ? tokens[i + 1] : null;
        return "im".equalsIgnoreCase(prevToken) && "Allgemeinen".equals(token) && !this.hasNounReading(nextReadings);
    }

    private boolean isAdjectiveAsNoun(int i, AnalyzedTokenReadings[] tokens, AnalyzedTokenReadings lowercaseReadings) {
        boolean isPrecededByVerb;
        AnalyzedTokenReadings prevToken = i > 0 ? tokens[i - 1] : null;
        AnalyzedTokenReadings nextReadings = i < tokens.length - 1 ? tokens[i + 1] : null;
        AnalyzedTokenReadings prevLowercaseReadings = null;
        if (i > 1 && StringUtils.equalsAny((CharSequence)tokens[i - 2].getToken(), (CharSequence[])SENTENCE_START_EXCEPTIONS)) {
            prevLowercaseReadings = this.lookup(prevToken.getToken().toLowerCase());
        }
        boolean isPossiblyFollowedByInfinitive = nextReadings != null && nextReadings.getToken().equals("zu");
        boolean isFollowedByInfinitive = nextReadings != null && !isPossiblyFollowedByInfinitive && nextReadings.hasPartialPosTag("EIZ");
        boolean isFollowedByPossessiveIndicator = nextReadings != null && StringUtils.equalsAny((CharSequence)nextReadings.getToken(), (CharSequence[])POSSESSIVE_INDICATORS);
        boolean isUndefQuantifier = prevToken != null && StringUtils.equalsAny((CharSequence)prevToken.getToken().toLowerCase(), (CharSequence[])UNDEFINED_QUANTIFIERS);
        boolean isPrevDeterminer = prevToken != null && (this.hasPartialTag(prevToken, "ART", "PRP", "ZAL") || this.hasPartialTag(prevLowercaseReadings, "ART", "PRP", "ZAL")) && !prevToken.hasPartialPosTag(":STD");
        boolean bl = isPrecededByVerb = prevToken != null && prevToken.matchesPosTagRegex("VER:(MOD:|AUX:)?[1-3]:.*") && !prevToken.hasLemma("sein");
        if (!(isPrevDeterminer || isUndefQuantifier || isPossiblyFollowedByInfinitive || isFollowedByInfinitive || isPrecededByVerb && lowercaseReadings != null && this.hasPartialTag(lowercaseReadings, "ADJ:", "PA") && nextReadings != null && !StringUtils.equalsAny((CharSequence)nextReadings.getToken(), (CharSequence[])new CharSequence[]{"und", "oder", ","}) || isFollowedByPossessiveIndicator && this.hasPartialTag(lowercaseReadings, "ADJ", "VER") || prevToken != null && prevToken.hasPosTag("KON:UNT") && !this.hasNounReading(nextReadings) && nextReadings != null && !nextReadings.hasPosTag("KON:NEB"))) {
            AnalyzedTokenReadings prevPrevToken;
            AnalyzedTokenReadings analyzedTokenReadings = prevPrevToken = i > 1 && prevToken != null && prevToken.hasPartialPosTag("ADJ") ? tokens[i - 2] : null;
            if (!isPrecededByVerb && lowercaseReadings != null && prevToken != null) {
                if (prevToken.hasPartialPosTag("SUB:") && lowercaseReadings.matchesPosTagRegex("(ADJ|PA2):GEN:PLU:MAS:GRU:SOL.*")) {
                    return nextReadings != null && !nextReadings.hasPartialPosTag("SUB:");
                }
                if (nextReadings != null && nextReadings.getReadingsLength() == 1 && prevToken.hasPosTagStartingWith("PRO:PER:NOM:") && nextReadings.hasPosTag("ADJ:PRD:GRU")) {
                    return true;
                }
            }
            if (!this.hasPartialTag(prevPrevToken, "ART", "PRP", "ZAL")) {
                return false;
            }
        }
        for (AnalyzedToken reading : tokens[i].getReadings()) {
            String posTag = reading.getPOSTag();
            if (posTag != null && !posTag.contains("ADJ") || this.hasNounReading(nextReadings) || StringUtils.isNumeric((CharSequence)(nextReadings != null ? nextReadings.getToken() : "")) || posTag == null && this.hasPartialTag(lowercaseReadings, "PRP:LOK", "PA2:PRD:GRU:VER", "PA1:PRD:GRU:VER", "ADJ:PRD:KOM", "ADV:TMP")) continue;
            return true;
        }
        return false;
    }

    private boolean isLanguage(int i, AnalyzedTokenReadings[] tokens, String token) {
        boolean maybeLanguage = token.endsWith("sch") && LanguageNames.get().contains(token) || LanguageNames.get().contains(StringUtils.removeEnd((String)StringUtils.removeEnd((String)token, (String)"n"), (String)"e"));
        AnalyzedTokenReadings prevToken = i > 0 ? tokens[i - 1] : null;
        AnalyzedTokenReadings nextReadings = i < tokens.length - 1 ? tokens[i + 1] : null;
        return maybeLanguage && (!this.hasNounReading(nextReadings) || prevToken != null && prevToken.getToken().equals("auf"));
    }

    private boolean isProbablyCity(int i, AnalyzedTokenReadings[] tokens, String token) {
        boolean hasCityPrefix = StringUtils.equalsAny((CharSequence)token, (CharSequence[])new CharSequence[]{"Klein", "Gro\u00df", "Neu"});
        if (hasCityPrefix) {
            AnalyzedTokenReadings nextReadings = i < tokens.length - 1 ? tokens[i + 1] : null;
            return nextReadings != null && (!nextReadings.isTagged() || nextReadings.hasPosTagStartingWith("EIG"));
        }
        return false;
    }

    private boolean isFollowedByRelativeOrSubordinateClause(int i, AnalyzedTokenReadings[] tokens) {
        if (i < tokens.length - 4) {
            return ",".equals(tokens[i + 1].getToken()) && (StringUtils.equalsAny((CharSequence)tokens[i + 2].getToken(), (CharSequence[])INTERROGATIVE_PARTICLES) || tokens[i + 2].hasPosTag("KON:UNT"));
        }
        return false;
    }

    private boolean isExceptionPhrase(int i, AnalyzedTokenReadings[] tokens) {
        for (StringMatcher[] patterns : exceptionPatterns) {
            for (int j = 0; j < patterns.length; ++j) {
                int startIndex;
                if (!patterns[j].matches(tokens[i].getToken()) || !CaseRule.compareLists(tokens, startIndex = i - j, startIndex + patterns.length - 1, patterns)) continue;
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    static boolean compareLists(AnalyzedTokenReadings[] tokens, int startIndex, int endIndex, StringMatcher ... patterns) {
        if (startIndex < 0) {
            return false;
        }
        int i = 0;
        for (int j = startIndex; j <= endIndex; ++j) {
            if (i >= patterns.length || j >= tokens.length || !patterns[i].matches(tokens[j].getToken())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private AnalyzedTokenReadings lookup(String word) {
        try {
            return this.tagger.lookup(word);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not lookup '" + word + "'.", e);
        }
    }

    static {
        nounIndicators.add("das");
        nounIndicators.add("sein");
        nounIndicators.add("mein");
        nounIndicators.add("dein");
        nounIndicators.add("euer");
        nounIndicators.add("unser");
        SENTENCE_START_EXCEPTIONS = new String[]{"(", "\"", "'", "\u2018", "\u201e", "\u00ab", "\u00bb", ".", "!", "?"};
        UNDEFINED_QUANTIFIERS = new String[]{"viel", "nichts", "nix", "wenig", "allerlei"};
        INTERROGATIVE_PARTICLES = new String[]{"was", "wodurch", "wof\u00fcr", "womit", "woran", "worauf", "woraus", "wovon", "wie"};
        POSSESSIVE_INDICATORS = new String[]{"einer", "eines", "der", "des", "dieser", "dieses"};
        DAS_VERB_EXCEPTIONS = new String[]{"nur", "sogar", "auch", "die", "alle", "viele", "zu"};
        exceptions = new String[]{"Vertrauter", "Out", "Packet", "Adult", "Responsive", "Mo", "Di", "Mi", "Do", "Fr", "Sa", "Gr", "Mag", "Nov", "Diss", "Invalide", "Invalider", "Invaliden", "Schutzheilige", "Schutzheiliger", "Schutzheiligen", "Lila", "Langzeitarbeitslose", "Langzeitarbeitslosen", "Langzeitarbeitsloser", "Linksintellektuelle", "Linksintellektueller", "Linksintellektuellen", "Drogenabh\u00e4ngige", "Drogenabh\u00e4ngiger", "Drogenabh\u00e4ngiger", "Drogenabh\u00e4ngigen", "Asylsuchender", "Asylsuchende", "Asylsuchenden", "Landtagsabgeordnete", "Landtagsabgeordneter", "Landtagsabgeordneten", "Stadtverordnete", "Stadtverordneter", "Stadtverordneten", "Ver\u00e4nderliche", "Ver\u00e4nderlicher", "Ver\u00e4nderlichen", "Werbetreibende", "Werbetreibender", "Werbetreibenden", "Werkt\u00e4tige", "Werkt\u00e4tiger", "Werkt\u00e4tigen", "Getestete", "Getesteten", "Genesene", "Genesenen", "Geimpfte", "Ungeimpfte", "Geimpften", "Ungeimpften", "Gefl\u00fcchtete", "Gefl\u00fcchteten", "Projektbeteiligte", "Projektbeteiligten", "Heranwachsende", "Heranwachsenden", "Interessierte", "Interessierten", "Infizierte", "Infizierten", "Geh\u00f6rlose", "Geh\u00f6rlosen", "Dr\u00fccke", "Klecks", "Quatsch", "Speis", "Flash", "Suhl", "M\u00fch", "Bims", "Wisch", "Au\u00dfenputz", "Rinderhack", "Hack", "Schlitz", "Frevler", "Zementputz", "Hurst", "Bombardier", "Kraus", "Strunz", "Bell", "Melk", "Klopp", "Walz", "Schiel", "Dusch", "Penn", "D\u00f6rr", "Kies", "Koks", "Dell", "Wall", "Beige", "Zoom", "Perl", "Parallele", "Parallelen", "Rutsch", "Spar", "Merz", "Minderj\u00e4hrige", "Minderj\u00e4hriger", "Minderj\u00e4hrigen", "Scheinselbstst\u00e4ndige", "Bundestagsabgeordneter", "Bundestagsabgeordneten", "Bundestagsabgeordnete", "Reichstagsabgeordneter", "Reichstagsabgeordneten", "Reichstagsabgeordnete", "Medienschaffende", "Medienschaffenden", "Medienschaffender", "Lehrende", "Lehrenden", "Vertretene", "Vertretenen", "Vorstandsvorsitzender", "Vorstandsvorsitzenden", "Vorstandsvorsitzende", "Marketingtreibende", "Marketingtreibender", "Marketingtreibenden", "Strafgefangenen", "Strafgefangener", "Strafgefangene", "P\u00e4dophile", "P\u00e4dophiler", "P\u00e4dophilen", "Lehrbeauftragte", "Lehrbeauftragter", "Lehrbeauftragten", "Erkrankte", "Erkrankter", "Erkrankten", "Eigner", "Polizeibeamten", "Polizeibeamter", "Polizeibeamte", "Kriegsversehrte", "Kriegsversehrter", "Kriegsversehrten", "Demenzkranke", "Demenzkranker", "Demenzkranken", "Parteivorsitzende", "Parteivorsitzender", "Parteivorsitzenden", "Kriegsgefangene", "Kriegsgefangener", "Kriegsgefangenen", "Ehrenvorsitzende", "Ehrenvorsitzender", "Ehrenvorsitzenden", "Oberkommandierende", "Oberkommandierender", "Oberkommandierenden", "Mitangeklagte", "Schuhfilz", "Mix", "Rahm", "Flansch", "WhatsApp", "Verschlei\u00df", "Wehrbeauftragter", "Wehrbeauftragte", "Wehrbeauftragten", "Wehrbeauftragtem", "Prozessbevollm\u00e4chtigter", "Prozessbevollm\u00e4chtigte", "Prozessbevollm\u00e4chtigten", "Prozessbevollm\u00e4chtigtem", "Bundesbeamte", "Bundesbeamter", "Bundesbeamten", "Bundesbeamtem", "Datenschutzbeauftragter", "Datenschutzbeauftragte", "Datenschutzbeauftragten", "Datenschutzbeauftragtem", "Steuerbevollm\u00e4chtigte", "Steuerbevollm\u00e4chtigter", "Steuerbevollm\u00e4chtigten", "Steuerbevollm\u00e4chtigtem", "Suchtkranken", "Suchtkranke", "Suchtkranker", "Filmschaffende", "Filmschaffender", "Filmschaffenden", "Filmschaffendem", "Arbeitssuchende", "Arbeitssuchender", "Arbeitssuchenden", "Arbeitssuchendem", "Bausachverst\u00e4ndige", "Bausachverst\u00e4ndiger", "Bausachverst\u00e4ndigen", "Bausachverst\u00e4ndigem", "Heurige", "Ratsuchende", "Ratsuchender", "Ratsuchenden", "Verwundete", "Verwundeter", "Verwundeten", "Vollzugsbeamte", "Vollzugsbeamter", "Vollzugsbeamten", "Schutzbefohlene", "Schutzbefohlener", "Schutzbefohlenen", "Verfahrensbeteiligte", "Verfahrensbeteiligter", "Verfahrensbeteiligten", "Kolonialbeamte", "Kolonialbeamter", "Kolonialbeamten", "Verwaltungsbeamte", "Verwaltungsbeamter", "Verwaltungsbeamten", "Verd\u00e4chtige", "Verd\u00e4chtiger", "Verd\u00e4chtigen", "Leichtverletzte", "Leichtverletzten", "Leichtverletzte", "Dozierende", "Dozierenden", "Studierende", "Studierender", "Studierenden", "Suchbegriffen", "Plattdeutsch", "Wallet", "Str", "Auszubildende", "Auszubildender", "Gelehrte", "Gelehrter", "Gelehrten", "Vorstehende", "Vorstehender", "Mitwirkende", "Mitwirkender", "Mitwirkenden", "Tabellenletzte", "Tabellenletzter", "Familienangeh\u00f6rige", "Familienangeh\u00f6riger", "Zeitreisende", "Zeitreisender", "Zeitreisenden", "Erwerbst\u00e4tige", "Erwerbst\u00e4tigen", "Erwerbst\u00e4tiger", "Selbstst\u00e4ndige", "Selbstst\u00e4ndigen", "Selbstst\u00e4ndiger", "Selbst\u00e4ndige", "Selbst\u00e4ndigen", "Selbst\u00e4ndiger", "Genaueres", "\u00c4u\u00dfersten", "Dienstreisender", "Verletzte", "Vermisste", "\u00c4u\u00dferes", "Abseits", "Unschuldige", "Unschuldiger", "Unschuldigen", "Mitarbeitende", "Mitarbeitender", "Mitarbeitenden", "Besch\u00e4ftigter", "Besch\u00e4ftigte", "Besch\u00e4ftigten", "Bekannter", "Bekannte", "Bevollm\u00e4chtigte", "Bevollm\u00e4chtigter", "Bevollm\u00e4chtigten", "Brecht", "Tel", "Unschuldiger", "Vorgesetzter", "Abs", "Klappe", "Vorfahre", "Mittler", "Hr", "Schwarz", "Genese", "Rosa", "Auftrieb", "Zuschnitt", "Geschossen", "Vortrieb", "Abtrieb", "Gesandter", "Durchfahrt", "Durchgriff", "\u00dcberfahrt", "Zeche", "Sparte", "Sparten", "Heiliger", "Reisender", "Pest", "Schwinge", "Verlies", "Nachfolge", "Stift", "Belange", "Geistlicher", "Google", "Hu", "Jenseits", "Abends", "Alleinerziehende", "Alleinerziehenden", "Alleinerziehender", "Abgeordneter", "Abgeordnete", "Abgeordneten", "Angestellter", "Angestellte", "Angestellten", "Armeeangeh\u00f6rige", "Armeeangeh\u00f6rigen", "Armeeangeh\u00f6riger", "Liberaler", "Abriss", "Ahne", "\u00c4hnlichem", "\u00c4hnliches", "Allerlei", "Anklang", "Verlobter", "Anstrich", "Armes", "Ausdr\u00fccke", "Ausw\u00fcchsen", "B\u00e4nde", "B\u00e4nden", "Beauftragter", "Belange", "Biss", "De", "Diesseits", "Dr", "Durcheinander", "Eindr\u00fccke", "Erwachsener", "Familienangeh\u00f6rige", "Fl\u00f6\u00dfe", "Folgendes", "Fort", "Fra\u00df", "Frevel", "Gen\u00fcge", "Gefallen", "Gl\u00e4ubige", "Gl\u00e4ubiger", "Gl\u00e4ubigen", "Hechte", "Herz\u00f6ge", "Herz\u00f6gen", "Hinfahrt", "Hilfsstoff", "Hilfsstoffe", "Hundert", "Zehntausend", "Hunderttausend", "Hyperwallet", "Ihnen", "Ihr", "Ihre", "Ihrem", "Ihren", "Ihrer", "Ihres", "Infrarot", "Jenseits", "Jugendlicher", "J\u00fcnger", "Kant", "Klaue", "Konditional", "Kr\u00e4he", "Kurzem", "Landwirtschaft", "Langem", "L\u00e4ngerem", "Lausitz", "Le", "Lehrlingsunterweisung", "Letzt", "Letzt", "Letztere", "Letzterer", "Letzteres", "Link", "Links", "L\u00f6hne", "Luden", "Milk", "Mitfahrt", "Mr", "Mrd", "Mrs", "Nachfrage", "Nachts", "Nachspann", "N\u00e4hte", "N\u00e4hten", "Narkoseverfahren", "Neuem", "Nr", "Nutze", "Obdachloser", "Oder", "Ohrfeige", "Patsche", "Pfiffe", "Pfiffen", "Press", "Prof", "Puste", "Sachverst\u00e4ndiger", "Sankt", "Schaulustige", "Scheine", "Schei\u00dfe", "Schuft", "Schufte", "Schuld", "Schwangere", "Schwangeren", "Schw\u00e4rme", "Schwarzes", "Sie", "Skype", "Spitz", "Spott", "St", "Stereotyp", "St\u00f6re", "Tausend", "Tischende", "Toter", "\u00dcbrigen", "Unentschieden", "Unvorhergesehenes", "Verantwortlicher", "Verlass", "Verwandter", "Vielfache", "Vielfaches", "Vorsitzender", "Fraktionsvorsitzender", "Verletzte", "Verletzten", "Walt", "Weitem", "Weiteres", "Wicht", "Wichtiges", "Wider", "Wild", "Zeche", "Zusage", "Zwinge", "Zirkusrund", "Terti\u00e4r", "Erster", "Zweiter", "Dritter", "Vierter", "F\u00fcnfter", "Sechster", "Siebter", "Achter", "Neunter", "Erste", "Zweite", "Dritte", "Vierte", "F\u00fcnfte", "Sechste", "Siebte", "Achte", "Neunte", "Dein", "Deine", "Deinem", "Deinen", "Deiner", "Deines", "Dich", "Dir", "Du", "Euch", "Euer", "Eure", "Eurem", "Euren", "Eures"};
        exceptionPatterns = CaseRuleExceptions.getExceptionPatterns();
        substVerbenExceptions = new HashSet<String>();
        substVerbenExceptions.add("hinziehen");
        substVerbenExceptions.add("helfen");
        substVerbenExceptions.add("lassen");
        substVerbenExceptions.add("passieren");
        substVerbenExceptions.add("haben");
        substVerbenExceptions.add("passiert");
        substVerbenExceptions.add("beschr\u00e4nkt");
        substVerbenExceptions.add("wiederholt");
        substVerbenExceptions.add("scheinen");
        substVerbenExceptions.add("klar");
        substVerbenExceptions.add("hei\u00dfen");
        substVerbenExceptions.add("einen");
        substVerbenExceptions.add("geh\u00f6ren");
        substVerbenExceptions.add("bedeutet");
        substVerbenExceptions.add("erm\u00f6glicht");
        substVerbenExceptions.add("funktioniert");
        substVerbenExceptions.add("sollen");
        substVerbenExceptions.add("werden");
        substVerbenExceptions.add("d\u00fcrfen");
        substVerbenExceptions.add("m\u00fcssen");
        substVerbenExceptions.add("so");
        substVerbenExceptions.add("ist");
        substVerbenExceptions.add("k\u00f6nnen");
        substVerbenExceptions.add("mein");
        substVerbenExceptions.add("sein");
        substVerbenExceptions.add("muss");
        substVerbenExceptions.add("mu\u00df");
        substVerbenExceptions.add("wollen");
        substVerbenExceptions.add("habe");
        substVerbenExceptions.add("ein");
        substVerbenExceptions.add("tun");
        substVerbenExceptions.add("best\u00e4tigt");
        substVerbenExceptions.add("best\u00e4tigte");
        substVerbenExceptions.add("best\u00e4tigten");
        substVerbenExceptions.add("bekommen");
        substVerbenExceptions.add("sauer");
        substVerbenExceptions.add("bedeuten");
    }
}

