/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.GlobalConfig;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.language.German;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.de.SwissCompoundRule;
import org.languagetool.rules.de.SwissGermanSpellerRule;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.de.SwissGermanTagger;

public class SwissGerman
extends German {
    @Override
    @NotNull
    public Tagger createDefaultTagger() {
        return new SwissGermanTagger();
    }

    @Override
    public String[] getCountries() {
        return new String[]{"CH"};
    }

    @Override
    public String getName() {
        return "German (Swiss)";
    }

    @Override
    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        ArrayList<Rule> rules = new ArrayList<Rule>(super.getRelevantRules(messages, userConfig, motherTongue, altLanguages));
        rules.add((Rule)new SwissCompoundRule(messages, this, userConfig));
        return rules;
    }

    public SpellingCheckRule createDefaultSpellingRule(ResourceBundle messages) throws IOException {
        return new SwissGermanSpellerRule(messages, this);
    }

    public List<Rule> getRelevantLanguageModelCapableRules(ResourceBundle messages, @Nullable LanguageModel languageModel, GlobalConfig globalConfig, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        ArrayList<Rule> rules = new ArrayList<Rule>(super.getRelevantLanguageModelCapableRules(messages, languageModel, globalConfig, userConfig, motherTongue, altLanguages));
        rules.add((Rule)new SwissGermanSpellerRule(messages, (German)this, userConfig, languageModel));
        return rules;
    }

    public boolean isVariant() {
        return true;
    }

    public List<RuleMatch> adaptSuggestions(List<RuleMatch> ruleMatches, Set<String> enabledRules) {
        ArrayList<RuleMatch> newRuleMatches = new ArrayList<RuleMatch>();
        for (RuleMatch rm : ruleMatches) {
            List replacements = rm.getSuggestedReplacements();
            ArrayList<String> newReplacements = new ArrayList<String>();
            for (String s : replacements) {
                s = s.replaceAll("\u00df", "ss");
                newReplacements.add(s);
            }
            RuleMatch newMatch = new RuleMatch(rm, newReplacements);
            newRuleMatches.add(newMatch);
        }
        return newRuleMatches;
    }
}

