/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.ResourceBundle;
import org.languagetool.language.GermanyGerman;
import org.languagetool.rules.AbstractCompoundRule;
import org.languagetool.rules.Categories;
import org.languagetool.rules.CompoundRuleData;
import org.languagetool.rules.Example;
import org.languagetool.rules.de.GermanSpellerRule;

public class GermanCompoundRule
extends AbstractCompoundRule {
    private static volatile CompoundRuleData compoundData;
    private static GermanSpellerRule germanSpellerRule;

    public GermanCompoundRule(ResourceBundle messages) throws IOException {
        super(messages, "Dieses Wort wird mit Bindestrich geschrieben.", "Dieses Wort wird zusammengeschrieben.", "Diese W\u00f6rter werden zusammengeschrieben oder mit Bindestrich getrennt.", "Zusammenschreibung von W\u00f6rtern");
        super.setCategory(Categories.COMPOUNDING.getCategory(messages));
        this.addExamplePair(Example.wrong((String)"Wenn es schlimmer wird, solltest Du zum <marker>HNO Arzt</marker> gehen."), Example.fixed((String)"Wenn es schlimmer wird, solltest Du zum <marker>HNO-Arzt</marker> gehen."));
        if (germanSpellerRule == null) {
            germanSpellerRule = new GermanSpellerRule(messages, new GermanyGerman());
        }
    }

    public String getId() {
        return "DE_COMPOUNDS";
    }

    public String getDescription() {
        return "Zusammenschreibung von W\u00f6rtern, z. B. 'CD-ROM' statt 'CD ROM'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CompoundRuleData getCompoundRuleData() {
        CompoundRuleData data = compoundData;
        if (data != null) return data;
        Class<GermanCompoundRule> clazz = GermanCompoundRule.class;
        synchronized (GermanCompoundRule.class) {
            data = compoundData;
            if (data != null) return data;
            compoundData = data = new CompoundRuleData(new String[]{"/de/compounds.txt", "/de/compound-cities.txt"});
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return data;
        }
    }

    public boolean isMisspelled(String word) throws IOException {
        return germanSpellerRule.isMisspelled(word);
    }
}

