/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.language.German;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.de.AgreementRule;
import org.languagetool.rules.de.GermanHelper;
import org.languagetool.rules.de.PrepositionToCases;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tools.StringTools;

class AgreementSuggestor {
    private final Synthesizer synthesizer;
    private final AnalyzedTokenReadings determinerToken;
    private final AnalyzedTokenReadings adjToken;
    private final AnalyzedTokenReadings nounToken;
    private final AgreementRule.ReplacementType replacementType;
    private final AgreementRule agreementRule;
    private final JLanguageTool lt;
    private AnalyzedTokenReadings prepositionToken;

    AgreementSuggestor(Synthesizer synthesizer, AnalyzedTokenReadings determinerToken, AnalyzedTokenReadings nounToken, AgreementRule.ReplacementType replacementType) {
        this(synthesizer, determinerToken, null, nounToken, replacementType);
    }

    AgreementSuggestor(Synthesizer synthesizer, AnalyzedTokenReadings determinerToken, AnalyzedTokenReadings adjToken, AnalyzedTokenReadings nounToken, AgreementRule.ReplacementType replacementType) {
        this.synthesizer = synthesizer;
        this.determinerToken = determinerToken;
        this.adjToken = adjToken;
        this.nounToken = nounToken;
        this.replacementType = replacementType;
        German german = (German)Languages.getLanguageForShortCode((String)"de");
        this.agreementRule = new AgreementRule(JLanguageTool.getMessageBundle(), german);
        this.agreementRule.disableSuggestions();
        this.lt = new JLanguageTool((Language)german);
    }

    void setPreposition(AnalyzedTokenReadings prep) {
        this.prepositionToken = prep;
    }

    List<String> getSuggestions() {
        HashSet<String> suggestionSet = new HashSet<String>();
        try {
            ArrayList<String> adjResult = new ArrayList<String>();
            for (AnalyzedToken token2Reading : this.nounToken.getReadings()) {
                List<PrepositionToCases.Case> cases;
                ArrayList<String> nounCases = new ArrayList<String>();
                nounCases.add(GermanHelper.getNounCase(token2Reading.getPOSTag()));
                String nounNumber = GermanHelper.getNounNumber(token2Reading.getPOSTag());
                String nounGender = GermanHelper.getNounGender(token2Reading.getPOSTag());
                if (this.prepositionToken != null && (cases = PrepositionToCases.getCasesFor(this.prepositionToken.getToken())).size() > 0) {
                    nounCases = new ArrayList();
                    for (PrepositionToCases.Case aCase : cases) {
                        String val = aCase.name().toLowerCase();
                        if (nounCases.contains(val)) continue;
                        nounCases.add(val.toUpperCase());
                    }
                }
                for (String nounCase : nounCases) {
                    for (AnalyzedToken token1Reading : this.determinerToken.getReadings()) {
                        List<String> articleSuggestions = this.getArticleSuggestions(nounCase, nounNumber, nounGender, token1Reading);
                        suggestionSet.addAll(articleSuggestions);
                        List<String> pronounSuggestions = this.getPronounSuggestions(nounCase, nounNumber, nounGender, token1Reading);
                        suggestionSet.addAll(pronounSuggestions);
                        List<String> nounSuggestions = this.getNounSuggestions(token2Reading, token1Reading);
                        suggestionSet.addAll(nounSuggestions);
                        if (this.adjToken == null) continue;
                        this.fillAdjResult(suggestionSet, nounCase, nounNumber, nounGender, token1Reading, adjResult);
                    }
                }
            }
            if (this.adjToken != null) {
                return this.filterResult(adjResult);
            }
            ArrayList<String> suggestions = new ArrayList<String>(this.filterResult(suggestionSet));
            Collections.sort(suggestions);
            return suggestions;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void fillAdjResult(Set<String> suggestionSet, String nounCase, String nounNumber, String nounGender, AnalyzedToken detReading, List<String> adjResult) throws IOException {
        for (AnalyzedToken token : this.adjToken.getReadings()) {
            String correctPosTag1 = "ADJ:" + nounCase + ":" + nounNumber + ":" + nounGender + ":" + GermanHelper.getComparison(token.getPOSTag()) + ":" + GermanHelper.getDeterminerDefiniteness(detReading.getPOSTag());
            this.inflect(suggestionSet, adjResult, token, correctPosTag1);
            String correctPosTag2 = "PA2:" + nounCase + ":" + nounNumber + ":" + nounGender + ":" + GermanHelper.getComparison(token.getPOSTag()) + ":" + GermanHelper.getDeterminerDefiniteness(detReading.getPOSTag()) + ":VER";
            this.inflect(suggestionSet, adjResult, token, correctPosTag2);
        }
    }

    private void inflect(Set<String> suggestionSet, List<String> adjResult, AnalyzedToken token, String correctPosTag) throws IOException {
        String[] synthesized;
        for (String s : synthesized = this.synthesizer.synthesize(token, correctPosTag)) {
            for (String res : suggestionSet) {
                String det = res.split(" ")[0];
                String adjRes = det + " " + s + " " + this.nounToken.getToken();
                if (adjResult.contains(adjRes)) continue;
                adjResult.add(adjRes);
            }
        }
    }

    @NotNull
    private List<String> filterResult(Collection<String> result) throws IOException {
        ArrayList<String> cleanResult = new ArrayList<String>();
        for (String s : result) {
            RuleMatch[] matches = this.agreementRule.match(this.lt.getAnalyzedSentence(s));
            if (matches.length != 0) continue;
            cleanResult.add(s);
        }
        return cleanResult;
    }

    private List<String> getArticleSuggestions(String nounCase, String nounNumber, String nounGender, AnalyzedToken article) throws IOException {
        String determinerDefiniteness = GermanHelper.getDeterminerDefiniteness(article.getPOSTag());
        if (StringTools.isEmpty((String)determinerDefiniteness)) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        String correctPosTag1 = "ART:" + determinerDefiniteness + ":" + nounCase + ":" + nounNumber + ":" + nounGender;
        result.addAll(this.getDeterminerSuggestionsForPosTag(article, correctPosTag1, null));
        String correctPosTag2 = "PRO:DEM:" + nounCase + ":" + nounNumber + ":" + nounGender + ":B/S";
        result.addAll(this.getDeterminerSuggestionsForPosTag(article, correctPosTag2, null));
        return result;
    }

    private List<String> getPronounSuggestions(String nounCase, String nounNumber, String nounGender, AnalyzedToken pronoun) throws IOException {
        String correctPosTag = "PRO:POS:" + nounCase + ":" + nounNumber + ":" + nounGender + ":BEG";
        return this.getDeterminerSuggestionsForPosTag(pronoun, correctPosTag, this.determinerToken.getToken().substring(0, 1));
    }

    private List<String> getNounSuggestions(AnalyzedToken token2Reading, AnalyzedToken determiner) throws IOException {
        if (determiner.getPOSTag() != null && determiner.getPOSTag().endsWith(":STV")) {
            return Collections.emptyList();
        }
        String determinerCase = GermanHelper.getDeterminerCase(determiner.getPOSTag());
        String determinerNumber = GermanHelper.getDeterminerNumber(determiner.getPOSTag());
        String determinerGender = GermanHelper.getDeterminerGender(determiner.getPOSTag());
        String correctPosTag = "SUB:" + determinerCase + ":" + determinerNumber + ":" + determinerGender;
        return this.getNounSuggestionsForPosTag(this.determinerToken, token2Reading, correctPosTag);
    }

    private List<String> getDeterminerSuggestionsForPosTag(AnalyzedToken token1Reading, String correctPosTag, String startsWith) throws IOException {
        String[] correctedDeterminer;
        ArrayList<String> suggestions = new ArrayList<String>();
        for (String determiner : correctedDeterminer = this.synthesizer.synthesize(token1Reading, correctPosTag)) {
            String correctDeterminer;
            if (startsWith != null && !determiner.startsWith(startsWith)) continue;
            String string = correctDeterminer = StringTools.isCapitalizedWord((String)this.determinerToken.getToken()) ? StringTools.uppercaseFirstChar((String)determiner) : determiner;
            if (this.replacementType == AgreementRule.ReplacementType.Zur) {
                if (correctDeterminer.equals("der") && correctPosTag.contains(":SIN:")) {
                    suggestions.add("zur " + this.nounToken.getToken());
                    continue;
                }
                if (correctDeterminer.equals("dem")) {
                    suggestions.add("zum " + this.nounToken.getToken());
                    continue;
                }
                if (correctDeterminer.equals("den") || correctPosTag.contains(":SIN:")) {
                    suggestions.add("zu " + correctDeterminer + " " + this.nounToken.getToken());
                    continue;
                }
                if (!correctPosTag.contains(":PLU:")) continue;
                suggestions.add("zu " + this.nounToken.getToken());
                continue;
            }
            suggestions.add(correctDeterminer + " " + this.nounToken.getToken());
        }
        return suggestions;
    }

    private List<String> getNounSuggestionsForPosTag(AnalyzedTokenReadings token1, AnalyzedToken token2Reading, String correctPosTag) throws IOException {
        ArrayList<String> suggestions = new ArrayList<String>();
        String[] correctedNouns = this.synthesizer.synthesize(token2Reading, correctPosTag);
        String firstPart = null;
        if (correctedNouns.length == 0 && token2Reading.getToken().contains("-")) {
            firstPart = token2Reading.getToken().substring(0, token2Reading.getToken().lastIndexOf(45) + 1);
            String lastTokenPart = token2Reading.getToken().replaceFirst(".*-", "");
            String lastLemmaPart = token2Reading.getLemma() != null ? token2Reading.getLemma().replaceFirst(".*-", "") : null;
            correctedNouns = this.synthesizer.synthesize(new AnalyzedToken(lastTokenPart, token2Reading.getPOSTag(), lastLemmaPart), correctPosTag);
        }
        for (String correctedNoun : correctedNouns) {
            String sugg;
            String string = sugg = firstPart != null ? token1.getToken() + " " + firstPart + correctedNoun : token1.getToken() + " " + correctedNoun;
            if (this.replacementType == AgreementRule.ReplacementType.Zur) {
                suggestions.add("zur " + sugg.replaceFirst("der ", ""));
                continue;
            }
            suggestions.add(sugg);
        }
        return suggestions;
    }
}

