/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import de.danielnaber.jwordsplitter.GermanWordSplitter;
import de.danielnaber.jwordsplitter.InputTooLongException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.language.German;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Example;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.de.LineExpander;
import org.languagetool.rules.ngrams.Probability;
import org.languagetool.rules.spelling.hunspell.CompoundAwareHunspellRule;
import org.languagetool.rules.spelling.morfologik.MorfologikMultiSpeller;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tokenizers.de.GermanCompoundTokenizer;
import org.languagetool.tools.StringTools;

public class GermanSpellerRule
extends CompoundAwareHunspellRule {
    public static final String RULE_ID = "GERMAN_SPELLER_RULE";
    private static final int MAX_EDIT_DISTANCE = 2;
    private static final Pattern PREVENT_SUGGESTION = Pattern.compile(".*(Majon\u00e4se|Bravur|Anschovis|Belkanto|Campagne|Frott\u00e9|Grisli|Jockei|Joga|Kalvinismus|Kanossa|Kargo|Ketschup|Kollier|Kommunikee|Masurka|Negligee|Nessess\u00e4r|Poulard|Varietee|Wandalismus|kalvinist).*");
    private final Set<String> wordsToBeIgnoredInCompounds = new HashSet<String>();
    private final Set<String> wordStartsToBeProhibited = new HashSet<String>();
    private final Set<String> wordEndingsToBeProhibited = new HashSet<String>();
    private static final Map<Pattern, Function<String, List<String>>> ADDITIONAL_SUGGESTIONS = new HashMap<Pattern, Function<String, List<String>>>();
    private static final GermanWordSplitter splitter;
    private final LineExpander lineExpander = new LineExpander();
    private final GermanCompoundTokenizer compoundTokenizer;
    private final Synthesizer synthesizer;
    private final Tagger tagger;

    private static void putRepl(String wordPattern, String pattern, String replacement) {
        ADDITIONAL_SUGGESTIONS.put(Pattern.compile(wordPattern), w -> Collections.singletonList(w.replaceFirst(pattern, replacement)));
    }

    private static void put(String pattern, String replacement) {
        ADDITIONAL_SUGGESTIONS.put(Pattern.compile(pattern), w -> Collections.singletonList(replacement));
    }

    private static void put(String pattern, Function<String, List<String>> f) {
        ADDITIONAL_SUGGESTIONS.put(Pattern.compile(pattern), f);
    }

    private static GermanWordSplitter getSplitter() {
        try {
            return new GermanWordSplitter(false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public GermanSpellerRule(ResourceBundle messages, German language) {
        this(messages, language, null, null);
    }

    public GermanSpellerRule(ResourceBundle messages, German language, UserConfig userConfig, String languageVariantPlainTextDict) {
        this(messages, language, userConfig, languageVariantPlainTextDict, Collections.emptyList(), null);
    }

    public GermanSpellerRule(ResourceBundle messages, German language, UserConfig userConfig, String languageVariantPlainTextDict, List<Language> altLanguages, LanguageModel languageModel) {
        super(messages, (Language)language, language.getNonStrictCompoundSplitter(), GermanSpellerRule.getSpeller(language, userConfig, languageVariantPlainTextDict), userConfig, altLanguages, languageModel);
        this.addExamplePair(Example.wrong((String)"LanguageTool kann mehr als eine <marker>nromale</marker> Rechtschreibpr\u00fcfung."), Example.fixed((String)"LanguageTool kann mehr als eine <marker>normale</marker> Rechtschreibpr\u00fcfung."));
        this.compoundTokenizer = language.getStrictCompoundTokenizer();
        this.tagger = language.getTagger();
        this.synthesizer = language.getSynthesizer();
    }

    protected synchronized void init() throws IOException {
        super.init();
        this.ignoreWordsWithLength = 1;
        String pattern = "(" + this.nonWordPattern.pattern() + "|(?<=[\\d\u00b0])-|-(?=\\d+))";
        this.nonWordPattern = Pattern.compile(pattern);
    }

    public String getId() {
        return RULE_ID;
    }

    public List<String> getCandidates(String word) {
        ArrayList partList;
        try {
            partList = splitter.getAllSplits(word);
        }
        catch (InputTooLongException e) {
            partList = new ArrayList();
        }
        ArrayList<String> candidates = new ArrayList<String>();
        for (List parts : partList) {
            candidates.addAll(super.getCandidates(parts));
            if (parts.size() == 2) {
                candidates.add((String)parts.get(0) + " " + (String)parts.get(1));
                if (this.isNounOrProperNoun(StringTools.uppercaseFirstChar((String)((String)parts.get(1))))) {
                    candidates.add((String)parts.get(0) + " " + StringTools.uppercaseFirstChar((String)((String)parts.get(1))));
                }
            }
            if (parts.size() == 2 && !((String)parts.get(0)).endsWith("s")) {
                candidates.add((String)parts.get(0) + "s" + (String)parts.get(1));
            }
            if (parts.size() != 2 || !((String)parts.get(1)).startsWith("s")) continue;
            String firstPart = (String)parts.get(0);
            String secondPart = (String)parts.get(1);
            candidates.addAll(super.getCandidates(Arrays.asList(firstPart + "s", secondPart.substring(1))));
        }
        return candidates;
    }

    protected boolean isProhibited(String word) {
        return super.isProhibited(word) || this.wordStartsToBeProhibited.stream().anyMatch(w -> word.startsWith((String)w)) || this.wordEndingsToBeProhibited.stream().anyMatch(w -> word.endsWith((String)w));
    }

    protected void addIgnoreWords(String origLine) {
        String line;
        String string = line = this.language.getShortCodeWithCountryAndVariant().equals("de-CH") ? origLine.replace("\u00df", "ss") : origLine;
        if (origLine.endsWith("-*")) {
            this.wordsToBeIgnoredInCompounds.add(line.substring(0, line.length() - 2));
            return;
        }
        List<String> words = this.expandLine(line);
        for (String word : words) {
            super.addIgnoreWords(word);
        }
    }

    protected List<String> expandLine(String line) {
        return this.lineExpander.expandLine(line);
    }

    protected RuleMatch createWrongSplitMatch(AnalyzedSentence sentence, List<RuleMatch> ruleMatchesSoFar, int pos, String coveredWord, String suggestion1, String suggestion2, int prevPos) {
        if (suggestion2.matches("[a-z\u00f6\u00e4\u00fc]-.+")) {
            return null;
        }
        return super.createWrongSplitMatch(sentence, ruleMatchesSoFar, pos, coveredWord, suggestion1, suggestion2, prevPos);
    }

    public List<String> getSuggestions(String word) throws IOException {
        List<String> suggestions = super.getSuggestions(word);
        suggestions = suggestions.stream().filter(k -> !PREVENT_SUGGESTION.matcher((CharSequence)k).matches() && !k.endsWith("roulett") && !k.matches("[\\w\u00f6\u00e4\u00fc\u00d6\u00c4\u00dc\u00df]+ -[\\w\u00f6\u00e4\u00fc\u00d6\u00c4\u00dc\u00df]+") && !k.endsWith("-s")).collect(Collectors.toList());
        if (word.endsWith(".")) {
            suggestions.replaceAll(s -> s.endsWith(".") ? s : s + ".");
        }
        suggestions = suggestions.stream().filter(k -> !k.equals(word) && (!k.endsWith("-") || word.endsWith("-")) && !k.matches("\\p{L} \\p{L}+")).collect(Collectors.toList());
        return suggestions;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    protected static MorfologikMultiSpeller getSpeller(Language language, UserConfig userConfig, String languageVariantPlainTextDict) {
        try {
            String langCode = language.getShortCode();
            String morfoFile = "/" + langCode + "/hunspell/" + langCode + "_" + language.getCountries()[0] + ".dict";
            if (!JLanguageTool.getDataBroker().resourceExists(morfoFile)) return null;
            ArrayList<String> paths = new ArrayList<String>(GermanSpellerRule.getSpellingFilePaths((String)langCode));
            if (languageVariantPlainTextDict != null) {
                paths.add(languageVariantPlainTextDict);
            }
            List streams = GermanSpellerRule.getStreams(paths);
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new SequenceInputStream(Collections.enumeration(streams)), StandardCharsets.UTF_8));){
                BufferedReader variantReader = GermanSpellerRule.getVariantReader(languageVariantPlainTextDict);
                MorfologikMultiSpeller morfologikMultiSpeller = new MorfologikMultiSpeller(morfoFile, (BufferedReader)new ExpandingReader(br), paths, variantReader, languageVariantPlainTextDict, userConfig != null ? userConfig.getAcceptedWords() : Collections.emptyList(), 2);
                return morfologikMultiSpeller;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not set up morfologik spell checker", e);
        }
    }

    @Nullable
    private static BufferedReader getVariantReader(String languageVariantPlainTextDict) {
        ExpandingReader variantReader = null;
        if (languageVariantPlainTextDict != null && !languageVariantPlainTextDict.isEmpty()) {
            InputStream variantStream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(languageVariantPlainTextDict);
            variantReader = new ExpandingReader(new BufferedReader(new InputStreamReader(variantStream, StandardCharsets.UTF_8)));
        }
        return variantReader;
    }

    protected void filterForLanguage(List<String> suggestions) {
        if (this.language.getShortCodeWithCountryAndVariant().equals("de-CH")) {
            for (int i = 0; i < suggestions.size(); ++i) {
                String s2 = suggestions.get(i);
                suggestions.set(i, s2.replace("\u00df", "ss"));
            }
        }
        suggestions.removeIf(s -> Arrays.stream(s.split(" ")).anyMatch(k -> k.matches("\\w\\p{Punct}?")));
        suggestions.removeIf(s -> s.length() > 1 && s.startsWith("-"));
    }

    protected List<String> sortSuggestionByQuality(String misspelling, List<String> suggestions) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> topSuggestions = new ArrayList<String>();
        for (String suggestion : suggestions) {
            if (misspelling.equalsIgnoreCase(suggestion)) {
                topSuggestions.add(suggestion);
                continue;
            }
            if (suggestion.contains(" ")) {
                String[] words = suggestion.replaceFirst("\\.$", "").split(" ", 2);
                if (this.languageModel != null && words.length == 2) {
                    Probability nonSplit = this.languageModel.getPseudoProbability(Collections.singletonList(words[0] + words[1]));
                    Probability split = this.languageModel.getPseudoProbability(Arrays.asList(words));
                    if (nonSplit.getProb() > split.getProb() || split.getProb() == 0.0) {
                        result.add(suggestion);
                        continue;
                    }
                    topSuggestions.add(suggestion);
                    continue;
                }
                topSuggestions.add(suggestion);
                continue;
            }
            result.add(suggestion);
        }
        result.addAll(0, topSuggestions);
        return result;
    }

    protected List<String> getFilteredSuggestions(List<String> wordsOrPhrases) {
        ArrayList<String> result = new ArrayList<String>();
        for (String wordOrPhrase : wordsOrPhrases) {
            String[] words = this.tokenizeText(wordOrPhrase);
            if (words.length >= 2 && this.isAdjOrNounOrUnknown(words[0]) && this.isNounOrUnknown(words[1]) && StringTools.startsWithUppercase((String)words[0]) && StringTools.startsWithUppercase((String)words[1])) continue;
            result.add(wordOrPhrase);
        }
        return result;
    }

    private boolean isNounOrUnknown(String word) {
        try {
            List readings = this.tagger.tag(Collections.singletonList(word));
            return readings.stream().anyMatch(reading -> reading.hasPosTagStartingWith("SUB") || reading.isPosTagUnknown());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isAdjOrNounOrUnknown(String word) {
        try {
            List readings = this.tagger.tag(Collections.singletonList(word));
            return readings.stream().anyMatch(reading -> reading.hasPosTagStartingWith("SUB") || reading.hasPosTagStartingWith("ADJ") || reading.isPosTagUnknown());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isNounOrProperNoun(String word) {
        try {
            List readings = this.tagger.tag(Collections.singletonList(word));
            return readings.stream().anyMatch(reading -> reading.hasPosTagStartingWith("SUB") || reading.hasPosTagStartingWith("EIG"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean ignoreElative(String word) {
        if (StringUtils.startsWithAny((CharSequence)word, (CharSequence[])new CharSequence[]{"bitter", "dunkel", "erz", "extra", "fr\u00fch", "gemein", "hyper", "lau", "mega", "minder", "stock", "super", "tod", "ultra", "ur"})) {
            String lastPart = RegExUtils.removePattern((String)word, (String)"^(bitter|dunkel|erz|extra|fr\u00fch|gemein|grund|hyper|lau|mega|minder|stock|super|tod|ultra|ur|voll)");
            return lastPart.length() >= 3 && !this.isMisspelled(lastPart);
        }
        return false;
    }

    public boolean isMisspelled(String word) {
        if (word.startsWith("Spielzug") && !word.matches("Spielzugs?|Spielzugangs?|Spielzuganges|Spielzugbuchs?|Spielzugb\u00fcchern?|Spielzuges|Spielzugverluste?|Spielzugverluste[ns]")) {
            return true;
        }
        if (!(!word.startsWith("Standart") || word.equals("Standarte") || word.equals("Standarten") || word.startsWith("Standartentr\u00e4ger") || word.startsWith("Standartenf\u00fchrer"))) {
            return true;
        }
        if (word.endsWith("schafte") && word.matches("[A-Z\u00d6\u00c4\u00dc][a-z\u00f6\u00e4\u00df-]+schafte")) {
            return true;
        }
        return super.isMisspelled(word);
    }

    protected boolean ignoreWord(List<String> words, int idx) throws IOException {
        boolean ignore = super.ignoreWord(words, idx);
        boolean ignoreUncapitalizedWord = !ignore && idx == 0 && super.ignoreWord(StringUtils.uncapitalize((String)words.get(0)));
        boolean ignoreByHyphen = false;
        boolean ignoreHyphenatedCompound = false;
        if (!ignore && !ignoreUncapitalizedWord) {
            if (words.get(idx).contains("-")) {
                ignoreByHyphen = words.get(idx).endsWith("-") && this.ignoreByHangingHyphen(words, idx);
            }
            ignoreHyphenatedCompound = !ignoreByHyphen && this.ignoreCompoundWithIgnoredWord(words.get(idx));
        }
        return ignore || ignoreUncapitalizedWord || ignoreByHyphen || ignoreHyphenatedCompound || this.ignoreElative(words.get(idx));
    }

    protected List<SuggestedReplacement> getAdditionalTopSuggestions(List<SuggestedReplacement> suggestions, String word) throws IOException {
        List<String> suggestionsList = suggestions.stream().map(SuggestedReplacement::getReplacement).collect(Collectors.toList());
        return SuggestedReplacement.convert(this.getAdditionalTopSuggestionsString(suggestionsList, word));
    }

    private List<String> getAdditionalTopSuggestionsString(List<String> suggestions, String word) throws IOException {
        String[] words;
        String ucWord;
        String suggestion;
        if ("WIFI".equalsIgnoreCase(word)) {
            return Collections.singletonList("Wi-Fi");
        }
        if ("W-Lan".equalsIgnoreCase(word)) {
            return Collections.singletonList("WLAN");
        }
        if ("genomen".equals(word)) {
            return Collections.singletonList("genommen");
        }
        if ("Preis-Leistungsverh\u00e4ltnis".equals(word)) {
            return Collections.singletonList("Preis-Leistungs-Verh\u00e4ltnis");
        }
        if ("ausversehen".equals(word)) {
            return Collections.singletonList("aus Versehen");
        }
        if ("getz".equals(word)) {
            return Arrays.asList("jetzt", "geht's");
        }
        if ("Trons".equals(word)) {
            return Collections.singletonList("Trance");
        }
        if ("ei".equals(word)) {
            return Collections.singletonList("ein");
        }
        if ("jo".equals(word) || "jepp".equals(word) || "jopp".equals(word)) {
            return Collections.singletonList("ja");
        }
        if ("Jo".equals(word) || "Jepp".equals(word) || "Jopp".equals(word)) {
            return Collections.singletonList("Ja");
        }
        if ("Ne".equals(word)) {
            return Arrays.asList("Nein", "Eine");
        }
        if ("ne".equals(word)) {
            return Arrays.asList("nein", "eine", "oder");
        }
        if ("is".equals(word)) {
            return Collections.singletonList("ist");
        }
        if ("Is".equals(word)) {
            return Collections.singletonList("Ist");
        }
        if ("un".equals(word)) {
            return Collections.singletonList("und");
        }
        if ("Un".equals(word)) {
            return Collections.singletonList("Und");
        }
        if ("Std".equals(word)) {
            return Collections.singletonList("Std.");
        }
        if (word.matches(".*ibel[hk]eit$")) {
            suggestion = word.replaceFirst("el[hk]eit$", "ilit\u00e4t");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.endsWith("aquise")) {
            suggestion = word.replaceFirst("aquise$", "akquise");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.endsWith("standart")) {
            suggestion = word.replaceFirst("standart$", "standard");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.endsWith("standarts")) {
            suggestion = word.replaceFirst("standarts$", "standards");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.endsWith("tips")) {
            suggestion = word.replaceFirst("tips$", "tipps");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.endsWith("tip")) {
            suggestion = word + "p";
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.endsWith("entfehlung")) {
            suggestion = word.replaceFirst("ent", "emp");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.endsWith("oullie")) {
            suggestion = word.replaceFirst("oullie$", "ouille");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.startsWith("[dD]urschnitt")) {
            suggestion = word.replaceFirst("^urschnitt", "urchschnitt");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.startsWith("Bundstift")) {
            suggestion = word.replaceFirst("^Bundstift", "Buntstift");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.matches("[aA]llm\u00e4hll?i(g|ch)(e[mnrs]?)?")) {
            suggestion = word.replaceFirst("llm\u00e4hll?i(g|ch)", "llm\u00e4hlich");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.matches(".*[mM]a[jy]onn?[\u00e4e]se.*")) {
            suggestion = word.replaceFirst("a[jy]onn?[\u00e4e]se", "ayonnaise");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.matches(".*[rR]es(a|er)[vw]i[he]?rung(en)?")) {
            suggestion = word.replaceFirst("es(a|er)[vw]i[he]?rung", "eservierung");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.matches("[rR]eschaschier.+")) {
            suggestion = word.replaceFirst("schaschier", "cherchier");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.matches(".*[lL]aborants$")) {
            suggestion = word.replaceFirst("ts$", "ten");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.matches("[pP]roff?ess?ion([\u00e4e])h?ll?(e[mnrs]?)?")) {
            suggestion = word.replaceFirst("roff?ess?ion([\u00e4e])h?l{1,2}", "rofessionell");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.matches("[vV]erstehendniss?(es?)?")) {
            suggestion = word.replaceFirst("[vV]erstehendnis", "Verst\u00e4ndnis");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.startsWith("koregier")) {
            suggestion = word.replace("reg", "rrig");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.matches("diagno[sz]ier.*")) {
            suggestion = word.replaceAll("gno[sz]ier", "gnostizier");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.contains("eiss")) {
            suggestion = word.replace("eiss", "ei\u00df");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.contains("uess")) {
            suggestion = word.replace("uess", "\u00fc\u00df");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else {
            if (word.equals("gin")) {
                return Collections.singletonList("ging");
            }
            if (word.equals("dh") || word.equals("dh.")) {
                return Collections.singletonList("d.\u202fh.");
            }
            if (word.equals("ua") || word.equals("ua.")) {
                return Collections.singletonList("u.\u202fa.");
            }
            if (word.matches("z[bB]") || word.matches("z[bB].")) {
                return Collections.singletonList("z.\u202fB.");
            }
            if (word.equals("uvm") || word.equals("uvm.")) {
                return Collections.singletonList("u.\u202fv.\u202fm.");
            }
            if (word.equals("udgl") || word.equals("udgl.")) {
                return Collections.singletonList("u.\u202fdgl.");
            }
            if (word.equals("Ruhigkeit")) {
                return Collections.singletonList("Ruhe");
            }
            if (word.equals("angepreist")) {
                return Collections.singletonList("angepriesen");
            }
            if (word.equals("halo")) {
                return Collections.singletonList("hallo");
            }
            if (word.equalsIgnoreCase("zumindestens")) {
                return Collections.singletonList(word.replace("ens", ""));
            }
            if (word.equals("ca")) {
                return Collections.singletonList("ca.");
            }
            if (word.equals("Jezt")) {
                return Collections.singletonList("Jetzt");
            }
            if (word.equals("Wollst")) {
                return Collections.singletonList("Wolltest");
            }
            if (word.equals("wollst")) {
                return Collections.singletonList("wolltest");
            }
            if (word.equals("Rolladen")) {
                return Collections.singletonList("Rollladen");
            }
            if (word.equals("Ma\u00dfname")) {
                return Collections.singletonList("Ma\u00dfnahme");
            }
            if (word.equals("Ma\u00dfnamen")) {
                return Collections.singletonList("Ma\u00dfnahmen");
            }
            if (word.equals("nanten")) {
                return Collections.singletonList("nannten");
            }
            if (word.endsWith("ies")) {
                if (word.equals("Stories")) {
                    return Collections.singletonList("Storys");
                }
                if (word.equals("Lobbies")) {
                    return Collections.singletonList("Lobbys");
                }
                if (word.equals("Hobbies")) {
                    return Collections.singletonList("Hobbys");
                }
                if (word.equals("Parties")) {
                    return Collections.singletonList("Partys");
                }
                if (word.equals("Babies")) {
                    return Collections.singletonList("Babys");
                }
                if (word.equals("Ladies")) {
                    return Collections.singletonList("Ladys");
                }
                if (word.endsWith("derbies") ? this.hunspell.spell(suggestion = word.replaceFirst("derbies$", "derbys")) : (word.endsWith("stories") ? this.hunspell.spell(suggestion = word.replaceFirst("stories$", "storys")) : word.endsWith("parties") && this.hunspell.spell(suggestion = word.replaceFirst("parties$", "partys")))) {
                    return Collections.singletonList(suggestion);
                }
            } else {
                if (word.equals("Hallochen")) {
                    return Arrays.asList("Hall\u00f6chen", "hall\u00f6chen");
                }
                if (word.equals("hallochen")) {
                    return Collections.singletonList("hall\u00f6chen");
                }
                if (word.equals("ok")) {
                    return Arrays.asList("okay", "O.\u202fK.");
                }
                if (word.equals("gesuchen")) {
                    return Arrays.asList("gesuchten", "gesucht");
                }
                if (word.equals("Germanistiker")) {
                    return Arrays.asList("Germanist", "Germanisten");
                }
                if (word.equals("Abschlepper")) {
                    return Arrays.asList("Abschleppdienst", "Abschleppwagen");
                }
                if (word.equals("par")) {
                    return Collections.singletonList("paar");
                }
                if (word.equals("vllt")) {
                    return Collections.singletonList("vielleicht");
                }
                if (word.equals("iwie")) {
                    return Collections.singletonList("irgendwie");
                }
                if (word.equals("bzgl")) {
                    return Collections.singletonList("bzgl.");
                }
                if (word.equals("bau")) {
                    return Collections.singletonList("baue");
                }
                if (word.equals("sry")) {
                    return Collections.singletonList("sorry");
                }
                if (word.equals("Sry")) {
                    return Collections.singletonList("Sorry");
                }
                if (word.equals("thx")) {
                    return Collections.singletonList("danke");
                }
                if (word.equals("Thx")) {
                    return Collections.singletonList("Danke");
                }
                if (word.equals("Zynik")) {
                    return Collections.singletonList("Zynismus");
                }
                if (word.length() > 9 && word.startsWith("Email")) {
                    String suffix = word.substring(5);
                    if (!this.hunspell.spell(suffix)) {
                        List suffixSuggestions = this.hunspell.suggest(StringTools.uppercaseFirstChar((String)suffix));
                        suffix = suffixSuggestions.isEmpty() ? suffix : (String)suffixSuggestions.get(0);
                    }
                    return Collections.singletonList("E-Mail-" + Character.toUpperCase(suffix.charAt(0)) + suffix.substring(1));
                }
                if (word.equals("wiederspiegeln")) {
                    return Collections.singletonList("widerspiegeln");
                }
                if (word.equals("ch")) {
                    return Collections.singletonList("ich");
                }
                for (Pattern p : ADDITIONAL_SUGGESTIONS.keySet()) {
                    if (!p.matcher(word).matches()) continue;
                    return ADDITIONAL_SUGGESTIONS.get(p).apply(word);
                }
            }
        }
        if (!StringTools.startsWithUppercase((String)word) && !suggestions.contains(ucWord = StringTools.uppercaseFirstChar((String)word)) && this.hunspell.spell(ucWord) && !ucWord.endsWith(".")) {
            return Collections.singletonList(ucWord);
        }
        String verbSuggestion = this.getPastTenseVerbSuggestion(word);
        if (verbSuggestion != null) {
            return Collections.singletonList(verbSuggestion);
        }
        String participleSuggestion = this.getParticipleSuggestion(word);
        if (participleSuggestion != null) {
            return Collections.singletonList(participleSuggestion);
        }
        String abbreviationSuggestion = this.getAbbreviationSuggestion(word);
        if (abbreviationSuggestion != null) {
            return Collections.singletonList(abbreviationSuggestion);
        }
        if (suggestions.isEmpty() && word.contains("-") && (words = word.split("-")).length > 1) {
            ArrayList<List<String>> suggestionLists = new ArrayList<List<String>>(words.length);
            int startAt = 0;
            int stopAt = words.length;
            String partialWord = words[0] + "-" + words[1];
            if (super.ignoreWord(partialWord) || this.wordsToBeIgnoredInCompounds.contains(partialWord)) {
                startAt = 2;
                suggestionLists.add(Collections.singletonList(words[0] + "-" + words[1]));
            }
            if (super.ignoreWord(partialWord = words[words.length - 2] + "-" + words[words.length - 1]) || this.wordsToBeIgnoredInCompounds.contains(partialWord)) {
                stopAt = words.length - 2;
            }
            for (int idx = startAt; idx < stopAt; ++idx) {
                if (!this.hunspell.spell(words[idx])) {
                    List<String> list = this.sortSuggestionByQuality(words[idx], super.getSuggestions(words[idx]));
                    suggestionLists.add(list);
                    continue;
                }
                suggestionLists.add(Collections.singletonList(words[idx]));
            }
            if (stopAt < words.length - 1) {
                suggestionLists.add(Collections.singletonList(partialWord));
            }
            if (suggestionLists.size() <= 3) {
                ArrayList<String> additionalSuggestions = (ArrayList<String>)suggestionLists.get(0);
                for (int idx = 1; idx < suggestionLists.size(); ++idx) {
                    List suggestionList = (List)suggestionLists.get(idx);
                    ArrayList<String> newList = new ArrayList<String>(additionalSuggestions.size() * suggestionList.size());
                    for (String additionalSuggestion : additionalSuggestions) {
                        for (String aSuggestionList : suggestionList) {
                            newList.add(additionalSuggestion + "-" + aSuggestionList);
                        }
                    }
                    additionalSuggestions = newList;
                }
                return additionalSuggestions.subList(0, Math.min(5, additionalSuggestions.size()));
            }
        }
        return Collections.emptyList();
    }

    @Nullable
    private String getPastTenseVerbSuggestion(String word) {
        if (word.endsWith("e")) {
            String wordStem = word.substring(0, word.length() - 1);
            try {
                AnalyzedToken token;
                String[] forms;
                String lemma = this.baseForThirdPersonSingularVerb(wordStem);
                if (lemma != null && (forms = this.synthesizer.synthesize(token = new AnalyzedToken(lemma, null, lemma), "VER:3:SIN:PRT:.*", true)).length > 0) {
                    return forms[0];
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Nullable
    private String baseForThirdPersonSingularVerb(String word) throws IOException {
        List readings = this.tagger.tag(Collections.singletonList(word));
        for (AnalyzedTokenReadings reading : readings) {
            if (!reading.hasPosTagStartingWith("VER:3:SIN")) continue;
            return ((AnalyzedToken)reading.getReadings().get(0)).getLemma();
        }
        return null;
    }

    @Nullable
    private String getParticipleSuggestion(String word) {
        if (word.startsWith("ge") && word.endsWith("t")) {
            String baseform = word.substring(2, word.length() - 1) + "en";
            try {
                String participle = this.getParticipleForBaseform(baseform);
                if (participle != null) {
                    return participle;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Nullable
    private String getParticipleForBaseform(String baseform) throws IOException {
        AnalyzedToken token = new AnalyzedToken(baseform, null, baseform);
        String[] forms = this.synthesizer.synthesize(token, "VER:PA2:.*", true);
        if (forms.length > 0 && this.hunspell.spell(forms[0])) {
            return forms[0];
        }
        return null;
    }

    private String getAbbreviationSuggestion(String word) throws IOException {
        if (word.length() < 5) {
            List readings = this.tagger.tag(Collections.singletonList(word));
            for (AnalyzedTokenReadings reading : readings) {
                if (!reading.hasPosTagStartingWith("ABK")) continue;
                return word + ".";
            }
        }
        return null;
    }

    private boolean ignoreByHangingHyphen(List<String> words, int idx) throws IOException {
        boolean isCompound;
        String word = words.get(idx);
        String nextWord = this.getWordAfterEnumerationOrNull(words, idx + 1);
        boolean bl = isCompound = (nextWord = StringUtils.removeEnd((String)nextWord, (String)".")) != null && (this.compoundTokenizer.tokenize(nextWord).size() > 1 || nextWord.indexOf(45) > 0);
        if (isCompound) {
            boolean isMisspelled;
            boolean bl2 = isMisspelled = !this.hunspell.spell(word = StringUtils.removeEnd((String)word, (String)"-"));
            if (isMisspelled && (super.ignoreWord(word) || this.wordsToBeIgnoredInCompounds.contains(word))) {
                isMisspelled = false;
            } else if (isMisspelled && word.endsWith("s") && this.isNeedingFugenS(StringUtils.removeEnd((String)word, (String)"s"))) {
                isMisspelled = !this.hunspell.spell(StringUtils.removeEnd((String)word, (String)"s"));
            }
            return !isMisspelled;
        }
        return false;
    }

    private boolean isNeedingFugenS(String word) {
        return StringUtils.endsWithAny((CharSequence)word, (CharSequence[])new CharSequence[]{"tum", "ling", "ion", "t\u00e4t", "keit", "schaft", "sicht", "ung", "en"});
    }

    @Nullable
    private String getWordAfterEnumerationOrNull(List<String> words, int idx) {
        for (int i = idx; i < words.size(); ++i) {
            String word = words.get(i);
            if (word.endsWith("-") || StringUtils.equalsAny((CharSequence)word, (CharSequence[])new CharSequence[]{",", "und", "oder", "sowie"}) || word.trim().isEmpty()) continue;
            return word;
        }
        return null;
    }

    private boolean ignoreCompoundWithIgnoredWord(String word) throws IOException {
        if (!StringTools.startsWithUppercase((String)word) && !StringUtils.startsWithAny((CharSequence)word, (CharSequence[])new CharSequence[]{"nord", "west", "ost", "s\u00fcd"})) {
            return false;
        }
        String[] words = word.split("-");
        if (words.length < 2) {
            int end = super.startsWithIgnoredWord(word, true);
            if (end < 3) {
                if (word.startsWith("ost") || word.startsWith("s\u00fcd")) {
                    end = 3;
                } else if (word.startsWith("west") || word.startsWith("nord")) {
                    end = 4;
                } else {
                    return false;
                }
            }
            String ignoredWord = word.substring(0, end);
            String partialWord = word.substring(end);
            boolean isCandidateForNonHyphenatedCompound = !StringUtils.isAllUpperCase((CharSequence)ignoredWord) && (StringUtils.isAllLowerCase((CharSequence)partialWord) || ignoredWord.endsWith("-"));
            boolean needFugenS = this.isNeedingFugenS(ignoredWord);
            if (isCandidateForNonHyphenatedCompound && !needFugenS && partialWord.length() > 2) {
                return this.hunspell.spell(partialWord) || this.hunspell.spell(StringUtils.capitalize((String)partialWord));
            }
            if (isCandidateForNonHyphenatedCompound && needFugenS && partialWord.length() > 2) {
                partialWord = partialWord.startsWith("s") ? partialWord.substring(1) : partialWord;
                return this.hunspell.spell(partialWord) || this.hunspell.spell(StringUtils.capitalize((String)partialWord));
            }
            return false;
        }
        boolean hasIgnoredWord = false;
        ArrayList<String> toSpellCheck = new ArrayList<String>(3);
        String stripFirst = word.substring(words[0].length() + 1);
        String stripLast = word.substring(0, word.length() - words[words.length - 1].length() - 1);
        if (super.ignoreWord(stripFirst) || this.wordsToBeIgnoredInCompounds.contains(stripFirst)) {
            hasIgnoredWord = true;
            if (!super.ignoreWord(words[0])) {
                toSpellCheck.add(words[0]);
            }
        } else if (super.ignoreWord(stripLast) || this.wordsToBeIgnoredInCompounds.contains(stripLast)) {
            hasIgnoredWord = true;
            if (!super.ignoreWord(words[words.length - 1])) {
                toSpellCheck.add(words[words.length - 1]);
            }
        } else {
            for (String word1 : words) {
                if (super.ignoreWord(word1) || this.wordsToBeIgnoredInCompounds.contains(word1)) {
                    hasIgnoredWord = true;
                    continue;
                }
                toSpellCheck.add(word1);
            }
        }
        if (hasIgnoredWord) {
            for (String w : toSpellCheck) {
                if (this.hunspell.spell(w)) continue;
                return false;
            }
        }
        return hasIgnoredWord;
    }

    protected boolean isQuotedCompound(AnalyzedSentence analyzedSentence, int idx, String token) {
        if (idx > 3 && token.startsWith("-")) {
            return StringUtils.equalsAny((CharSequence)analyzedSentence.getTokens()[idx - 1].getToken(), (CharSequence[])new CharSequence[]{"\u201c", "\""}) && StringUtils.equalsAny((CharSequence)analyzedSentence.getTokens()[idx - 3].getToken(), (CharSequence[])new CharSequence[]{"\u201e", "\""});
        }
        return false;
    }

    protected void addProhibitedWords(List<String> words) {
        if (words.size() == 1 && words.get(0).endsWith(".*")) {
            this.wordStartsToBeProhibited.add(words.get(0).substring(0, words.get(0).length() - 2));
        } else if (words.get(0).startsWith(".*")) {
            words.stream().forEach(word -> this.wordEndingsToBeProhibited.add(word.substring(2)));
        } else {
            super.addProhibitedWords(words);
        }
    }

    static {
        GermanSpellerRule.put("lieder", (String w) -> Arrays.asList("leider", "Lieder"));
        GermanSpellerRule.put("da\u00df", "dass");
        GermanSpellerRule.put("Frauenhofer", "Fraunhofer");
        GermanSpellerRule.put("Vieleicht", "Vielleicht");
        GermanSpellerRule.put("inbetracht", "in Betracht");
        GermanSpellerRule.put("\u00fcberwhatsapp", "\u00fcber WhatsApp");
        GermanSpellerRule.put("\u00fcberzoom", "\u00fcber Zoom");
        GermanSpellerRule.put("\u00fcberwei\u00dft", "\u00fcberweist");
        GermanSpellerRule.put("\u00fcbergoogle", "\u00fcber Google");
        GermanSpellerRule.put("einlogen", "einloggen");
        GermanSpellerRule.put("Kruks", "Krux");
        GermanSpellerRule.put("Filterbubble", "Filterblase");
        GermanSpellerRule.put("Filterbubbles", "Filterblasen");
        GermanSpellerRule.putRepl("Analgen.*", "Analgen", "Anlagen");
        GermanSpellerRule.putRepl("wiedersteh(en|st|t)", "wieder", "wider");
        GermanSpellerRule.putRepl("wiederstan(d|den|dest)", "wieder", "wider");
        GermanSpellerRule.putRepl("wiedersprech(e|t|en)?", "wieder", "wider");
        GermanSpellerRule.putRepl("wiedersprich(st|t)?", "wieder", "wider");
        GermanSpellerRule.putRepl("wiedersprach(st|t|en)?", "wieder", "wider");
        GermanSpellerRule.putRepl("wiederruf(e|st|t|en)?", "wieder", "wider");
        GermanSpellerRule.putRepl("wiederrief(st|t|en)?", "wieder", "wider");
        GermanSpellerRule.putRepl("wiederleg(e|st|t|en|te|ten)?", "wieder", "wider");
        GermanSpellerRule.putRepl("wiederhall(e|st|t|en|te|ten)?", "wieder", "wider");
        GermanSpellerRule.putRepl("wiedersetz(e|t|en|te|ten)?", "wieder", "wider");
        GermanSpellerRule.putRepl("wiederstreb(e|st|t|en|te|ten)?", "wieder", "wider");
        GermanSpellerRule.put("gesynct", "synchronisiert");
        GermanSpellerRule.put("gesynced", "synchronisiert");
        GermanSpellerRule.put("gesyncht", "synchronisiert");
        GermanSpellerRule.put("gesyngt", "synchronisiert");
        GermanSpellerRule.put("synce", "synchronisiere");
        GermanSpellerRule.put("synche", "synchronisiere");
        GermanSpellerRule.put("syncen", "synchronisieren");
        GermanSpellerRule.put("synchen", "synchronisieren");
        GermanSpellerRule.put("wiederspiegelten", "widerspiegelten");
        GermanSpellerRule.put("wiedererwarten", "wider Erwarten");
        GermanSpellerRule.put("widerholen", "wiederholen");
        GermanSpellerRule.put("wiederhohlen", "wiederholen");
        GermanSpellerRule.put("herrunterladen", "herunterladen");
        GermanSpellerRule.put("dastellen", "darstellen");
        GermanSpellerRule.put("zuviel", "zu viel");
        GermanSpellerRule.put("abgekatertes", "abgekartetes");
        GermanSpellerRule.put("wiederspiegelt", "widerspiegelt");
        GermanSpellerRule.put("Komplexheit", "Komplexit\u00e4t");
        GermanSpellerRule.put("unterschiedet", "unterscheidet");
        GermanSpellerRule.put("einzigst", "einzig");
        GermanSpellerRule.put("Einzigst", "Einzig");
        GermanSpellerRule.put("geschumpfen", "geschimpft");
        GermanSpellerRule.put("Geschumpfen", "Geschimpft");
        GermanSpellerRule.put("Oke", "Okay");
        GermanSpellerRule.put("M\u00fc", "My");
        GermanSpellerRule.put("abschiednehmen", "Abschied nehmen");
        GermanSpellerRule.put("wars", (String w) -> Arrays.asList("war's", "war es", "warst"));
        GermanSpellerRule.put("[aA]wa", (String w) -> Arrays.asList("AWA", "ach was", "aber"));
        GermanSpellerRule.put("[aA]lsallerersten?s", (String w) -> Arrays.asList(w.replaceFirst("lsallerersten?s", "ls allererstes"), w.replaceFirst("lsallerersten?s", "ls Allererstes")));
        GermanSpellerRule.putRepl("(an|auf|ein|zu)gehangen(e[mnrs]?)?$", "hangen", "h\u00e4ngt");
        GermanSpellerRule.putRepl("[oO]key", "ey$", "ay");
        GermanSpellerRule.put("packet", "Paket");
        GermanSpellerRule.put("Thanks", "Danke");
        GermanSpellerRule.put("Ghanesen?", "Ghanaer");
        GermanSpellerRule.put("Thumberg", "Thunberg");
        GermanSpellerRule.put("Allalei", "Allerlei");
        GermanSpellerRule.put("geupdate[dt]$", "upgedatet");
        GermanSpellerRule.put("[pP]roblemhaft(e[nmrs]?)?", (String w) -> Arrays.asList(w.replaceFirst("haft", "behaftet"), w.replaceFirst("haft", "atisch")));
        GermanSpellerRule.put("rosane[mnrs]?$", (String w) -> Arrays.asList("rosa", w.replaceFirst("^rosan", "rosafarben")));
        GermanSpellerRule.put("Erbung", (String w) -> Arrays.asList("Vererbung", "Erbschaft"));
        GermanSpellerRule.put("Energiesparung", (String w) -> Arrays.asList("Energieeinsparung", "Energieersparnis"));
        GermanSpellerRule.put("Abbrechung", "Abbruch");
        GermanSpellerRule.put("Abbrechungen", (String w) -> Arrays.asList("Abbr\u00fcche", "Abbr\u00fcchen"));
        GermanSpellerRule.put("Urteilung", (String w) -> Arrays.asList("Urteil", "Verurteilung"));
        GermanSpellerRule.put("allm\u00f6glichen?", (String w) -> Arrays.asList("alle m\u00f6glichen", "alle m\u00f6gliche"));
        GermanSpellerRule.put("Krankenhausen", (String w) -> Arrays.asList("Krankenh\u00e4usern", "Krankenh\u00e4user"));
        GermanSpellerRule.put("vorr?auss?etzlich", (String w) -> Arrays.asList("voraussichtlich", "vorausgesetzt"));
        GermanSpellerRule.put("nichtmals", (String w) -> Arrays.asList("nicht mal", "nicht einmal"));
        GermanSpellerRule.put("eingepeilt", "angepeilt");
        GermanSpellerRule.put("gekukt", "geguckt");
        GermanSpellerRule.put("nem", "einem");
        GermanSpellerRule.put("nen", "einen");
        GermanSpellerRule.put("geb", "gebe");
        GermanSpellerRule.put("\u00fcberhaut", "\u00fcberhaupt");
        GermanSpellerRule.put("nacher", "nachher");
        GermanSpellerRule.put("jeztz", "jetzt");
        GermanSpellerRule.put("les", "lese");
        GermanSpellerRule.put("wr", "wir");
        GermanSpellerRule.put("bezweifel", "bezweifle");
        GermanSpellerRule.put("verzweifel", "verzweifle");
        GermanSpellerRule.put("zweifel", "zweifle");
        GermanSpellerRule.put("[wW]ah?rscheindlichkeit", "Wahrscheinlichkeit");
        GermanSpellerRule.put("Hijab", "Hidsch\u0101b");
        GermanSpellerRule.put("[lL]eerequiment", "Leerequipment");
        GermanSpellerRule.put("unausl\u00e4sslich", (String w) -> Arrays.asList("unerl\u00e4sslich", "unabl\u00e4ssig", "unausl\u00f6schlich"));
        GermanSpellerRule.put("Registration", "Registrierung");
        GermanSpellerRule.put("Registrationen", "Registrierungen");
        GermanSpellerRule.put("Spinnenweben", "Spinnweben");
        GermanSpellerRule.putRepl("[Ww]ar ne", "ne", "eine");
        GermanSpellerRule.putRepl("[\u00c4\u00e4]nliche[rnms]?", "nlich", "hnlich");
        GermanSpellerRule.putRepl("[Gg]arnix", "nix", "nichts");
        GermanSpellerRule.putRepl("[Ww]i", "i", "ie");
        GermanSpellerRule.putRepl("[uU]nausl\u00e4sslich(e[mnrs]?)?", "aus", "er");
        GermanSpellerRule.putRepl("[vV]erewiglicht(e[mnrs]?)?", "lich", "");
        GermanSpellerRule.putRepl("[zZ]eritifiert(e[mnrs]?)?", "eritifiert", "ertifiziert");
        GermanSpellerRule.putRepl("ger\u00e4hten?", "ger\u00e4ht", "Ger\u00e4t");
        GermanSpellerRule.putRepl("leptops?", "lep", "Lap");
        GermanSpellerRule.putRepl("[pP]ie?rsings?", "[pP]ie?rsing", "Piercing");
        GermanSpellerRule.putRepl("for?melar(en?)?", "for?me", "Formu");
        GermanSpellerRule.putRepl("n\u00e4ste[mnrs]?$", "^n\u00e4s", "n\u00e4chs");
        GermanSpellerRule.putRepl("Erdogans?$", "^Erdogan", "Erdo\u011fan");
        GermanSpellerRule.put("Germanistiker[ns]", "Germanisten");
        GermanSpellerRule.putRepl("Germanistikerin(nen)?", "Germanistiker", "Germanist");
        GermanSpellerRule.putRepl("[iI]ns?z[ie]nie?rung(en)?", "[iI]ns?z[ie]nie?", "Inszenie");
        GermanSpellerRule.putRepl("[eE]rh\u00f6herung(en)?", "[eE]rh\u00f6herung", "Erh\u00f6hung");
        GermanSpellerRule.putRepl("[vV]ersp\u00e4terung(en)?", "sp\u00e4ter", "sp\u00e4t");
        GermanSpellerRule.putRepl("[vV]orallendingen", "orallendingen", "or allen Dingen");
        GermanSpellerRule.putRepl("[aA]ufjede[nm]fall", "jede[nm]fall$", " jeden Fall");
        GermanSpellerRule.putRepl("[aA]us[vf]ersehen[dt]lich", "[vf]ersehen[dt]lich", " Versehen");
        GermanSpellerRule.putRepl("^funk?z[ou]nier.+", "funk?z[ou]nier", "funktionier");
        GermanSpellerRule.putRepl("[wW]\u00f6ruber", "\u00f6ru", "or\u00fc");
        GermanSpellerRule.putRepl("[lL]einensamens?", "[lL]einen", "Lein");
        GermanSpellerRule.putRepl("Feinleiner[ns]?", "Feinlei", "Fineli");
        GermanSpellerRule.putRepl("[hH]eilei[td]s?", "[hH]eilei[td]", "Highlight");
        GermanSpellerRule.putRepl("Oldheimer[ns]?", "he", "t");
        GermanSpellerRule.putRepl("[tT]r\u00e4ner[ns]?", "[tT]r\u00e4", "Trai");
        GermanSpellerRule.putRepl("[tT]eimings?", "[tT]e", "T");
        GermanSpellerRule.putRepl("unternehmensl[u\u00fc]stig(e[mnrs]?)?", "mensl[u\u00fc]st", "mungslust");
        GermanSpellerRule.putRepl("proff?ess?ional(e[mnrs]?)?", "ff?ess?ional", "fessionell");
        GermanSpellerRule.putRepl("zuverl\u00e4sslich(e[mnrs]?)?", "lich", "ig");
        GermanSpellerRule.putRepl("fluoreszenzierend(e[mnrs]?)?", "zen", "");
        GermanSpellerRule.putRepl("revalierend(e[mnrs]?)?", "^reval", "rivalis");
        GermanSpellerRule.putRepl("verh\u00e4uft(e[mnrs]?)?", "^ver", "ge");
        GermanSpellerRule.putRepl("st\u00fcrmig(e[mnrs]?)?", "mig", "misch");
        GermanSpellerRule.putRepl("gr\u00f6\u00dfeste[mnrs]?", "\u00dfes", "\u00df");
        GermanSpellerRule.putRepl("n[a\u00e4]heste[mnrs]?", "n[a\u00e4]he", "n\u00e4ch");
        GermanSpellerRule.putRepl("gesundlich(e[mnrs]?)?", "lich", "heitlich");
        GermanSpellerRule.putRepl("eckel(e|t(en?)?|st)?", "^eck", "ek");
        GermanSpellerRule.putRepl("unhervorgesehen(e[mnrs]?)?", "hervor", "vorher");
        GermanSpellerRule.putRepl("entt?euscht(e[mnrs]?)?", "entt?eusch", "entt\u00e4usch");
        GermanSpellerRule.putRepl("Ph\u00e4hlen?", "^Ph", "Pf");
        GermanSpellerRule.putRepl("Kattermesser[ns]?", "Ka", "Cu");
        GermanSpellerRule.putRepl("gehe?rr?t(e[mnrs]?)?", "he?rr?", "ehr");
        GermanSpellerRule.putRepl("gehrter?", "^ge", "gee");
        GermanSpellerRule.putRepl("[nN]amenhaft(e[mnrs]?)?", "amen", "am");
        GermanSpellerRule.putRepl("hom(o?e|\u00f6)ophatisch(e[mnrs]?)?", "hom(o?e|\u00f6)ophat", "hom\u00f6opath");
        GermanSpellerRule.putRepl("Geschwindlichkeit(en)?", "lich", "ig");
        GermanSpellerRule.putRepl("J\u00e4nners?", "J\u00e4nner", "Januar");
        GermanSpellerRule.putRepl("[\u00e4\u00c4]hlich(e[mnrs]?)?", "lich", "nlich");
        GermanSpellerRule.putRepl("entf[ai]ngen?", "ent", "emp");
        GermanSpellerRule.putRepl("entf[\u00e4i]ngs?t", "ent", "emp");
        GermanSpellerRule.putRepl("[Bb]ehilfreich(e[rnms]?)", "reich", "lich");
        GermanSpellerRule.putRepl("[Bb]zgl", "zgl", "zgl.");
        GermanSpellerRule.putRepl("kaltnass(e[rnms]?)", "kaltnass", "nasskalt");
        GermanSpellerRule.putRepl("Kaltnass(e[rnms]?)", "Kaltnass", "Nasskalt");
        GermanSpellerRule.put("check", "checke");
        GermanSpellerRule.put("R\u00fcckrad", "R\u00fcckgrat");
        GermanSpellerRule.put("ala", "\u00e0 la");
        GermanSpellerRule.put("Ala", "\u00c0 la");
        GermanSpellerRule.put("Reinfolge", "Reihenfolge");
        GermanSpellerRule.put("Schlo\u00df", "Schloss");
        GermanSpellerRule.put("Investion", "Investition");
        GermanSpellerRule.put("Beleidung", "Beleidigung");
        GermanSpellerRule.put("Bole", "Bowle");
        GermanSpellerRule.put("letzens", "letztens");
        GermanSpellerRule.put("Pakur", (String w) -> Arrays.asList("Parcours", "Parkuhr"));
        GermanSpellerRule.put("Erstsemesterin", (String w) -> Arrays.asList("Erstsemester", "Erstsemesters", "Erstsemesterstudentin"));
        GermanSpellerRule.put("Erstsemesterinnen", (String w) -> Arrays.asList("Erstsemesterstudentinnen", "Erstsemester", "Erstsemestern"));
        GermanSpellerRule.put("kreativlos(e[nmrs]?)?", (String w) -> Arrays.asList(w.replaceFirst("kreativ", "fantasie"), w.replaceFirst("kreativ", "einfalls"), w.replaceFirst("kreativlos", "unkreativ"), w.replaceFirst("kreativlos", "uninspiriert")));
        GermanSpellerRule.put("Kreativlosigkeit", "Unkreativit\u00e4t");
        GermanSpellerRule.put("hinund?her", "hin und her");
        GermanSpellerRule.put("[lL]ymph?trie?nasche", "Lymphdrainage");
        GermanSpellerRule.put("Interdeterminismus", "Indeterminismus");
        GermanSpellerRule.put("elektrit\u00e4t", "Elektrizit\u00e4t");
        GermanSpellerRule.put("ausgeboten", "ausgebootet");
        GermanSpellerRule.put("nocheinmall", "noch einmal");
        GermanSpellerRule.put("a\u00fc\u00dferst", "\u00e4u\u00dferst");
        GermanSpellerRule.put("Grr\u00f6sse", "Gr\u00f6\u00dfe");
        GermanSpellerRule.put("misverst\u00e4ndniss", "Missverst\u00e4ndnis");
        GermanSpellerRule.put("warheit", "Wahrheit");
        GermanSpellerRule.put("[pP]okemon", "Pok\u00e9mon");
        GermanSpellerRule.put("kreigt", "kriegt");
        GermanSpellerRule.put("Frit\u00f6se", "Fritteuse");
        GermanSpellerRule.put("unerkennlich", "unkenntlich");
        GermanSpellerRule.put("r\u00fcckg[\u00e4e]nglich", "r\u00fcckg\u00e4ngig");
        GermanSpellerRule.put("em?men[sz]", "immens");
        GermanSpellerRule.put("verhing", "verh\u00e4ngte");
        GermanSpellerRule.put("verhingen", "verh\u00e4ngten");
        GermanSpellerRule.put("fangte", "fing");
        GermanSpellerRule.put("fangten", "fingen");
        GermanSpellerRule.put("schlie[s\u00df]te", "schloss");
        GermanSpellerRule.put("schlie[s\u00df]ten", "schlossen");
        GermanSpellerRule.put("past", "passt");
        GermanSpellerRule.put("eingetragt", "eingetragen");
        GermanSpellerRule.put("getrunkt", "getrunken");
        GermanSpellerRule.put("ver\u00e4ht", "verr\u00e4t");
        GermanSpellerRule.put("helfte", "half");
        GermanSpellerRule.put("helften", "halfen");
        GermanSpellerRule.put("lad", "lade");
        GermanSpellerRule.put("befehlte", "befahl");
        GermanSpellerRule.put("befehlten", "befahlen");
        GermanSpellerRule.put("angel\u00fcgt", "angelogen");
        GermanSpellerRule.put("l\u00fcgte", "log");
        GermanSpellerRule.put("l\u00fcgten", "logen");
        GermanSpellerRule.put("bratete", "briet");
        GermanSpellerRule.put("brateten", "brieten");
        GermanSpellerRule.put("gefahl", "gefiel");
        GermanSpellerRule.put("Komplexibilit\u00e4t", "Komplexit\u00e4t");
        GermanSpellerRule.put("abbonement", "Abonnement");
        GermanSpellerRule.put("zugegebenerweise", "zugegebenerma\u00dfen");
        GermanSpellerRule.put("perse", "per se");
        GermanSpellerRule.put("Schwitch", "Switch");
        GermanSpellerRule.put("[aA]nwesenzeiten", "Anwesenheitszeiten");
        GermanSpellerRule.put("[gG]eizigkeit", "Geiz");
        GermanSpellerRule.put("[fF]lei\u00dfigkeit", "Flei\u00df");
        GermanSpellerRule.put("[bB]equemheit", "Bequemlichkeit");
        GermanSpellerRule.put("[mM]issionarie?sie?rung", "Missionierung");
        GermanSpellerRule.put("[sS]chee?selonge?", "Chaiselongue");
        GermanSpellerRule.put("Re[kc]amiere", "R\u00e9cami\u00e8re");
        GermanSpellerRule.put("Singel", "Single");
        GermanSpellerRule.put("legen[td]lich", "lediglich");
        GermanSpellerRule.put("ein[ua]ndhalb", "eineinhalb");
        GermanSpellerRule.put("[mM]illion(en)?mal", (String w) -> Collections.singletonList(StringTools.uppercaseFirstChar((String)w.replaceFirst("mal", " Mal"))));
        GermanSpellerRule.put("Mysql", "MySQL");
        GermanSpellerRule.put("MWST", "MwSt");
        GermanSpellerRule.put("Mwst", "MwSt");
        GermanSpellerRule.put("Opelarena", "Opel Arena");
        GermanSpellerRule.put("Toll-Collect", "Toll Collect");
        GermanSpellerRule.put("[pP][qQ]-Formel", "p-q-Formel");
        GermanSpellerRule.put("desweitere?[nm]", "des Weiteren");
        GermanSpellerRule.put("handzuhaben", "zu handhaben");
        GermanSpellerRule.put("nachvollzuziehe?n", "nachzuvollziehen");
        GermanSpellerRule.put("Porto?folien", "Portfolios");
        GermanSpellerRule.put("[sS]chwie?ri?chkeiten", "Schwierigkeiten");
        GermanSpellerRule.put("[\u00fc\u00dc]bergrifflichkeiten", "\u00dcbergriffigkeiten");
        GermanSpellerRule.put("[aA]r?th?rie?th?is", "Arthritis");
        GermanSpellerRule.put("zugesand", "zugesandt");
        GermanSpellerRule.put("weibt", "wei\u00dft");
        GermanSpellerRule.put("fress", "friss");
        GermanSpellerRule.put("Mamma", "Mama");
        GermanSpellerRule.put("Pr\u00e4se", "Pr\u00e4sentation");
        GermanSpellerRule.put("Pr\u00e4sen", "Pr\u00e4sentationen");
        GermanSpellerRule.put("Orga", "Organisation");
        GermanSpellerRule.put("Orgas", "Organisationen");
        GermanSpellerRule.put("instande?zusetzen", "instand zu setzen");
        GermanSpellerRule.put("Lia(si|is)onen", "Liaisons");
        GermanSpellerRule.put("[cC]asemana?ge?ment", "Case Management");
        GermanSpellerRule.put("[aA]nn?[ou]ll?ie?rung", "Annullierung");
        GermanSpellerRule.put("[sS]charm", "Charme");
        GermanSpellerRule.put("[zZ]auberlich(e[mnrs]?)?", (String w) -> Arrays.asList(w.replaceFirst("lich", "isch"), w.replaceFirst("lich", "haft")));
        GermanSpellerRule.putRepl("[Dd]rumrum", "rum$", "herum");
        GermanSpellerRule.putRepl("([uU]n)?proff?esionn?ell?(e[mnrs]?)?", "proff?esionn?ell?", "professionell");
        GermanSpellerRule.putRepl("[kK]inderlich(e[mnrs]?)?", "inder", "ind");
        GermanSpellerRule.putRepl("[wW]iedersprichs?t", "ieder", "ider");
        GermanSpellerRule.putRepl("[wW]hite-?[Ll]abels", "[wW]hite-?[Ll]abel", "White Label");
        GermanSpellerRule.putRepl("[wW]iederstand", "ieder", "ider");
        GermanSpellerRule.putRepl("[kK]\u00f6nntes", "es$", "est");
        GermanSpellerRule.putRepl("[aA]ssess?oare?s?", "[aA]ssess?oare?", "Accessoire");
        GermanSpellerRule.putRepl("indifiziert(e[mnrs]?)?", "ind", "ident");
        GermanSpellerRule.putRepl("dreite[mnrs]?", "dreit", "dritt");
        GermanSpellerRule.putRepl("verbl\u00fcte[mnrs]?", "bl\u00fc", "bl\u00fch");
        GermanSpellerRule.putRepl("Einzigste[mnrs]?", "zigst", "zig");
        GermanSpellerRule.putRepl("Invests?", "Invest", "Investment");
        GermanSpellerRule.putRepl("(aller)?einzie?gste[mnrs]?", "(aller)?einzie?gst", "einzig");
        GermanSpellerRule.putRepl("[iI]nterkurell(e[nmrs]?)?", "ku", "kultu");
        GermanSpellerRule.putRepl("[iI]ntersannt(e[mnrs]?)?", "sannt", "essant");
        GermanSpellerRule.putRepl("ubera(g|sch)end(e[nmrs]?)?", "uber", "\u00fcberr");
        GermanSpellerRule.putRepl("[Hh]ello", "ello", "allo");
        GermanSpellerRule.putRepl("[Gg]etagged", "gged", "ggt");
        GermanSpellerRule.putRepl("[wW]olt$", "lt", "llt");
        GermanSpellerRule.putRepl("[zZ]uende", "ue", "u E");
        GermanSpellerRule.putRepl("[iI]nb\u00e4lde", "nb", "n B");
        GermanSpellerRule.putRepl("[lL]etztenendes", "ene", "en E");
        GermanSpellerRule.putRepl("[nN]achwievor", "wievor", " wie vor");
        GermanSpellerRule.putRepl("[zZ]umbeispiel", "beispiel", " Beispiel");
        GermanSpellerRule.putRepl("[gG]ottseidank", "[gG]ottseidank", "Gott sei Dank");
        GermanSpellerRule.putRepl("[gG]rundauf", "[gG]rundauf", "Grund auf");
        GermanSpellerRule.putRepl("[aA]nsichtnach", "[aA]nsicht", "Ansicht ");
        GermanSpellerRule.putRepl("[uU]n[sz]war", "[sz]war", "d zwar");
        GermanSpellerRule.putRepl("[wW]aschte(s?t)?", "aschte", "usch");
        GermanSpellerRule.putRepl("[wW]aschten", "ascht", "usch");
        GermanSpellerRule.putRepl("Probiren?", "ir", "ier");
        GermanSpellerRule.putRepl("[gG]esetztreu(e[nmrs]?)?", "tz", "tzes");
        GermanSpellerRule.putRepl("[wW]ikich(e[nmrs]?)?", "k", "rkl");
        GermanSpellerRule.putRepl("[uU]naufbesichtigt(e[nmrs]?)?", "aufbe", "beauf");
        GermanSpellerRule.putRepl("[nN]utzvoll(e[nmrs]?)?", "utzvoll", "\u00fctzlich");
        GermanSpellerRule.putRepl("Lezte[mnrs]?", "Lez", "Letz");
        GermanSpellerRule.putRepl("Letze[mnrs]?", "Letz", "Letzt");
        GermanSpellerRule.putRepl("[nN]i[vw]os?", "[nN]i[vw]o", "Niveau");
        GermanSpellerRule.putRepl("[dD]illetant(en)?", "[dD]ille", "Dilet");
        GermanSpellerRule.putRepl("Frauenhofer-(Institut|Gesellschaft)", "Frauen", "Fraun");
        GermanSpellerRule.putRepl("Add-?Ons?", "Add-?On", "Add-on");
        GermanSpellerRule.putRepl("Addons?", "on", "-on");
        GermanSpellerRule.putRepl("Internetkaffees?", "kaffee", "caf\u00e9");
        GermanSpellerRule.putRepl("[gG]ehorsamkeitsverweigerung(en)?", "[gG]ehorsamkeit", "Gehorsam");
        GermanSpellerRule.putRepl("[wW]ochende[ns]?", "[wW]ochend", "Wochenend");
        GermanSpellerRule.putRepl("[kK]ongratulier(en?|t(en?)?|st)", "[kK]on", "");
        GermanSpellerRule.putRepl("[wWkKdD]an$", "n$", "nn");
        GermanSpellerRule.putRepl("geh?neh?m[ie]gung(en)?", "geh?neh?m[ie]gung", "Genehmigung");
        GermanSpellerRule.putRepl("Korrigierung(en)?", "igierung", "ektur");
        GermanSpellerRule.putRepl("[kK]orregierung(en)?", "[kK]orregierung", "Korrektur");
        GermanSpellerRule.putRepl("[kK]orrie?girung(en)?", "[kK]orrie?girung", "Korrektur");
        GermanSpellerRule.putRepl("[nN]ocheimal", "eimal", " einmal");
        GermanSpellerRule.putRepl("[aA]benzu", "enzu", " und zu");
        GermanSpellerRule.putRepl("[kK]onflikation(en)?", "[kK]onfli", "Kompli");
        GermanSpellerRule.putRepl("[mM]itanader", "ana", "einan");
        GermanSpellerRule.putRepl("[mM]itenand", "enand", "einander");
        GermanSpellerRule.putRepl("Gelangenheitsbest\u00e4tigung(en)?", "heit", "");
        GermanSpellerRule.putRepl("[jJ]edwillige[mnrs]?", "willig", "wed");
        GermanSpellerRule.putRepl("[qQ]ualit\u00e4ts?bewu\u00dft(e[mnrs]?)?", "ts?bewu\u00dft", "tsbewusst");
        GermanSpellerRule.putRepl("[vV]oraussichtig(e[nmrs]?)?", "sichtig", "sichtlich");
        GermanSpellerRule.putRepl("[gG]leichrechtig(e[nmrs]?)?", "rechtig", "berechtigt");
        GermanSpellerRule.putRepl("[uU]nn\u00fctzlich(e[nmrs]?)?", "n\u00fctzlich", "n\u00fctz");
        GermanSpellerRule.putRepl("[uU]nzerbrechbar(e[nmrs]?)?", "bar", "lich");
        GermanSpellerRule.putRepl("kolegen?", "ko", "Kol");
        GermanSpellerRule.putRepl("tableten?", "tablet", "Tablett");
        GermanSpellerRule.putRepl("verswinde(n|s?t)", "^vers", "versch");
        GermanSpellerRule.putRepl("unverantwortungsvoll(e[nmrs]?)?", "unverantwortungsvoll", "verantwortungslos");
        GermanSpellerRule.putRepl("[gG]erechtlichkeit", "[gG]erechtlich", "Gerechtig");
        GermanSpellerRule.putRepl("[zZ]uverl\u00e4sslichkeit", "lich", "ig");
        GermanSpellerRule.putRepl("[uU]nverzeilig(e[mnrs]?)?", "zeilig", "zeihlich");
        GermanSpellerRule.putRepl("[zZ]uk(ue?|\u00fc)nftlich(e[mnrs]?)?", "uk(ue?|\u00fc)nftlich", "uk\u00fcnftig");
        GermanSpellerRule.putRepl("[rR]eligi\u00f6sisch(e[nmrs]?)?", "isch", "");
        GermanSpellerRule.putRepl("[fF]olklorisch(e[nmrs]?)?", "isch", "istisch");
        GermanSpellerRule.putRepl("[eE]inf\u00fchlsvoll(e[nmrs]?)?", "voll", "am");
        GermanSpellerRule.putRepl("Unstimmlichkeit(en)?", "lich", "ig");
        GermanSpellerRule.putRepl("Strebergartens?", "Stre", "Schre");
        GermanSpellerRule.putRepl("[hH]\u00e4hern(e[mnrs]?)?", "\u00e4hern", "\u00e4ren");
        GermanSpellerRule.putRepl("todesbedroh(end|lich)(e[nmrs]?)?", "todes", "lebens");
        GermanSpellerRule.putRepl("^[uU]nabsichtig(e[nmrs]?)?", "ig", "lich");
        GermanSpellerRule.putRepl("[aA]ntisemitistisch(e[mnrs]?)?", "tist", "t");
        GermanSpellerRule.putRepl("[uU]nvorsehbar(e[mnrs]?)?", "vor", "vorher");
        GermanSpellerRule.putRepl("([eE]r|[bB]e|unter|[aA]uf)?h\u00e4lst", "h\u00e4lst", "h\u00e4ltst");
        GermanSpellerRule.put("[wW]ohlf\u00fchlseins?", (String w) -> Arrays.asList("Wellness", w.replaceFirst("[wW]ohlf\u00fchlsein", "Wohlbefinden"), w.replaceFirst("[wW]ohlf\u00fchlsein", "Wohlf\u00fchlen")));
        GermanSpellerRule.putRepl("[sS]chmett?e?rling(s|en?)?", "[sS]chmett?e?rling", "Schmetterling");
        GermanSpellerRule.putRepl("^[eE]inlamie?nie?r(st|en?|(t(e[nmrs]?)?))?", "^einlamie?nie?r", "laminier");
        GermanSpellerRule.putRepl("[bB]ravur\u00f6s(e[nrms]?)?", "vur", "vour");
        GermanSpellerRule.putRepl("[aA]ss?ecoires?", "[aA]ss?ec", "Access");
        GermanSpellerRule.putRepl("[aA]ufwechse?lungsreich(er|st)?(e[nmrs]?)?", "ufwechse?lung", "bwechslung");
        GermanSpellerRule.putRepl("[iI]nordnung", "ordnung", " Ordnung");
        GermanSpellerRule.putRepl("[iI]mmoment", "moment", " Moment");
        GermanSpellerRule.putRepl("[hH]euteabend", "abend", " Abend");
        GermanSpellerRule.putRepl("[wW]ienerschnitzel[ns]?", "[wW]ieners", "Wiener S");
        GermanSpellerRule.putRepl("[sS]chwarzw\u00e4lderkirschtorten?", "[sS]chwarzw\u00e4lderk", "Schwarzw\u00e4lder K");
        GermanSpellerRule.putRepl("[kK]oxial(e[nmrs]?)?", "x", "ax");
        GermanSpellerRule.putRepl("([\u00fc\u00dc]ber|[uU]unter)?[dD]urs?chnitt?lich(e[nmrs]?)?", "s?chnitt?", "chschnitt");
        GermanSpellerRule.putRepl("[dD]urs?chnitts?", "s?chnitt", "chschnitt");
        GermanSpellerRule.putRepl("[sS]triktlich(e[mnrs]?)?", "lich", "");
        GermanSpellerRule.putRepl("[hH]\u00f6chstwahrlich(e[mnrs]?)?", "wahr", "wahrschein");
        GermanSpellerRule.putRepl("[oO]rganisativ(e[nmrs]?)?", "tiv", "torisch");
        GermanSpellerRule.putRepl("[kK]ontaktfreundlich(e[nmrs]?)?", "ndlich", "dig");
        GermanSpellerRule.putRepl("Helfer?s-Helfer[ns]?", "Helfer?s-H", "Helfersh");
        GermanSpellerRule.putRepl("[iI]ntell?igentsbestien?", "[iI]ntell?igents", "Intelligenz");
        GermanSpellerRule.putRepl("[aA]vantgardisch(e[mnrs]?)?", "gard", "gardist");
        GermanSpellerRule.putRepl("[gG]ewohnheitsbed\u00fcrftig(e[mnrs]?)?", "wohnheit", "w\u00f6hnung");
        GermanSpellerRule.putRepl("[eE]inf\u00fchlungsvoll(e[mnrs]?)?", "f\u00fchlungsvoll", "f\u00fchlsam");
        GermanSpellerRule.putRepl("[vV]erwant(e[mnrs]?)?", "want", "wandt");
        GermanSpellerRule.putRepl("[bB]eanstandigung(en)?", "ig", "");
        GermanSpellerRule.putRepl("[eE]inba(hn|nd)frei(e[mnrs]?)?", "ba(hn|nd)", "wand");
        GermanSpellerRule.putRepl("[\u00e4\u00c4aAeE]rtzten?", "[\u00e4\u00c4aAeE]rt", "\u00c4r");
        GermanSpellerRule.putRepl("pdf-Datei(en)?", "pdf", "PDF");
        GermanSpellerRule.putRepl("rum\u00e4nern?", "rum\u00e4ner", "Rum\u00e4ne");
        GermanSpellerRule.putRepl("[cCKk]o?usengs?", "[cCKk]o?useng", "Cousin");
        GermanSpellerRule.putRepl("Influenzer(in(nen)?|[ns])?", "zer", "cer");
        GermanSpellerRule.putRepl("[vV]ersantdienstleister[ns]?", "[vV]ersant", "Versand");
        GermanSpellerRule.putRepl("[pP]atrolier(s?t|t?en?)", "atrolier", "atrouillier");
        GermanSpellerRule.putRepl("[pP]ropagandiert(e[mnrs]?)?", "and", "");
        GermanSpellerRule.putRepl("[pP]ropagandier(en|st)", "and", "");
        GermanSpellerRule.putRepl("[kK]app?erzit\u00e4t(en)?", "^[kK]app?er", "Kapa");
        GermanSpellerRule.putRepl("k\u00e4nzel(n|s?t)", "k\u00e4nzel", "cancel");
        GermanSpellerRule.put("gek\u00e4nzelt", "gecancelt");
        GermanSpellerRule.putRepl("[\u00fc\u00dc]berstreitung(en)?", "[\u00fc\u00dc]berst", "\u00dcbersch");
        GermanSpellerRule.putRepl("anschliess?lich(e(mnrs)?)?", "anschliess?lich", "anschlie\u00dfend");
        GermanSpellerRule.putRepl("[rR]ethorisch(e(mnrs)?)?", "eth", "het");
        GermanSpellerRule.putRepl("\u00e4nlich(e(mnrs)?)?", "\u00e4n", "\u00e4hn");
        GermanSpellerRule.putRepl("sp\u00e4tm\u00f6glichste(mnrs)?", "sp\u00e4tm\u00f6glichst", "sp\u00e4testm\u00f6glich");
        GermanSpellerRule.put("mogen", "morgen");
        GermanSpellerRule.put("[fF]uss?ill?ien", "Fossilien");
        GermanSpellerRule.put("\u00fcbrings", "\u00fcbrigens");
        GermanSpellerRule.put("[rR]ev\u00fc", "Revue");
        GermanSpellerRule.put("eing\u00e4nglich", "eingangs");
        GermanSpellerRule.put("geerthe", "geehrte");
        GermanSpellerRule.put("interrese", "Interesse");
        GermanSpellerRule.put("[rR]esch\u00e4rschen", "Recherchen");
        GermanSpellerRule.put("[rR]esch\u00e4rsche", "Recherche");
        GermanSpellerRule.put("ic", "ich");
        GermanSpellerRule.put("w[e\u00e4]hret", "w\u00e4ret");
        GermanSpellerRule.put("mahte", "Mathe");
        GermanSpellerRule.put("letzdenendes", "letzten Endes");
        GermanSpellerRule.put("aufgesteht", "aufgestanden");
        GermanSpellerRule.put("ganichts", "gar nichts");
        GermanSpellerRule.put("gesich", "Gesicht");
        GermanSpellerRule.put("glass", "Glas");
        GermanSpellerRule.put("muter", "Mutter");
        GermanSpellerRule.put("[pP]appa", "Papa");
        GermanSpellerRule.put("dier", "dir");
        GermanSpellerRule.put("Referenz-Nr", "Referenz-Nr.");
        GermanSpellerRule.put("Matrikelnr.", "Matrikel-Nr.");
        GermanSpellerRule.put("Rekrutings?prozess", "Recruitingprozess");
        GermanSpellerRule.put("sumarum", "summarum");
        GermanSpellerRule.put("schein", "scheine");
        GermanSpellerRule.put("Innzahlung", (String w) -> Arrays.asList("In Zahlung", "in Zahlung"));
        GermanSpellerRule.put("\u00e4nderen", (String w) -> Arrays.asList("\u00e4ndern", "anderen"));
        GermanSpellerRule.put("wanderen", (String w) -> Arrays.asList("wandern", "Wanderern"));
        GermanSpellerRule.put("Dutzen", (String w) -> Arrays.asList("Duzen", "Dutzend"));
        GermanSpellerRule.put("patien", (String w) -> Arrays.asList("Partien", "Patient"));
        GermanSpellerRule.put("Teammitgliederinnen", (String w) -> Arrays.asList("Teammitgliedern", "Teammitglieder"));
        GermanSpellerRule.put("beidige[mnrs]?", (String w) -> Arrays.asList(w.replaceFirst("ig", ""), w.replaceFirst("beid", "beiderseit"), "beeidigen"));
        GermanSpellerRule.put("Wissbegierigkeit", (String w) -> Arrays.asList("Wissbegier", "Wissbegierde"));
        GermanSpellerRule.put("Nabend", "'n Abend");
        GermanSpellerRule.put("gie?bts", "gibt's");
        GermanSpellerRule.put("vs", "vs.");
        GermanSpellerRule.put("[kK]affeeteria", "Cafeteria");
        GermanSpellerRule.put("[kK]affeeterien", "Cafeterien");
        GermanSpellerRule.put("ber\u00fccksicht", "ber\u00fccksichtigt");
        GermanSpellerRule.put("must", "musst");
        GermanSpellerRule.put("kaffe", "Kaffee");
        GermanSpellerRule.put("zetel", "Zettel");
        GermanSpellerRule.put("wie?daholung", "Wiederholung");
        GermanSpellerRule.put("vie?d(er|a)sehen", "wiedersehen");
        GermanSpellerRule.put("pr[e\u00e4]ventiert", "verhindert");
        GermanSpellerRule.put("pr[e\u00e4]ventieren", "verhindern");
        GermanSpellerRule.put("zur?verf\u00fcgung", "zur Verf\u00fcgung");
        GermanSpellerRule.put("Verwahrlosigkeit", "Verwahrlosung");
        GermanSpellerRule.put("[oO]r?ganisazion", "Organisation");
        GermanSpellerRule.put("[oO]rganisative", "Organisation");
        GermanSpellerRule.put("Emall?iearbeit", "Emaillearbeit");
        GermanSpellerRule.put("[aA]petitt", "Appetit");
        GermanSpellerRule.put("bezuggenommen", "Bezug genommen");
        GermanSpellerRule.put("m\u00e4gt", "m\u00f6gt");
        GermanSpellerRule.put("frug", "fragte");
        GermanSpellerRule.put("ges\u00e4ht", "ges\u00e4t");
        GermanSpellerRule.put("verennt", "verrennt");
        GermanSpellerRule.put("\u00fcberrant", "\u00fcberrannt");
        GermanSpellerRule.put("Gallop", "Galopp");
        GermanSpellerRule.put("Stop", "Stopp");
        GermanSpellerRule.put("Schertz", "Scherz");
        GermanSpellerRule.put("geschied", "geschieht");
        GermanSpellerRule.put("Aku", "Akku");
        GermanSpellerRule.put("Migrationspackt", "Migrationspakt");
        GermanSpellerRule.put("[zZ]ulaufror", "Zulaufrohr");
        GermanSpellerRule.put("[gG]ebrauchss?puhren", "Gebrauchsspuren");
        GermanSpellerRule.put("[pP]reisnachlassung", "Preisnachlass");
        GermanSpellerRule.put("[mM]edikamentation", "Medikation");
        GermanSpellerRule.put("[nN][ei]gliche", "Neglig\u00e9");
        GermanSpellerRule.put("palletten?", (String w) -> Arrays.asList(w.replaceFirst("pall", "Pal"), w.replaceFirst("pa", "Pai")));
        GermanSpellerRule.put("[pP]allete", "Palette");
        GermanSpellerRule.put("Ger\u00e4uch", (String w) -> Arrays.asList("Ger\u00e4usch", "Gestr\u00e4uch"));
        GermanSpellerRule.put("[sS]chull?igung", "Entschuldigung");
        GermanSpellerRule.put("Geerte", "geehrte");
        GermanSpellerRule.put("versichen", "versichern");
        GermanSpellerRule.put("hobb?ies", "Hobbys");
        GermanSpellerRule.put("Begierigkeiten", "Begehrlichkeiten");
        GermanSpellerRule.put("selblosigkeit", "Selbstlosigkeit");
        GermanSpellerRule.put("gestyled", "gestylt");
        GermanSpellerRule.put("umstimigkeiten", "Unstimmigkeiten");
        GermanSpellerRule.put("unann?\u00e4h?ml?ichkeiten", "Unannehmlichkeiten");
        GermanSpellerRule.put("unn?ann?ehmichkeiten", "Unannehmlichkeiten");
        GermanSpellerRule.put("\u00fcbertr[\u00e4a]gte", "\u00fcbertrug");
        GermanSpellerRule.put("\u00fcbertr[\u00e4a]gten", "\u00fcbertrugen");
        GermanSpellerRule.put("NodeJS", "Node.js");
        GermanSpellerRule.put("erlas", "Erlass");
        GermanSpellerRule.put("schlagte", "schlug");
        GermanSpellerRule.put("schlagten", "schlugen");
        GermanSpellerRule.put("\u00fcberwissen", "\u00fcberwiesen");
        GermanSpellerRule.put("einpar", "ein paar");
        GermanSpellerRule.put("sreiben", "schreiben");
        GermanSpellerRule.put("routiene", "Routine");
        GermanSpellerRule.put("ect", "etc");
        GermanSpellerRule.put("giept", "gibt");
        GermanSpellerRule.put("Pann?acott?a", "Panna cotta");
        GermanSpellerRule.put("Fu\u00dfg\u00e4ngerunterwegs?", "Fu\u00dfg\u00e4ngerunterf\u00fchrung");
        GermanSpellerRule.put("angeschriehen", "angeschrien");
        GermanSpellerRule.put("vieviel", "wie viel");
        GermanSpellerRule.put("ent\u00e4scht", "entt\u00e4uscht");
        GermanSpellerRule.put("R\u00e4mchen", "R\u00e4hmchen");
        GermanSpellerRule.put("Seminarbeit", "Seminararbeit");
        GermanSpellerRule.put("Seminarbeiten", "Seminararbeiten");
        GermanSpellerRule.put("[eE]ngangment", "Engagement");
        GermanSpellerRule.put("[lL]eichtah?tleh?t", "Leichtathlet");
        GermanSpellerRule.put("[pP]fane", "Pfanne");
        GermanSpellerRule.put("[iI]ngini?eue?r", "Ingenieur");
        GermanSpellerRule.put("[aA]nligen", "Anliegen");
        GermanSpellerRule.put("Tankungen", (String w) -> Arrays.asList("Betankungen", "Tankvorg\u00e4nge"));
        GermanSpellerRule.put("\u00c4rcker", (String w) -> Arrays.asList("Erker", "\u00c4rger"));
        GermanSpellerRule.put("\u00fcberlasstet", (String w) -> Arrays.asList("\u00fcberlastet", "\u00fcberlie\u00dft"));
        GermanSpellerRule.put("zeren", (String w) -> Arrays.asList("zerren", "zehren"));
        GermanSpellerRule.put("H\u00e4nchen", (String w) -> Arrays.asList("H\u00e4hnchen", "H\u00e4nschen"));
        GermanSpellerRule.put("[sS]itwazion", "Situation");
        GermanSpellerRule.put("geschriehen", "geschrien");
        GermanSpellerRule.put("beratete", "beriet");
        GermanSpellerRule.put("H\u00e4lst", "H\u00e4ltst");
        GermanSpellerRule.put("[kK]aos", "Chaos");
        GermanSpellerRule.put("[pP]upat\u00e4t", "Pubert\u00e4t");
        GermanSpellerRule.put("\u00fcberwendet", "\u00fcberwindet");
        GermanSpellerRule.put("[bB]esichtung", "Besichtigung");
        GermanSpellerRule.put("[hH]ell?owi[eh]?n", "Halloween");
        GermanSpellerRule.put("geschmelt?zt", "geschmolzen");
        GermanSpellerRule.put("gewunschen", "gew\u00fcnscht");
        GermanSpellerRule.put("bittete", "bat");
        GermanSpellerRule.put("nehm", "nimm");
        GermanSpellerRule.put("m\u00f6chst", "m\u00f6chtest");
        GermanSpellerRule.put("Win", "Windows");
        GermanSpellerRule.put("anschein[dt]", "anscheinend");
        GermanSpellerRule.put("Subvestitionen", "Subventionen");
        GermanSpellerRule.put("angeschaffen", "angeschafft");
        GermanSpellerRule.put("Rechtspruch", "Rechtsspruch");
        GermanSpellerRule.put("Second-Hand", "Secondhand");
        GermanSpellerRule.put("[jJ]ahundert", "Jahrhundert");
        GermanSpellerRule.put("Gesochse", "Gesocks");
        GermanSpellerRule.put("Vorraus", "Voraus");
        GermanSpellerRule.put("[vV]orgensweise", "Vorgehensweise");
        GermanSpellerRule.put("[kK]autsch", "Couch");
        GermanSpellerRule.put("guterletzt", "guter Letzt");
        GermanSpellerRule.put("Wi[Ff]i-Router", "Wi-Fi-Router");
        GermanSpellerRule.putRepl("[Ll]ilane[srm]?", "ilane[srm]?", "ila");
        GermanSpellerRule.putRepl("[zZ]uguterletzt", "guterletzt", " guter Letzt");
        GermanSpellerRule.putRepl("Nootbooks?", "Noot", "Note");
        GermanSpellerRule.putRepl("[vV]ersendlich(e[mnrs]?)?", "send", "sehent");
        GermanSpellerRule.putRepl("[uU]nf\u00e4h?r(e[mnrs]?)?", "f\u00e4h?r", "fair");
        GermanSpellerRule.putRepl("[mM]edikat\u00f6s(e[mnrs]?)?", "ka", "kamen");
        GermanSpellerRule.putRepl("(ein|zwei|drei|vier|f\u00fcnf|sechs|sieben|acht|neun|zehn|elf|zw\u00f6lf)undhalb", "und", "ein");
        GermanSpellerRule.putRepl("[gG]ro\u00dfz\u00fcge[mnrs]?", "z\u00fcg", "z\u00fcgig");
        GermanSpellerRule.putRepl("[\u00e4\u00c4]rtlich(e[mnrs]?)?", "rt", "rzt");
        GermanSpellerRule.putRepl("[sS]chnelligkeitsfehler[ns]?", "[sS]chnell", "Fl\u00fccht");
        GermanSpellerRule.putRepl("[sS]chweinerosane[mnrs]?", "weinerosane[mnrs]?", "weinchenrosa");
        GermanSpellerRule.putRepl("[aA]nstecklich(e[mnrs]?)?", "lich", "end");
        GermanSpellerRule.putRepl("[gG]eflechtet(e[mnrs]?)?", "flechtet", "flochten");
        GermanSpellerRule.putRepl("[gG]enrealistisch(e[mnrs]?)?", "re", "er");
        GermanSpellerRule.putRepl("\u00fcbertr\u00e4gt(e[mnrs]?)?", "^\u00fcbertr\u00e4gt", "\u00fcbertragen");
        GermanSpellerRule.putRepl("[iI]nterresent(e[mnrs]?)?", "rresent", "ressant");
        GermanSpellerRule.putRepl("Simkartenleser[ns]?", "^Simkartenl", "SIM-Karten-L");
        GermanSpellerRule.putRepl("Hilfstmittel[ns]?", "^Hilfst", "Hilfs");
        GermanSpellerRule.putRepl("trationell(e[mnrs]?)?", "^tra", "tradi");
        GermanSpellerRule.putRepl("[bB]erreichs?", "^[bB]er", "Be");
        GermanSpellerRule.putRepl("[fF]uscher[ns]?", "^[fF]u", "Pfu");
        GermanSpellerRule.putRepl("[uU]nausweichbar(e[mnrs]?)?", "bar", "lich");
        GermanSpellerRule.putRepl("[uU]nabdinglich(e[mnrs]?)?", "lich", "bar");
        GermanSpellerRule.putRepl("[eE]ing\u00e4nglich(e[mnrs]?)?", "lich", "ig");
        GermanSpellerRule.putRepl("ausgew\u00f6h?nlich(e[mnrs]?)?", "^ausgew\u00f6h?n", "au\u00dfergew\u00f6hn");
        GermanSpellerRule.putRepl("achsial(e[mnrs]?)?", "^achs", "ax");
        GermanSpellerRule.putRepl("famielen?", "^famiel", "Famili");
        GermanSpellerRule.putRepl("miter[ns]?", "^mi", "Mie");
        GermanSpellerRule.putRepl("besig(t(e[mnrs]?)?|en?)", "sig", "sieg");
        GermanSpellerRule.putRepl("[vV]erziehr(t(e[mnrs]?)?|en?)", "ieh", "ie");
        GermanSpellerRule.putRepl("^[pP]iek(s?t|en?)", "iek", "ik");
        GermanSpellerRule.putRepl("[mM]atschscheiben?", "[mM]atschsch", "Mattsch");
        GermanSpellerRule.put("schafen?", (String w) -> Arrays.asList(w.replaceFirst("sch", "schl"), w.replaceFirst("af", "arf"), w.replaceFirst("af", "aff")));
        GermanSpellerRule.put("zuschafen", "zu schaffen");
        GermanSpellerRule.putRepl("[hH]ofen?", "of", "off");
        GermanSpellerRule.putRepl("[sS]ommerverien?", "[sS]ommerverien?", "Sommerferien");
        GermanSpellerRule.putRepl("[rR]ecourcen?", "[rR]ec", "Ress");
        GermanSpellerRule.putRepl("[fF]amm?ill?i?[a\u00e4]risch(e[mnrs]?)?", "amm?ill?i?[a\u00e4]risch", "amili\u00e4r");
        GermanSpellerRule.putRepl("Sim-Karten?", "^Sim", "SIM");
        GermanSpellerRule.putRepl("Spax-Schrauben?", "^Spax", "SPAX");
        GermanSpellerRule.putRepl("[aA]leine", "l", "ll");
        GermanSpellerRule.putRepl("Kaput", "t", "tt");
        GermanSpellerRule.putRepl("[fF]estell(s?t|en?)", "est", "estst");
        GermanSpellerRule.putRepl("[Ee]igtl", "igtl", "igtl.");
        GermanSpellerRule.putRepl("(Baden-)?W\u00fcrtenbergs?", "W\u00fcrten", "W\u00fcrttem");
        GermanSpellerRule.putRepl("Betriebsratzimmer[ns]?", "rat", "rats");
        GermanSpellerRule.putRepl("Rechts?schreibungsfehler[ns]?", "Rechts?schreibungs", "Rechtschreib");
        GermanSpellerRule.putRepl("Open[aA]ir-Konzert(en?)?", "Open[aA]ir", "Open-Air");
        GermanSpellerRule.putRepl("Jugenschuhen?", "Jug", "Jung");
        GermanSpellerRule.putRepl("TODO-Listen?", "TODO", "To-do");
        GermanSpellerRule.putRepl("ausiehs?t", "aus", "auss");
        GermanSpellerRule.putRepl("unterbemittel(nd|t)(e[nmrs]?)?", "unterbemittel(nd|t)", "minderbemittelt");
        GermanSpellerRule.putRepl("[xX]te[mnrs]?", "te", "-te");
        GermanSpellerRule.putRepl("verheielt(e[mnrs]?)?", "heiel", "heil");
        GermanSpellerRule.putRepl("[rR]evolutionie?sier(s?t|en?)", "ie?s", "");
        GermanSpellerRule.putRepl("Kohleaustiegs?", "aus", "auss");
        GermanSpellerRule.putRepl("[jJ]urististisch(e[mnrs]?)?", "istist", "ist");
        GermanSpellerRule.putRepl("geh\u00e4ckelt(e[nmrs]?)?", "ck", "k");
        GermanSpellerRule.putRepl("deutsprachig(e[nmrs]?)?", "deut", "deutsch");
        GermanSpellerRule.putRepl("angesehend(st)?e[nmrs]?", "end", "en");
        GermanSpellerRule.putRepl("[iI]slamophobisch(e[mnrs]?)?", "isch", "");
        GermanSpellerRule.putRepl("[vV]erharkt(e[mnrs]?)?", "ar", "a");
        GermanSpellerRule.putRepl("[dD]es\u00f6fterer?[nm]", "\u00f6fterer?[nm]", " \u00d6fteren");
        GermanSpellerRule.putRepl("[dD]eswei[dt]ere?[mn]", "wei[dt]ere?[mn]", " Weiteren");
        GermanSpellerRule.putRepl("Einkaufstachen?", "ch", "sch");
        GermanSpellerRule.putRepl("Bortmesser[ns]?", "Bor", "Bro");
        GermanSpellerRule.putRepl("Makeupstylist(in(nen)?|en)?", "Makeups", "Make-up-S");
        GermanSpellerRule.putRepl("Fee?db\u00e4cks?", "Fee?db\u00e4ck", "Feedback");
        GermanSpellerRule.putRepl("weirete[nmrs]?", "ret", "ter");
        GermanSpellerRule.putRepl("Ni[vw]oschalter[ns]?", "Ni[vw]o", "Niveau");
        GermanSpellerRule.putRepl("[eE]xhibitionisch(e[nmrs]?)?", "isch", "istisch");
        GermanSpellerRule.putRepl("(ein|aus)?[gG]eschalten(e[nmrs]?)?", "ten", "tet");
        GermanSpellerRule.putRepl("[uU]nterschiebene[nmrs]?", "sch", "schr");
        GermanSpellerRule.putRepl("[uU]nbequemlich(st)?e[nmrs]?", "lich", "");
        GermanSpellerRule.putRepl("[uU][nm]bekweh?m(e[nmrs]?)?", "[nm]bekweh?m", "nbequem");
        GermanSpellerRule.putRepl("[dD]esat\u00f6r(s|en?)?", "sat\u00f6r", "serteur");
        GermanSpellerRule.put("Panelen?", (String w) -> Arrays.asList(w.replaceFirst("Panel", "Paneel"), "Panels"));
        GermanSpellerRule.put("D[e\u00e8\u00e9]ja-?[vV]o?ue?", "D\u00e9j\u00e0-vu");
        GermanSpellerRule.put("Cr[e\u00e8\u00e9]me-?fra[i\u00ee]che", "Cr\u00e8me fra\u00eeche");
        GermanSpellerRule.put("[aA]rr?an?gemont", "Arrangement");
        GermanSpellerRule.put("[aA]ngagemon", "Engagement");
        GermanSpellerRule.put("Phyrr?ussieg", "Pyrrhussieg");
        GermanSpellerRule.put("Mio", "Mio.");
        GermanSpellerRule.put("Datein", "Dateien");
        GermanSpellerRule.put("[pP]u(zz|ss)el", "Puzzle");
        GermanSpellerRule.put("Smilies", "Smileys");
        GermanSpellerRule.put("[dD]iseing?", "Design");
        GermanSpellerRule.put("[lL]ieradd?ress?e", "Lieferadresse");
        GermanSpellerRule.put("[bB]o[yi]kutierung", "Boykottierung");
        GermanSpellerRule.put("Mouseclick", "Mausklick");
        GermanSpellerRule.put("[aA]ktuelli?esie?rung", "Aktualisierung");
        GermanSpellerRule.put("H\u00e4ndy", "Handy");
        GermanSpellerRule.put("gewertsch\u00e4tzt", "wertgesch\u00e4tzt");
        GermanSpellerRule.put("tieger", "Tiger");
        GermanSpellerRule.put("Rollade", (String w) -> Arrays.asList("Rollladen", "Roulade"));
        GermanSpellerRule.put("garnichtmehr", "gar nicht mehr");
        GermanSpellerRule.put("vileich", "vielleicht");
        GermanSpellerRule.put("vll?t", "vielleicht");
        GermanSpellerRule.put("aufgew\u00e4gt", "aufgewogen");
        GermanSpellerRule.put("[rR]eflektion", "Reflexion");
        GermanSpellerRule.put("momentmal", "Moment mal");
        GermanSpellerRule.put("satzt", "Satz");
        GermanSpellerRule.put("B\u00fcff?(ee|\u00e9)", (String w) -> Arrays.asList("Buffet", "B\u00fcfett"));
        GermanSpellerRule.put("[fF]r\u00fchst\u00fccksb[u\u00fc]ff?(\u00e9|ee)", "Fr\u00fchst\u00fccksbuffet");
        GermanSpellerRule.put("[aA]lterego", "Alter Ego");
        GermanSpellerRule.put("Copyride", "Copyright");
        GermanSpellerRule.put("Analysierung", "Analyse");
        GermanSpellerRule.put("Exel", "Excel");
        GermanSpellerRule.put("Gl\u00fccklichkeit", "Gl\u00fcck");
        GermanSpellerRule.put("Begierigkeit", "Begierde");
        GermanSpellerRule.put("voralem", "vor allem");
        GermanSpellerRule.put("Unorganisation", (String w) -> Arrays.asList("Desorganisation", "Unorganisiertheit"));
        GermanSpellerRule.put("Cand(el|le)lightdinner", "Candle-Light-Dinner");
        GermanSpellerRule.put("wertgelegt", "Wert gelegt");
        GermanSpellerRule.put("Deluxe", "de luxe");
        GermanSpellerRule.put("antuhen", "antun");
        GermanSpellerRule.put("komen", "kommen");
        GermanSpellerRule.put("geni\u00dfen", "genie\u00dfen");
        GermanSpellerRule.put("Stationskrankenpflegerin", "Stationsschwester");
        GermanSpellerRule.put("[iI\u00fc\u00dcuU]b[ea]w[ae]isung", "\u00dcberweisung");
        GermanSpellerRule.put("[bB]oxhorn", "Bockshorn");
        GermanSpellerRule.put("[zZ]oolophie", "Zoophilie");
        GermanSpellerRule.put("Makieren", "Markieren");
        GermanSpellerRule.put("Altersheimer", "Alzheimer");
        GermanSpellerRule.put("gesen", "gesehen");
        GermanSpellerRule.put("Neugierigkeit", (String w) -> Arrays.asList("Neugier", "Neugierde"));
        GermanSpellerRule.put("[kK]onn?ekt?schen", "Connection");
        GermanSpellerRule.put("E-Maul", "E-Mail");
        GermanSpellerRule.put("E-Mauls", "E-Mails");
        GermanSpellerRule.put("E-Mal", "E-Mail");
        GermanSpellerRule.put("E-Mals", "E-Mails");
        GermanSpellerRule.put("[nN]ah?richt", "Nachricht");
        GermanSpellerRule.put("[nN]ah?richten", "Nachrichten");
        GermanSpellerRule.put("Getrixe", "Getrickse");
        GermanSpellerRule.put("Ausage", "Aussage");
        GermanSpellerRule.put("gelessen", "gelesen");
        GermanSpellerRule.put("Kanst", "Kannst");
        GermanSpellerRule.put("Unwohlbefinden", "Unwohlsein");
        GermanSpellerRule.put("leiwagen", "Leihwagen");
        GermanSpellerRule.put("krahn", "Kran");
        GermanSpellerRule.put("[hH]ifi", "Hi-Fi");
        GermanSpellerRule.put("chouch", "Couch");
        GermanSpellerRule.put("eh?rgeit?z", "Ehrgeiz");
        GermanSpellerRule.put("solltes", "solltest");
        GermanSpellerRule.put("geklabt", "geklappt");
        GermanSpellerRule.put("angefangt", "angefangen");
        GermanSpellerRule.put("beinh\u00e4lt", "beinhaltet");
        GermanSpellerRule.put("beinhielt", "beinhaltete");
        GermanSpellerRule.put("beinhielten", "beinhalteten");
        GermanSpellerRule.put("einhaltest", "einh\u00e4ltst");
        GermanSpellerRule.put("angeruft", "angerufen");
        GermanSpellerRule.put("erhaltete", "erhielt");
        GermanSpellerRule.put("\u00fcbers\u00e4ht", "\u00fcbers\u00e4t");
        GermanSpellerRule.put("staats?angehoe?rigkeit", "Staatsangeh\u00f6rigkeit");
        GermanSpellerRule.put("[uU]nangeneh?mheiten", "Unannehmlichkeiten");
        GermanSpellerRule.put("Humuspaste", "Hummuspaste");
        GermanSpellerRule.put("afarung", "Erfahrung");
        GermanSpellerRule.put("bescheid?t", "Bescheid");
        GermanSpellerRule.put("[mM]iteillung", "Mitteilung");
        GermanSpellerRule.put("Revisionierung", "Revision");
        GermanSpellerRule.put("[eE]inf\u00fchlverm\u00f6gen", "Einf\u00fchlungsverm\u00f6gen");
        GermanSpellerRule.put("[sS]peziellisierung", "Spezialisierung");
        GermanSpellerRule.put("[cC]hangse", "Chance");
        GermanSpellerRule.put("untergangen", "untergegangen");
        GermanSpellerRule.put("geliegt", "gelegen");
        GermanSpellerRule.put("BluRay", "Blu-ray");
        GermanSpellerRule.put("Freiwilligerin", "Freiwillige");
        GermanSpellerRule.put("Mitgliederinnen", (String w) -> Arrays.asList("Mitglieder", "Mitgliedern"));
        GermanSpellerRule.put("Hautreinheiten", "Hautunreinheiten");
        GermanSpellerRule.put("Durf\u00fch?rung", "Durchf\u00fchrung");
        GermanSpellerRule.put("tuhen", "tun");
        GermanSpellerRule.put("tuhe", "tue");
        GermanSpellerRule.put("tip", "Tipp");
        GermanSpellerRule.put("ccm", "cm\u00b3");
        GermanSpellerRule.put("Kilimand?jaro", "Kilimandscharo");
        GermanSpellerRule.put("[hH]erausfor?dung", "Herausforderung");
        GermanSpellerRule.put("[bB]er\u00fccksichtung", "Ber\u00fccksichtigung");
        GermanSpellerRule.put("artzt?", "Arzt");
        GermanSpellerRule.put("[tT]h?elepath?ie", "Telepathie");
        GermanSpellerRule.put("Wi-?Fi-Dire[ck]t", "Wi-Fi Direct");
        GermanSpellerRule.put("gans", "ganz");
        GermanSpellerRule.put("Pearl-Harbou?r", "Pearl Harbor");
        GermanSpellerRule.put("[aA]utonomit\u00e4t", "Autonomie");
        GermanSpellerRule.put("[fF]r[u\u00fc]h?st[u\u00fc]c?k", "Fr\u00fchst\u00fcck");
        GermanSpellerRule.putRepl("(ge)?fr[u\u00fc]h?st[u\u00fc](c?k|g)t", "fr[u\u00fc]h?st[u\u00fc](c?k|g)t", "fr\u00fchst\u00fcckt");
        GermanSpellerRule.put("zucc?h?inis?", "Zucchini");
        GermanSpellerRule.put("[mM]itag", "Mittag");
        GermanSpellerRule.put("Lexion", "Lexikon");
        GermanSpellerRule.put("[mM]otorisation", "Motorisierung");
        GermanSpellerRule.put("[fF]ormalisation", "Formalisierung");
        GermanSpellerRule.put("ausprache", "Aussprache");
        GermanSpellerRule.put("[mM]enegment", "Management");
        GermanSpellerRule.put("[gG]ebrauspuren", "Gebrauchsspuren");
        GermanSpellerRule.put("viedeo", "Video");
        GermanSpellerRule.put("[hH]erstammung", "Abstammung");
        GermanSpellerRule.put("[iI]nstall?at\u00f6r", "Installateur");
        GermanSpellerRule.put("maletriert", "maltr\u00e4tiert");
        GermanSpellerRule.put("abgeschaffen", "abgeschafft");
        GermanSpellerRule.put("Verschiden", "Verschieden");
        GermanSpellerRule.put("Anschovis", "Anchovis");
        GermanSpellerRule.put("Bravur", "Bravour");
        GermanSpellerRule.put("Grisli", "Grizzly");
        GermanSpellerRule.put("Grislib\u00e4r", "Grizzlyb\u00e4r");
        GermanSpellerRule.put("Grislib\u00e4ren", "Grizzlyb\u00e4ren");
        GermanSpellerRule.put("Frott\u00e9", "Frottee");
        GermanSpellerRule.put("Joga", "Yoga");
        GermanSpellerRule.put("Kalvinismus", "Calvinismus");
        GermanSpellerRule.put("Kollier", "Collier");
        GermanSpellerRule.put("Kolliers", "Colliers");
        GermanSpellerRule.put("Ketschup", "Ketchup");
        GermanSpellerRule.put("Kommunikee", "Kommuniqu\u00e9");
        GermanSpellerRule.put("Negligee", "Neglig\u00e9");
        GermanSpellerRule.put("Nessess\u00e4r", "Necessaire");
        GermanSpellerRule.put("passee", "pass\u00e9");
        GermanSpellerRule.put("Varietee", "Variet\u00e9");
        GermanSpellerRule.put("Varietees", "Variet\u00e9s");
        GermanSpellerRule.put("Wandalismus", "Vandalismus");
        GermanSpellerRule.put("Campagne", "Kampagne");
        GermanSpellerRule.put("Campagnen", "Kampagnen");
        GermanSpellerRule.put("Jockei", "Jockey");
        GermanSpellerRule.put("Roulett", "Roulette");
        GermanSpellerRule.put("Bestellungsdaten", "Bestelldaten");
        GermanSpellerRule.put("Mo-Di", "Mo.\u2013Di.");
        GermanSpellerRule.put("Mo-Mi", "Mo.\u2013Mi.");
        GermanSpellerRule.put("Mo-Do", "Mo.\u2013Do.");
        GermanSpellerRule.put("Mo-Fr", "Mo.\u2013Fr.");
        GermanSpellerRule.put("Mo-Sa", "Mo.\u2013Sa.");
        GermanSpellerRule.put("Mo-So", "Mo.\u2013So.");
        GermanSpellerRule.put("Di-Mi", "Di.\u2013Mi.");
        GermanSpellerRule.put("Di-Do", "Di.\u2013Do.");
        GermanSpellerRule.put("Di-Fr", "Di.\u2013Fr.");
        GermanSpellerRule.put("Di-Sa", "Di.\u2013Sa.");
        GermanSpellerRule.put("Di-So", "Di.\u2013So.");
        GermanSpellerRule.put("Mi-Do", "Mi.\u2013Do.");
        GermanSpellerRule.put("Mi-Fr", "Mi.\u2013Fr.");
        GermanSpellerRule.put("Mi-Sa", "Mi.\u2013Sa.");
        GermanSpellerRule.put("Mi-So", "Mi.\u2013So.");
        GermanSpellerRule.put("Do-Fr", "Do.\u2013Fr.");
        GermanSpellerRule.put("Do-Sa", "Do.\u2013Sa.");
        GermanSpellerRule.put("Do-So", "Do.\u2013So.");
        GermanSpellerRule.put("Fr-Sa", "Fr.\u2013Sa.");
        GermanSpellerRule.put("Fr-So", "Fr.\u2013So.");
        GermanSpellerRule.put("Sa-So", "Sa.\u2013So.");
        GermanSpellerRule.put("E-mail", "E-Mail");
        GermanSpellerRule.put("geleased", "geleast");
        GermanSpellerRule.put("released", "releast");
        GermanSpellerRule.putRepl("Saudiarabiens?", "Saudiarabien", "Saudi-Arabien");
        GermanSpellerRule.putRepl("eMail-Adressen?", "eMail-", "E-Mail-");
        GermanSpellerRule.putRepl("[hH]ats", "ats", "at es");
        GermanSpellerRule.putRepl("[Ww]ieviele?", "ieviel", "ie viel");
        GermanSpellerRule.putRepl("[Aa]dhoc", "dhoc", "d hoc");
        GermanSpellerRule.put("As", "Ass");
        GermanSpellerRule.put("[bB]i[s\u00df](s?[ij]|ch)en", "bisschen");
        GermanSpellerRule.putRepl("Todos?", "Todo", "To-do");
        GermanSpellerRule.put("Kovult", "Konvolut");
        GermanSpellerRule.putRepl("blog(t?en?|t(es?t)?)$", "g", "gg");
        GermanSpellerRule.put("Zombiefizierungen", "Zombifizierungen");
        GermanSpellerRule.put("H\u00fchne", (String w) -> Arrays.asList("B\u00fchne", "H\u00fcne", "H\u00fchner"));
        GermanSpellerRule.put("H\u00fchnen", (String w) -> Arrays.asList("B\u00fchnen", "H\u00fcnen", "H\u00fchnern"));
        GermanSpellerRule.put("tiptop", "tiptopp");
        GermanSpellerRule.put("Briese", "Brise");
        GermanSpellerRule.put("Rechtsschreibreformen", "Rechtschreibreformen");
        GermanSpellerRule.putRepl("gewertsch\u00e4tzte(([mnrs]|re[mnrs]?)?)$", "gewertsch\u00e4tzt", "wertgesch\u00e4tzt");
        GermanSpellerRule.putRepl("knapps(t?en?|t(es?t)?)$", "pp", "p");
        GermanSpellerRule.put("geknappst", "geknapst");
        GermanSpellerRule.putRepl("gepiekste[mnrs]?$", "ie", "i");
        GermanSpellerRule.putRepl("Yings?", "ng", "n");
        GermanSpellerRule.put("Wiederstandes", "Widerstandes");
        GermanSpellerRule.putRepl("veganisch(e?[mnrs]?)$", "isch", "");
        GermanSpellerRule.putRepl("totlangweiligste[mnrs]?$", "tot", "tod");
        GermanSpellerRule.putRepl("tottraurigste[mnrs]?$", "tot", "tod");
        GermanSpellerRule.putRepl("kreir(n|e?nd)(e[mnrs]?)?$", "ire?n", "ieren");
        GermanSpellerRule.putRepl("Pepps?", "pp", "p");
        GermanSpellerRule.putRepl("Pariahs?", "h", "");
        GermanSpellerRule.putRepl("Oeuvres?", "Oe", "\u0152");
        GermanSpellerRule.put("Margarite", "Margerite");
        GermanSpellerRule.put("K\u00fccken", (String w) -> Arrays.asList("R\u00fccken", "K\u00fcken"));
        GermanSpellerRule.put("Kompanten", (String w) -> Arrays.asList("Kompasse", "Kompassen"));
        GermanSpellerRule.put("Kandarren", "Kandaren");
        GermanSpellerRule.put("kniehen", "knien");
        GermanSpellerRule.putRepl("infisziertes?t$", "fisz", "fiz");
        GermanSpellerRule.putRepl("Imbusse(n|s)?$", "m", "n");
        GermanSpellerRule.put("Hollundern", "Holundern");
        GermanSpellerRule.putRepl("handgehabt(e?[mnrs]?)?$", "handgehabt", "gehandhabt");
        GermanSpellerRule.put("Funieres", "Furniers");
        GermanSpellerRule.put("Frohndiensts", "Frondiensts");
        GermanSpellerRule.put("fith\u00e4lst", "fit h\u00e4ltst");
        GermanSpellerRule.putRepl("fitzuhalten(de?[mnrs]?)?$", "fitzuhalten", "fit zu halten");
        GermanSpellerRule.putRepl("(essen|schlafen|schwimmen|spazieren)zugehen$", "zugehen", " zu gehen");
        GermanSpellerRule.put("dilettant", (String w) -> Arrays.asList("Dilettant", "dilettantisch"));
        GermanSpellerRule.putRepl("dilettante[mnrs]?$", "te", "tische");
        GermanSpellerRule.put("Disastern", "Desastern");
        GermanSpellerRule.putRepl("Brandwein(en?|s)$", "d", "nt");
        GermanSpellerRule.putRepl("B\u00f6hen?$", "h", "");
        GermanSpellerRule.putRepl("Aufst\u00e4ndige[mnr]?$", "ig", "isch");
        GermanSpellerRule.putRepl("aufst\u00e4ndig(e[mnrs]?)?$", "ig", "isch");
        GermanSpellerRule.put("aufgrundedessen", "aufgrund dessen");
        GermanSpellerRule.put("Amalgane", "Amalgame");
        GermanSpellerRule.put("Kafe", (String w) -> Arrays.asList("Kaffee", "Caf\u00e9"));
        GermanSpellerRule.put("Dammbock", (String w) -> Arrays.asList("Dambock", "Rammbock"));
        GermanSpellerRule.put("Dammhirsch", "Damhirsch");
        GermanSpellerRule.put("Fairnis", "Fairness");
        GermanSpellerRule.put("auschluss", (String w) -> Arrays.asList("Ausschluss", "Ausschuss"));
        GermanSpellerRule.put("derikter", (String w) -> Arrays.asList("direkter", "Direktor"));
        GermanSpellerRule.put("[iI]dentifierung", "Identifikation");
        GermanSpellerRule.put("[eE]mphatie", "Empathie");
        GermanSpellerRule.put("[eE]iskrem", "Eiscreme");
        GermanSpellerRule.put("[fF]l\u00fcchtung", "Flucht");
        GermanSpellerRule.put("einamen", "Einnahmen");
        GermanSpellerRule.put("[eE]inbu(ss|\u00df)ung", "Einbu\u00dfe");
        GermanSpellerRule.put("[eE]inbu(ss|\u00df)ungen", "Einbu\u00dfen");
        GermanSpellerRule.put("nachichten", "Nachrichten");
        GermanSpellerRule.put("gegehen", "gegangen");
        GermanSpellerRule.put("Ethnocid", "Ethnozid");
        GermanSpellerRule.put("Exikose", "Exsikkose");
        GermanSpellerRule.put("Schonverm\u00f6gengrenze", "Schonverm\u00f6gensgrenze");
        GermanSpellerRule.put("kontest", "konntest");
        GermanSpellerRule.put("pitza", "Pizza");
        GermanSpellerRule.put("T\u00fct\u00fc", "Tutu");
        GermanSpellerRule.putRepl("Prokopfverbrauchs?", "Prokopfv", "Pro-Kopf-V");
        GermanSpellerRule.putRepl("[vV]ollrichtung(en)?", "oll", "er");
        GermanSpellerRule.putRepl("[vV]ollrichtest", "oll", "er");
        GermanSpellerRule.putRepl("[vV]ollrichten?", "oll", "er");
        GermanSpellerRule.putRepl("[vV]ollrichtet(e([mnrs])?)?", "oll", "er");
        GermanSpellerRule.putRepl("[bB]edingslos(e([mnrs])?)?", "ding", "dingung");
        GermanSpellerRule.putRepl("[eE]insichtbar(e[mnrs]?)?", "sicht", "seh");
        GermanSpellerRule.putRepl("asymetrisch(ere|ste)[mnrs]?$", "ym", "ymm");
        GermanSpellerRule.putRepl("alterw\u00fcrdig(ere|ste)[mnrs]?$", "lter", "ltehr");
        GermanSpellerRule.putRepl("aufst\u00e4ndig(ere|ste)[mnrs]?$", "ig", "isch");
        GermanSpellerRule.putRepl("blutdurstig(ere|ste)[mnrs]?$", "ur", "\u00fcr");
        GermanSpellerRule.putRepl("dilettant(ere|este)[mnrs]?$", "nt", "ntisch");
        GermanSpellerRule.putRepl("eliptisch(ere|ste)[mnrs]?$", "l", "ll");
        GermanSpellerRule.putRepl("angegr\u00f6hlt(e([mnrs])?)?$", "\u00f6h", "\u00f6");
        GermanSpellerRule.putRepl("gothisch(ere|ste)[mnrs]?$", "th", "t");
        GermanSpellerRule.putRepl("kollossal(ere|ste)[mnrs]?$", "ll", "l");
        GermanSpellerRule.putRepl("paralel(lere|lste)[mnrs]?$", "paralel", "paralle");
        GermanSpellerRule.putRepl("symetrischste[mnrs]?$", "ym", "ymm");
        GermanSpellerRule.putRepl("rethorisch(ere|ste)[mnrs]?$", "rethor", "rhetor");
        GermanSpellerRule.putRepl("repetativ(ere|ste)[mnrs]?$", "repetat", "repetit");
        GermanSpellerRule.putRepl("volupt\u00f6s(e|ere|este)?[mnrs]?$", "t\u00f6s", "tu\u00f6s");
        GermanSpellerRule.putRepl("[pP]flanzig(e[mnrs]?)?", "ig", "lich");
        GermanSpellerRule.putRepl("geblogt(e[mnrs]?)?$", "gt", "ggt");
        GermanSpellerRule.putRepl("herraus.*", "herraus", "heraus");
        GermanSpellerRule.putRepl("[aA]bbonier(en?|s?t|te[mnrst]?)", "bbo", "bon");
        GermanSpellerRule.putRepl("[aA]pelier(en?|s?t|te[nt]?)", "pel", "ppell");
        GermanSpellerRule.putRepl("[vV]oltie?schier(en?|s?t|te[nt]?)", "ie?sch", "ig");
        GermanSpellerRule.putRepl("[mM]eistverkaufteste[mnrs]?", "teste", "te");
        GermanSpellerRule.putRepl("[uU]nleshaft(e[mnrs]?)?", "haft", "erlich");
        GermanSpellerRule.putRepl("[gG]laubensw\u00fcrdig(e[mnrs]?)?", "ens", "");
        GermanSpellerRule.putRepl("[nN]i[vw]ovoll(e[mnrs]?)?", "[vw]ovoll", "veauvoll");
        GermanSpellerRule.putRepl("[nN]otgezwungend?(e[mnrs]?)?", "zwungend?", "drungen");
        GermanSpellerRule.putRepl("[mM]isstraurig(e[mnrs]?)?", "rig", "isch");
        GermanSpellerRule.putRepl("[iI]nflagrantie?", "flagrantie?", " flagranti");
        GermanSpellerRule.putRepl("Aux-Anschl(uss(es)?|\u00fcssen?)", "Aux", "AUX");
        GermanSpellerRule.putRepl("desinfektiert(e[mnrs]?)?", "fekt", "fiz");
        GermanSpellerRule.putRepl("desinfektierend(e[mnrs]?)?", "fekt", "fiz");
        GermanSpellerRule.putRepl("desinfektieren?", "fekt", "fiz");
        GermanSpellerRule.putRepl("ausb\u00fcchsen?", "chs", "x");
        GermanSpellerRule.putRepl("aus(ge)?b\u00fcchst(en?)?", "chs", "x");
        GermanSpellerRule.putRepl("innoff?iziell?(e[mnrs]?)?", "innoff?iziell?", "inoffiziell");
        GermanSpellerRule.putRepl("[gG]roesste[mnrs]?", "oess", "\u00f6\u00df");
        GermanSpellerRule.putRepl("[tT]efonisch(e[mnrs]?)?", "efon", "elefon");
        GermanSpellerRule.putRepl("[oO]ptimalisiert", "alis", "");
        GermanSpellerRule.putRepl("[iI]ntrovertisch(e[mnrs]?)?", "isch", "iert");
        GermanSpellerRule.putRepl("[aA]miert(e[mnrs]?)?", "mi", "rmi");
        GermanSpellerRule.putRepl("[vV]ersiehrt(e[mnrs]?)?", "h", "");
        GermanSpellerRule.putRepl("[dD]urchsichtbar(e[mnrs]?)?", "bar", "ig");
        GermanSpellerRule.putRepl("[oO]ffensichtig(e[mnrs]?)?", "ig", "lich");
        GermanSpellerRule.putRepl("[zZ]urverf\u00fchgung", "verf\u00fchgung", " Verf\u00fcgung");
        GermanSpellerRule.putRepl("[vV]erst\u00e4ndlichkeitsfragen?", "lichkeits", "nis");
        GermanSpellerRule.putRepl("[sS]pendeangebot(e[ns]?)?", "[sS]pende", "Spenden");
        GermanSpellerRule.putRepl("gahrnichts?", "gahr", "gar ");
        GermanSpellerRule.putRepl("[aA]ugensichtlich(e[mnrs]?)?", "sicht", "schein");
        GermanSpellerRule.putRepl("[lL]eidensvoll(e[mnrs]?)?", "ens", "");
        GermanSpellerRule.putRepl("[bB]ewusstlich(e[mnrs]?)?", "lich", "");
        GermanSpellerRule.putRepl("[vV]erschmerzlich(e[mnrs]?)?", "lich", "bar");
        GermanSpellerRule.putRepl("Krankenbruders?", "bruder", "pfleger");
        GermanSpellerRule.putRepl("Krankenbr\u00fcdern?", "br\u00fcder", "pfleger");
        GermanSpellerRule.putRepl("Lan-(Kabel[ns]?|Verbindung)", "Lan", "LAN");
        GermanSpellerRule.putRepl("[sS]epalastschriftmandat(s|en?)?", "[sS]epal", "SEPA-L");
        GermanSpellerRule.putRepl("Pinn?eingaben?", "Pinn?e", "PIN-E");
        GermanSpellerRule.putRepl("[sS]imkarten?", "[sS]imk", "SIM-K");
        GermanSpellerRule.putRepl("[vV]orsich(geht|gehen|ging(en)?|gegangen)", "sich", " sich ");
        GermanSpellerRule.putRepl("mitsich(bringt|bringen|brachten?|gebracht)", "sich", " sich ");
        GermanSpellerRule.putRepl("[ck]arnivorisch(e[mnrs]?)?", "[ck]arnivorisch", "karnivor");
        GermanSpellerRule.putRepl("[pP]erfektest(e[mnrs]?)?", "est", "");
        GermanSpellerRule.putRepl("[gG]leichtig(e[mnrs]?)?", "tig", "zeitig");
        GermanSpellerRule.putRepl("[uU]n(her)?vorgesehen(e[mnrs]?)?", "(her)?vor", "vorher");
        GermanSpellerRule.putRepl("([cC]orona|[gG]rippe)viruss?es", "viruss?es", "virus");
        GermanSpellerRule.putRepl("Zaubererin(nen)?", "er", "");
        GermanSpellerRule.putRepl("Second-Hand-L[\u00e4a]dens?", "Second-Hand-L", "Secondhandl");
        GermanSpellerRule.putRepl("Second-Hand-Shops?", "Second-Hand-S", "Secondhands");
        GermanSpellerRule.putRepl("[mM]editerranisch(e[mnrs]?)?", "isch", "");
        GermanSpellerRule.putRepl("[uU]nterschreibungsf\u00e4hig(e[mnrs]?)?", "schreibung", "schrift");
        GermanSpellerRule.putRepl("[eE]rrorier(en?|t(e[mnrs]?)?|st)", "ror", "u");
        GermanSpellerRule.put("gildet", "gilt");
        GermanSpellerRule.put("gleitete", "glitt");
        GermanSpellerRule.put("gleiteten", "glitten");
        GermanSpellerRule.put("Standbay", "Stand-by");
        GermanSpellerRule.put("[vV]ollkommnung", "Vervollkommnung");
        GermanSpellerRule.put("femist", "vermisst");
        GermanSpellerRule.put("[kK]ostarika", "Costa Rica");
        GermanSpellerRule.put("[kK]ostarikas", "Costa Ricas");
        GermanSpellerRule.put("[aA]uthenzit\u00e4t", "Authentizit\u00e4t");
        GermanSpellerRule.put("anl\u00e4ssig", "anl\u00e4sslich");
        GermanSpellerRule.put("[sS]tieft", "Stift");
        GermanSpellerRule.put("[Ii]nspruchnahme", "Inanspruchnahme");
        GermanSpellerRule.put("h\u00f6stwah?rsch[ea]inlich", "h\u00f6chstwahrscheinlich");
        GermanSpellerRule.put("[aA]lterschbeschr\u00e4nkung", "Altersbeschr\u00e4nkung");
        GermanSpellerRule.put("[kK]unstoff", "Kunststoff");
        GermanSpellerRule.put("[iI]nstergramm?", "Instagram");
        GermanSpellerRule.put("fleicht", "vielleicht");
        GermanSpellerRule.put("[eE]rartens", "Erachtens");
        GermanSpellerRule.put("laufte", "lief");
        GermanSpellerRule.put("lauften", "liefen");
        GermanSpellerRule.put("malzeit", "Mahlzeit");
        GermanSpellerRule.put("[wW]ahts?app", "WhatsApp");
        GermanSpellerRule.put("[wW]elan", (String w) -> Arrays.asList("WLAN", "W-LAN"));
        GermanSpellerRule.put("Pinn", (String w) -> Arrays.asList("Pin", "PIN"));
        GermanSpellerRule.put("Geldmachung", (String w) -> Arrays.asList("Geltendmachung", "Geldmacherei"));
        GermanSpellerRule.put("[uU]nstimm?ichkeiten", "Unstimmigkeiten");
        GermanSpellerRule.put("Teilnehmung", "Teilnahme");
        GermanSpellerRule.put("Teilnehmungen", "Teilnahmen");
        GermanSpellerRule.put("waser", "Wasser");
        GermanSpellerRule.put("Bekennung", "Bekenntnis");
        GermanSpellerRule.put("[hH]irar?chie", "Hierarchie");
        GermanSpellerRule.put("Chr", "Chr.");
        GermanSpellerRule.put("Tiefbaumt", "Tiefbauamt");
        GermanSpellerRule.put("get\u00e4ucht", "get\u00e4uscht");
        GermanSpellerRule.put("[hH]\u00e4hme", "H\u00e4me");
        GermanSpellerRule.put("Wochendruhezeiten", "Wochenendruhezeiten");
        GermanSpellerRule.put("Studiumplatzt?", "Studienplatz");
        GermanSpellerRule.put("Permanent-Make-Up", "Permanent-Make-up");
        GermanSpellerRule.put("woltet", "wolltet");
        GermanSpellerRule.put("B\u00e4ckei", "B\u00e4ckerei");
        GermanSpellerRule.put("B\u00e4ckeien", "B\u00e4ckereien");
        GermanSpellerRule.put("warmweis", "warmwei\u00df");
        GermanSpellerRule.put("kaltweis", "kaltwei\u00df");
        GermanSpellerRule.put("jez", "jetzt");
        GermanSpellerRule.put("hendis", "Handys");
        GermanSpellerRule.put("wie?derwarten", "wider Erwarten");
        GermanSpellerRule.put("[eE]ntercott?e", "Entrec\u00f4te");
        GermanSpellerRule.put("[eE]rwachtung", "Erwartung");
        GermanSpellerRule.put("[aA]nung", "Ahnung");
        GermanSpellerRule.put("[uU]nreimlichkeiten", "Ungereimtheiten");
        GermanSpellerRule.put("[uU]nangeneh?mlichkeiten", "Unannehmlichkeiten");
        GermanSpellerRule.put("Messy", "Messie");
        GermanSpellerRule.put("Polover", "Pullover");
        GermanSpellerRule.put("heilwegs", "halbwegs");
        GermanSpellerRule.put("undsoweiter", "und so weiter");
        GermanSpellerRule.put("Gladbeckerstrasse", "Gladbecker Stra\u00dfe");
        GermanSpellerRule.put("[bB]range", "Branche");
        GermanSpellerRule.put("Gewebtrauma", "Gewebetrauma");
        GermanSpellerRule.put("aufgehangen", "aufgeh\u00e4ngt");
        GermanSpellerRule.put("Ehrenamtpauschale", "Ehrenamtspauschale");
        GermanSpellerRule.put("Essenzubereitung", "Essenszubereitung");
        GermanSpellerRule.put("[gG]eborgsamkeit", "Geborgenheit");
        GermanSpellerRule.put("gekommt", "gekommen");
        GermanSpellerRule.put("hinwei\u00dfen", "hinweisen");
        GermanSpellerRule.put("Importation", "Import");
        GermanSpellerRule.put("l\u00e4dest", "l\u00e4dst");
        GermanSpellerRule.put("Themabereich", "Themenbereich");
        GermanSpellerRule.put("Werksresett", "Werksreset");
        GermanSpellerRule.put("wiederfahren", "widerfahren");
        GermanSpellerRule.put("wiederspiegelten", "widerspiegelten");
        GermanSpellerRule.put("weicheinlich", "wahrscheinlich");
        GermanSpellerRule.put("schn\u00e4pchen", "Schn\u00e4ppchen");
        GermanSpellerRule.put("Hinduist", "Hindu");
        GermanSpellerRule.put("Hinduisten", "Hindus");
        GermanSpellerRule.put("Konzeptierung", "Konzipierung");
        GermanSpellerRule.put("Phyton", "Python");
        GermanSpellerRule.put("nochnichtmals?", "noch nicht einmal");
        GermanSpellerRule.put("Refelektion", "Reflexion");
        GermanSpellerRule.put("Refelektionen", "Reflexionen");
        GermanSpellerRule.put("[sS]chanse", "Chance");
        GermanSpellerRule.put("nich", "nicht");
        GermanSpellerRule.put("wat", "was");
        GermanSpellerRule.put("[Ee][Ss]ports", "E-Sports");
        GermanSpellerRule.put("gerelaunch(ed|t)", "relauncht");
        GermanSpellerRule.put("Gerelaunch(ed|t)", "Relauncht");
        splitter = GermanSpellerRule.getSplitter();
    }

    static class ExpandingReader
    extends BufferedReader {
        private final List<String> buffer = new ArrayList<String>();
        private final LineExpander lineExpander = new LineExpander();

        ExpandingReader(Reader in) {
            super(in);
        }

        @Override
        public String readLine() throws IOException {
            if (this.buffer.isEmpty()) {
                String line = super.readLine();
                if (line == null) {
                    return null;
                }
                this.buffer.addAll(this.lineExpander.expandLine(line));
            }
            return this.buffer.remove(0);
        }
    }
}

