/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.de.SpellingRuleWithSuggestions;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.PatternTokenBuilder;
import org.languagetool.tagging.de.GermanTagger;

class SpellingData {
    private final List<SpellingRuleWithSuggestions> spellingRules = new ArrayList<SpellingRuleWithSuggestions>();

    SpellingData(String ruleDesc, String filePath, String message, String shortMessage, String ruleId, ITSIssueType issueType) {
        this(ruleDesc, filePath, message, shortMessage, ruleId, issueType, false);
    }

    SpellingData(String ruleDesc, String filePath, String message, String shortMessage, String ruleId, ITSIssueType issueType, boolean ignoreAfterQuote) {
        Language german = Languages.getLanguageForShortCode((String)"de");
        List lines = JLanguageTool.getDataBroker().getFromResourceDirAsLines(filePath);
        HashMap<String, String> coherencyMap = new HashMap<String, String>();
        for (String line : lines) {
            if (line.startsWith("#")) continue;
            String[] parts = line.split(";");
            if (parts.length < 2) {
                throw new RuntimeException("Unexpected format in file " + filePath + ": " + line);
            }
            String alternative = parts[0];
            String lookup = (String)coherencyMap.get(parts[1]);
            if (lookup != null && lookup.equals(alternative)) {
                throw new RuntimeException("Contradictory entry in " + filePath + ": '" + alternative + "' suggests '" + lookup + "' and vice versa");
            }
            coherencyMap.put(parts[0], parts[1]);
            ArrayList<String> suggestions = new ArrayList<String>(Arrays.asList(parts).subList(1, parts.length));
            List<PatternToken> patternTokens = this.getTokens(alternative, german);
            PatternRule rule = new PatternRule(ruleId, german, patternTokens, ruleDesc, message, shortMessage);
            rule.setLocQualityIssueType(issueType);
            this.spellingRules.add(new SpellingRuleWithSuggestions((Rule)rule, alternative, suggestions, ignoreAfterQuote));
        }
    }

    @NotNull
    private List<PatternToken> getTokens(String alternative, Language lang) {
        PatternTokenBuilder builder = new PatternTokenBuilder();
        String[] suggestionTokens = alternative.split(" ");
        ArrayList<PatternToken> patternTokens = new ArrayList<PatternToken>();
        for (String part : suggestionTokens) {
            PatternToken token = this.isBaseform(alternative, lang) ? builder.csToken(part).matchInflectedForms().build() : builder.csToken(part).build();
            patternTokens.add(token);
        }
        return patternTokens;
    }

    private boolean isBaseform(String term, Language lang) {
        try {
            AnalyzedTokenReadings lookup = ((GermanTagger)lang.getTagger()).lookup(term);
            if (lookup != null) {
                return lookup.hasLemma(term);
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<SpellingRuleWithSuggestions> get() {
        return this.spellingRules;
    }
}

