/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.de.SpellingData;
import org.languagetool.rules.de.SpellingRuleWithSuggestions;

public class OldSpellingRule
extends Rule {
    private static final String DESC = "Findet Schreibweisen, die nur in der alten Rechtschreibung g\u00fcltig waren";
    private static final String FILE_PATH = "/de/alt_neu.csv";
    private static final String MESSAGE = "Diese Schreibweise war nur in der alten Rechtschreibung korrekt.";
    private static final String SHORT_MESSAGE = "alte Rechtschreibung";
    private static final String RULE_INTERNAL = "OLD_SPELLING_INTERNAL";
    private static final ITSIssueType ISSUE_TYPE = ITSIssueType.Misspelling;
    private static final SpellingData DATA = new SpellingData("Findet Schreibweisen, die nur in der alten Rechtschreibung g\u00fcltig waren", "/de/alt_neu.csv", "Diese Schreibweise war nur in der alten Rechtschreibung korrekt.", "alte Rechtschreibung", "OLD_SPELLING_INTERNAL", ISSUE_TYPE);

    public OldSpellingRule(ResourceBundle messages) {
        super.setCategory(Categories.TYPOS.getCategory(messages));
        this.setLocQualityIssueType(ISSUE_TYPE);
        this.addExamplePair(Example.wrong((String)"Der <marker>Abflu\u00df</marker> ist schon wieder verstopft."), Example.fixed((String)"Der <marker>Abfluss</marker> ist schon wieder verstopft."));
    }

    public String getId() {
        return "OLD_SPELLING";
    }

    public String getDescription() {
        return DESC;
    }

    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        String[] exceptions = new String[]{"Schlo\u00df Holte"};
        return this.toRuleMatchArray(SpellingRuleWithSuggestions.computeMatches(sentence, DATA, exceptions));
    }
}

