/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.languagetool.AnalyzedToken;
import org.languagetool.language.GermanyGerman;
import org.languagetool.synthesis.Synthesizer;

public class LineExpander
implements org.languagetool.rules.LineExpander {
    private static final Synthesizer synthesizer = new GermanyGerman().getSynthesizer();

    public List<String> expandLine(String line) {
        ArrayList<String> result = new ArrayList<String>();
        if (!line.startsWith("#") && line.contains("_")) {
            this.handleLineWithPrefix(line, result);
        } else if (!line.startsWith("#") && line.contains("/")) {
            this.handleLineWithFlags(line, result);
        } else {
            result.add(this.cleanTags(line));
        }
        return result;
    }

    private void handleLineWithPrefix(String line, List<String> result) {
        String[] parts = this.cleanTags(line).split("_");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Unexpected line format, expected at most one '_': " + line);
        }
        if (parts[0].contains("/") || parts[1].contains("/")) {
            throw new IllegalArgumentException("Unexpected line format, '_' cannot be combined with '/': " + line);
        }
        try {
            String[] forms = synthesizer.synthesize(new AnalyzedToken(parts[1], "FAKE", parts[1]), "VER:.*", true);
            if (forms.length == 0) {
                throw new RuntimeException("Could not expand '" + parts[1] + "' from line '" + line + "', no forms found");
            }
            HashSet<String> formSet = new HashSet<String>(Arrays.asList(forms));
            for (String form : formSet) {
                if (form.contains("\u00df")) continue;
                result.add(parts[0] + form);
            }
            result.add(parts[0] + "zu" + parts[1]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void handleLineWithFlags(String line, List<String> result) {
        String[] parts = this.cleanTags(line).split("/");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Unexpected line format, expected at most one slash: " + line);
        }
        String word = parts[0];
        String suffix = parts[1];
        for (int i = 0; i < suffix.length(); ++i) {
            char c = suffix.charAt(i);
            if (c == 'S') {
                this.add(result, word);
                result.add(word + "s");
                continue;
            }
            if (c == 'N') {
                this.add(result, word);
                result.add(word + "n");
                continue;
            }
            if (c == 'E') {
                this.add(result, word);
                result.add(word + "e");
                continue;
            }
            if (c == 'F') {
                this.add(result, word);
                result.add(word + "in");
                continue;
            }
            if (c == 'A') {
                this.add(result, word);
                if (word.endsWith("e")) {
                    result.add(word + "r");
                    result.add(word + "s");
                    result.add(word + "n");
                    result.add(word + "m");
                    continue;
                }
                result.add(word + "e");
                result.add(word + "er");
                result.add(word + "es");
                result.add(word + "en");
                result.add(word + "em");
                continue;
            }
            throw new IllegalArgumentException("Unknown suffix: " + suffix + " in line: " + line);
        }
    }

    private void add(List<String> result, String word) {
        if (!result.contains(word)) {
            result.add(word);
        }
    }

    private String cleanTags(String s) {
        int idx = s.indexOf(35);
        if (idx != -1) {
            s = s.substring(0, idx);
        }
        return s.trim();
    }
}

