/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tokenizers.de;

import de.danielnaber.jwordsplitter.EmbeddedGermanDictionary;
import de.danielnaber.jwordsplitter.GermanWordSplitter;
import de.danielnaber.jwordsplitter.InputTooLongException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.languagetool.tokenizers.Tokenizer;

public class GermanCompoundTokenizer
implements Tokenizer {
    private final ExtendedGermanWordSplitter wordSplitter = new ExtendedGermanWordSplitter(false);

    public GermanCompoundTokenizer() throws IOException {
        this(true);
    }

    public GermanCompoundTokenizer(boolean strictMode) throws IOException {
        this.wordSplitter.addException("Maskerade", Collections.singletonList("Maskerade"));
        this.wordSplitter.addException("Sportshorts", Arrays.asList("Sport", "shorts"));
        this.wordSplitter.addException("Bermudashorts", Arrays.asList("Bermuda", "shorts"));
        this.wordSplitter.addException("Laufshorts", Arrays.asList("Lauf", "shorts"));
        this.wordSplitter.addException("Badeshorts", Arrays.asList("Bade", "shorts"));
        this.wordSplitter.addException("Buchungstrick", Arrays.asList("Buchungs", "trick"));
        this.wordSplitter.addException("Buchungstricks", Arrays.asList("Buchungs", "tricks"));
        this.wordSplitter.addException("R\u00fcckzugsorte", Arrays.asList("R\u00fcckzugs", "orte"));
        this.wordSplitter.addException("Malerarbeiten", Arrays.asList("Maler", "arbeiten"));
        this.wordSplitter.setStrictMode(strictMode);
        this.wordSplitter.setMinimumWordLength(3);
    }

    public List<String> tokenize(String word) {
        try {
            return this.wordSplitter.splitWord(word);
        }
        catch (InputTooLongException e) {
            return Collections.singletonList(word);
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("Usage: " + GermanCompoundTokenizer.class.getSimpleName() + " <wordToSplit>");
            System.exit(1);
        }
        GermanCompoundTokenizer tokenizer = new GermanCompoundTokenizer();
        System.out.println(tokenizer.tokenize(args[0]));
    }

    static class ExtendedGermanWordSplitter
    extends GermanWordSplitter {
        ExtendedGermanWordSplitter(boolean hideInterfixCharacters) throws IOException {
            super(hideInterfixCharacters, ExtendedGermanWordSplitter.extendedList());
        }

        static Set<String> extendedList() {
            HashSet<String> words = new HashSet<String>(EmbeddedGermanDictionary.getWords());
            words.add("thermostat");
            words.add("fehl");
            words.add("circus");
            words.add("schi");
            words.add("codex");
            words.add("cr\u00e8me");
            words.add("sauce");
            words.add("account");
            words.add("photograph");
            words.add("oxyd");
            words.add("playback");
            words.add("blog");
            words.add("durchsuchung");
            words.add("kritisch");
            return words;
        }
    }
}

