/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.ArrayList;
import java.util.List;

public class LineExpander {
    public List<String> expandLine(String line) {
        ArrayList<String> result = new ArrayList<String>();
        if (!line.startsWith("#") && line.contains("/")) {
            String[] parts = this.cleanTags(line).split("/");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Unexpected line format, expected at most one slash: " + line);
            }
            String word = parts[0];
            String suffix = parts[1];
            result.add(word);
            for (int i = 0; i < suffix.length(); ++i) {
                char c = suffix.charAt(i);
                if (c == 'S') {
                    result.add(word + "s");
                    continue;
                }
                if (c == 'N') {
                    result.add(word + "n");
                    continue;
                }
                if (c == 'E') {
                    result.add(word + "e");
                    continue;
                }
                if (c == 'F') {
                    result.add(word + "in");
                    continue;
                }
                if (c == 'A') {
                    result.add(word + "e");
                    result.add(word + "er");
                    result.add(word + "es");
                    result.add(word + "en");
                    result.add(word + "em");
                    continue;
                }
                throw new IllegalArgumentException("Unknown suffix: " + suffix + " in line: " + line);
            }
        } else {
            result.add(this.cleanTags(line));
        }
        return result;
    }

    private String cleanTags(String s) {
        int idx = s.indexOf(35);
        if (idx != -1) {
            s = s.substring(0, idx);
        }
        return s.trim();
    }
}

