/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.languagetool.rules.AbstractWordCoherencyRule;
import org.languagetool.rules.Example;
import org.languagetool.rules.WordCoherencyDataLoader;

public class WordCoherencyRule
extends AbstractWordCoherencyRule {
    private static final Map<String, Set<String>> wordMap = new WordCoherencyDataLoader().loadWords("/de/coherency.txt");

    public WordCoherencyRule(ResourceBundle messages) throws IOException {
        super(messages);
        this.addExamplePair(Example.wrong((String)"Die Delfine geh\u00f6ren zu den Zahnwalen. <marker>Delphine</marker> sind in allen Meeren verbreitet."), Example.fixed((String)"Die Delfine geh\u00f6ren zu den Zahnwalen. <marker>Delfine</marker> sind in allen Meeren verbreitet."));
    }

    protected Map<String, Set<String>> getWordMap() {
        return wordMap;
    }

    protected String getMessage(String word1, String word2) {
        return "'" + word1 + "' und '" + word2 + "' sollten nicht gleichzeitig benutzt werden";
    }

    public String getId() {
        return "DE_WORD_COHERENCY";
    }

    public String getDescription() {
        return "Einheitliche Schreibweise f\u00fcr W\u00f6rter mit mehr als einer korrekten Schreibweise";
    }
}

