/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.de.SpellingRuleWithSuggestion;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.PatternTokenBuilder;
import org.languagetool.tagging.de.GermanTagger;

class SpellingData {
    private final List<SpellingRuleWithSuggestion> spellingRules = new ArrayList<SpellingRuleWithSuggestion>();

    SpellingData(String ruleDesc, String filePath, String message, String shortMessage, String ruleId, ITSIssueType issueType) {
        try (InputStream inputStream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(filePath);
             Scanner scanner = new Scanner(inputStream, "utf-8");){
            Language german = Languages.getLanguageForShortCode((String)"de");
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (line.startsWith("#")) continue;
                String[] parts = line.split(";");
                if (parts.length != 2) {
                    throw new RuntimeException("Unexpected format in file " + filePath + ": " + line);
                }
                String alternative = parts[0];
                String suggestion = parts[1];
                List<PatternToken> patternTokens = this.getTokens(alternative, german);
                PatternRule rule = new PatternRule(ruleId, german, patternTokens, ruleDesc, message, shortMessage);
                rule.setLocQualityIssueType(issueType);
                this.spellingRules.add(new SpellingRuleWithSuggestion((Rule)rule, alternative, suggestion));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private List<PatternToken> getTokens(String alternative, Language lang) {
        PatternTokenBuilder builder = new PatternTokenBuilder();
        String[] suggestionTokens = alternative.split(" ");
        ArrayList<PatternToken> patternTokens = new ArrayList<PatternToken>();
        for (String part : suggestionTokens) {
            PatternToken token = this.isBaseform(alternative, lang) ? builder.csToken(part).matchInflectedForms().build() : builder.csToken(part).build();
            patternTokens.add(token);
        }
        return patternTokens;
    }

    private boolean isBaseform(String term, Language lang) {
        try {
            AnalyzedTokenReadings lookup = ((GermanTagger)lang.getTagger()).lookup(term);
            if (lookup != null) {
                return lookup.hasLemma(term);
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<SpellingRuleWithSuggestion> get() {
        return this.spellingRules;
    }
}

