/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class DashRule
extends Rule {
    public DashRule(ResourceBundle messages) {
        super.setCategory(Categories.COMPOUNDING.getCategory(messages));
        this.addExamplePair(Example.wrong((String)"Bundestag beschlie\u00dft <marker>Di\u00e4ten- Erh\u00f6hung</marker>"), Example.fixed((String)"Bundestag beschlie\u00dft <marker>Di\u00e4ten-Erh\u00f6hung</marker>"));
    }

    public String getId() {
        return "DE_DASH";
    }

    public String getDescription() {
        return "Keine Leerzeichen in Bindestrich-Komposita (wie z.B. in 'Di\u00e4ten- Erh\u00f6hung')";
    }

    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        String prevToken = null;
        for (int i = 0; i < tokens.length; ++i) {
            char firstChar;
            String token = tokens[i].getToken();
            if (prevToken != null && prevToken.endsWith("-") && !prevToken.equals("-") && !prevToken.contains("--") && !prevToken.contains("\u2013-") && Character.isUpperCase(firstChar = token.charAt(0))) {
                if (StringUtils.isAllUpperCase((CharSequence)token) && StringUtils.isAllUpperCase((CharSequence)prevToken.substring(0, prevToken.length() - 1))) continue;
                String msg = "M\u00f6glicherweise fehlt ein 'und' oder ein Komma, oder es wurde nach dem Wort ein \u00fcberfl\u00fcssiges Leerzeichen eingef\u00fcgt. Eventuell haben Sie auch versehentlich einen Bindestrich statt eines Punktes eingef\u00fcgt.";
                String shortMsg = "Fehlendes 'und' oder Komma oder \u00fcberfl\u00fcssiges Leerzeichen?";
                RuleMatch ruleMatch = new RuleMatch((Rule)this, sentence, tokens[i - 1].getStartPos(), tokens[i - 1].getStartPos() + prevToken.length() + 1, msg, shortMsg);
                String prevTokenStr = tokens[i - 1].getToken();
                ruleMatch.setSuggestedReplacements(Arrays.asList(prevTokenStr, prevTokenStr + ", "));
                ruleMatches.add(ruleMatch);
            }
            prevToken = token;
        }
        return this.toRuleMatchArray(ruleMatches);
    }
}

