/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.chunking.ChunkTag;
import org.languagetool.language.German;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.PatternTokenBuilder;
import org.languagetool.tagging.de.GermanTagger;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tools.Tools;

public class SubjectVerbAgreementRule
extends Rule {
    private static final ChunkTag NPS = new ChunkTag("NPS");
    private static final ChunkTag NPP = new ChunkTag("NPP");
    private static final ChunkTag PP = new ChunkTag("PP");
    private static final List<String> QUESTION_PRONOUNS = Arrays.asList("wie");
    private static final List<String> CURRENCIES = Arrays.asList("Dollar", "Euro", "Yen");
    private static final List<SingularPluralPair> PAIRS = Arrays.asList(new SingularPluralPair("ist", "sind"), new SingularPluralPair("war", "waren"));
    private final Set<String> singular = new HashSet<String>();
    private final Set<String> plural = new HashSet<String>();
    private static final List<List<PatternToken>> ANTI_PATTERNS = Arrays.asList(Arrays.asList(new PatternTokenBuilder().tokenRegex("ist|war").build(), new PatternTokenBuilder().token("gemeinsam").build()), Arrays.asList(new PatternTokenBuilder().pos("SENT_START").build(), new PatternTokenBuilder().pos("ZAL").build(), new PatternTokenBuilder().tokenRegex("Tage|Monate|Jahre").build(), new PatternTokenBuilder().posRegex("VER:3:SIN:.*").build()), Arrays.asList(new PatternTokenBuilder().pos("SENT_START").build(), new PatternTokenBuilder().posRegex("ADV:MOD|ADJ:PRD:GRU").build(), new PatternTokenBuilder().pos("ZAL").build(), new PatternTokenBuilder().tokenRegex("Tage|Monate|Jahre").build(), new PatternTokenBuilder().posRegex("VER:3:SIN:.*").build()));
    private final GermanTagger tagger;
    private final German language;

    public SubjectVerbAgreementRule(ResourceBundle messages, German language) {
        super.setCategory(Categories.GRAMMAR.getCategory(messages));
        this.language = language;
        this.tagger = (GermanTagger)language.getTagger();
        for (SingularPluralPair pair : PAIRS) {
            this.singular.add(pair.singular);
            this.plural.add(pair.plural);
        }
        this.addExamplePair(Example.wrong((String)"Die Autos <marker>ist</marker> schnell."), Example.fixed((String)"Die Autos <marker>sind</marker> schnell."));
    }

    public String getId() {
        return "DE_SUBJECT_VERB_AGREEMENT";
    }

    public String getDescription() {
        return "Kongruenz von Subjekt und Pr\u00e4dikat (unvollst\u00e4ndig)";
    }

    public List<DisambiguationPatternRule> getAntiPatterns() {
        return this.makeAntiPatterns(ANTI_PATTERNS, this.language);
    }

    public URL getUrl() {
        return Tools.getUrl((String)"http://www.canoo.net/services/OnlineGrammar/Wort/Verb/Numerus-Person/ProblemNum.html");
    }

    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = this.getSentenceWithImmunization(sentence).getTokensWithoutWhitespace();
        for (int i = 1; i < tokens.length; ++i) {
            RuleMatch pluralMatch;
            if (tokens[i].isImmunized()) continue;
            String tokenStr = tokens[i].getToken();
            RuleMatch singularMatch = this.getSingularMatchOrNull(tokens, i, tokens[i], tokenStr, sentence);
            if (singularMatch != null) {
                ruleMatches.add(singularMatch);
            }
            if ((pluralMatch = this.getPluralMatchOrNull(tokens, i, tokens[i], tokenStr, sentence)) == null) continue;
            ruleMatches.add(pluralMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Nullable
    private RuleMatch getSingularMatchOrNull(AnalyzedTokenReadings[] tokens, int i, AnalyzedTokenReadings token, String tokenStr, AnalyzedSentence sentence) throws IOException {
        if (this.singular.contains(tokenStr)) {
            boolean match;
            AnalyzedTokenReadings prevToken = tokens[i - 1];
            AnalyzedTokenReadings nextToken = i + 1 < tokens.length ? tokens[i + 1] : null;
            List prevChunkTags = prevToken.getChunkTags();
            boolean bl = match = prevChunkTags.contains(NPP) && !prevChunkTags.contains(PP) && !prevToken.getToken().equals("Uhr") && !this.isCurrency(prevToken) && (nextToken == null || !nextToken.getToken().equals("es")) && this.prevChunkIsNominative(tokens, i - 1) && !this.hasUnknownTokenToTheLeft(tokens, i) && !this.hasQuestionPronounToTheLeft(tokens, i - 1) && !this.hasVerbToTheLeft(tokens, i - 1) && !this.containsRegexToTheLeft("wer", tokens, i - 1) && !this.containsRegexToTheLeft("(?i)alle[nr]?", tokens, i - 1) && !this.containsRegexToTheLeft("(?i)jede[rs]?", tokens, i - 1) && !this.containsRegexToTheLeft("(?i)manche[nrs]?", tokens, i - 1) && !this.containsOnlyInfinitivesToTheLeft(tokens, i - 1);
            if (match) {
                String message = "Bitte pr\u00fcfen, ob hier <suggestion>" + this.getPluralFor(tokenStr) + "</suggestion> stehen sollte.";
                return new RuleMatch((Rule)this, sentence, token.getStartPos(), token.getEndPos(), message);
            }
        }
        return null;
    }

    @Nullable
    private RuleMatch getPluralMatchOrNull(AnalyzedTokenReadings[] tokens, int i, AnalyzedTokenReadings token, String tokenStr, AnalyzedSentence sentence) {
        if (this.plural.contains(tokenStr)) {
            boolean match;
            AnalyzedTokenReadings prevToken = tokens[i - 1];
            List prevChunkTags = prevToken.getChunkTags();
            boolean bl = match = prevChunkTags.contains(NPS) && !prevChunkTags.contains(NPP) && !prevChunkTags.contains(PP) && !this.isCurrency(prevToken) && this.prevChunkIsNominative(tokens, i - 1) && !this.hasUnknownTokenToTheLeft(tokens, i) && !this.hasUnknownTokenToTheRight(tokens, i + 1) && !tokens[1].getToken().matches("Alle|Viele") && !this.isFollowedByNominativePlural(tokens, i + 1);
            if (match) {
                String message = "Bitte pr\u00fcfen, ob hier <suggestion>" + this.getSingularFor(tokenStr) + "</suggestion> stehen sollte.";
                return new RuleMatch((Rule)this, sentence, token.getStartPos(), token.getEndPos(), message);
            }
        }
        return null;
    }

    private boolean isCurrency(AnalyzedTokenReadings token) {
        return CURRENCIES.contains(token.getToken());
    }

    boolean prevChunkIsNominative(AnalyzedTokenReadings[] tokens, int startPos) {
        for (int i = startPos; i > 0; --i) {
            List chunkTags = tokens[i].getChunkTags();
            if (chunkTags.contains(NPS) || chunkTags.contains(NPP)) {
                if (!tokens[i].hasPartialPosTag("NOM")) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean hasUnknownTokenToTheLeft(AnalyzedTokenReadings[] tokens, int startPos) {
        return this.hasUnknownTokenAt(tokens, 0, startPos);
    }

    private boolean hasUnknownTokenToTheRight(AnalyzedTokenReadings[] tokens, int startPos) {
        return this.hasUnknownTokenAt(tokens, startPos, tokens.length - 1);
    }

    private boolean hasUnknownTokenAt(AnalyzedTokenReadings[] tokens, int startPos, int endPos) {
        for (int i = startPos; i < endPos; ++i) {
            AnalyzedTokenReadings token = tokens[i];
            for (AnalyzedToken analyzedToken : token.getReadings()) {
                if (!analyzedToken.hasNoTag()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasQuestionPronounToTheLeft(AnalyzedTokenReadings[] tokens, int startPos) {
        for (int i = startPos; i > 0; --i) {
            if (!QUESTION_PRONOUNS.contains(tokens[i].getToken().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private boolean hasVerbToTheLeft(AnalyzedTokenReadings[] tokens, int startPos) {
        for (int i = startPos; i > 0; --i) {
            if (!tokens[i].matchesPosTagRegex("VER:[1-3]:.*")) continue;
            return true;
        }
        return false;
    }

    private boolean containsRegexToTheLeft(String regex, AnalyzedTokenReadings[] tokens, int startPos) {
        Pattern p = Pattern.compile(regex);
        for (int i = startPos; i > 0; --i) {
            if (!p.matcher(tokens[i].getToken()).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean containsOnlyInfinitivesToTheLeft(AnalyzedTokenReadings[] tokens, int startPos) throws IOException {
        int infinitives = 0;
        for (int i = startPos; i > 0; --i) {
            String token = tokens[i].getToken();
            if (!tokens[i].hasPartialPosTag("SUB:")) continue;
            AnalyzedTokenReadings lookup = this.tagger.lookup(token.toLowerCase());
            if (lookup != null && lookup.hasPartialPosTag("VER:INF:")) {
                ++infinitives;
                continue;
            }
            return false;
        }
        return infinitives >= 2;
    }

    boolean isFollowedByNominativePlural(AnalyzedTokenReadings[] tokens, int startPos) {
        for (int i = startPos; i < tokens.length; ++i) {
            AnalyzedTokenReadings token = tokens[i];
            if (!token.hasPartialPosTag("SUB") && !token.hasPartialPosTag("PRO") || !token.hasPartialPosTag("NOM:PLU") && !token.getChunkTags().contains(new ChunkTag("NPP"))) continue;
            return true;
        }
        return false;
    }

    private String getSingularFor(String token) {
        for (SingularPluralPair pair : PAIRS) {
            if (!pair.plural.equals(token)) continue;
            return pair.singular;
        }
        throw new RuntimeException("No singular found for '" + token + "'");
    }

    private String getPluralFor(String token) {
        for (SingularPluralPair pair : PAIRS) {
            if (!pair.singular.equals(token)) continue;
            return pair.plural;
        }
        throw new RuntimeException("No plural found for '" + token + "'");
    }

    private static class SingularPluralPair {
        String singular;
        String plural;

        SingularPluralPair(String singular, String plural) {
            this.singular = singular;
            this.plural = plural;
        }
    }
}

