/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.de.OldSpellingData;
import org.languagetool.rules.de.OldSpellingRuleWithSuggestion;

public class OldSpellingRule
extends Rule {
    private static final String DESC = "Findet Schreibweisen, die nur in der alten Rechtschreibung g\u00fcltig waren";
    private static final OldSpellingData data = new OldSpellingData("Findet Schreibweisen, die nur in der alten Rechtschreibung g\u00fcltig waren");

    public OldSpellingRule(ResourceBundle messages) throws IOException {
        super.setCategory(Categories.TYPOS.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.addExamplePair(Example.wrong((String)"Der <marker>Abflu\u00df</marker> ist schon wieder verstopft."), Example.fixed((String)"Der <marker>Abfluss</marker> ist schon wieder verstopft."));
    }

    public String getId() {
        return "OLD_SPELLING";
    }

    public String getDescription() {
        return DESC;
    }

    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        for (OldSpellingRuleWithSuggestion ruleWithSuggestion : data.get()) {
            String suggestion;
            Rule rule = ruleWithSuggestion.rule;
            RuleMatch[] matches = rule.match(sentence);
            if (matches.length <= 0) continue;
            RuleMatch match = matches[0];
            String matchedText = sentence.getText().substring(match.getFromPos(), match.getToPos());
            String textFromMatch = sentence.getText().substring(match.getFromPos());
            if (textFromMatch.startsWith("Schlo\u00df Holte") || (suggestion = matchedText.replace(ruleWithSuggestion.oldSpelling, ruleWithSuggestion.newSpelling)).equals(matchedText)) continue;
            match.setSuggestedReplacement(suggestion);
            ruleMatches.addAll(Arrays.asList(matches));
        }
        return this.toRuleMatchArray(ruleMatches);
    }
}

