/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tokenizers.de;

import de.danielnaber.jwordsplitter.GermanWordSplitter;
import java.io.IOException;
import java.util.List;
import org.languagetool.tokenizers.Tokenizer;

public class GermanCompoundTokenizer
implements Tokenizer {
    private final GermanWordSplitter wordSplitter = new GermanWordSplitter(false);

    public GermanCompoundTokenizer() throws IOException {
        this(true);
    }

    public GermanCompoundTokenizer(boolean strictMode) throws IOException {
        this.wordSplitter.setStrictMode(strictMode);
        this.wordSplitter.setMinimumWordLength(3);
    }

    public List<String> tokenize(String word) {
        return this.wordSplitter.splitWord(word);
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("Usage: " + GermanCompoundTokenizer.class.getSimpleName() + " <wordToSplit>");
            System.exit(1);
        }
        GermanCompoundTokenizer tokenizer = new GermanCompoundTokenizer();
        System.out.println(tokenizer.tokenize(args[0]));
    }
}

