/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import de.abelssoft.wordtools.jwordsplitter.AbstractWordSplitter;
import de.abelssoft.wordtools.jwordsplitter.impl.GermanWordSplitter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.rules.Example;
import org.languagetool.rules.spelling.hunspell.CompoundAwareHunspellRule;
import org.languagetool.rules.spelling.morfologik.MorfologikSpeller;
import org.languagetool.tokenizers.CompoundWordTokenizer;
import org.languagetool.tokenizers.de.GermanCompoundTokenizer;

public class GermanSpellerRule
extends CompoundAwareHunspellRule {
    public static final String RULE_ID = "GERMAN_SPELLER_RULE";
    private static final int MAX_EDIT_DISTANCE = 2;
    private static final int SUGGESTION_MIN_LENGTH = 2;
    private static final List<Replacement> REPL = new ArrayList<Replacement>();
    private GermanCompoundTokenizer compoundTokenizer;

    public GermanSpellerRule(ResourceBundle messages, Language language) throws IOException {
        super(messages, language, GermanSpellerRule.getCompoundSplitter(), GermanSpellerRule.getSpeller(language));
        this.addExamplePair(Example.wrong((String)"LanguageTool kann mehr als eine <marker>nromale</marker> Rechtschreibpr\u00fcfung."), Example.fixed((String)"LanguageTool kann mehr als eine <marker>normale</marker> Rechtschreibpr\u00fcfung."));
        this.compoundTokenizer = new GermanCompoundTokenizer();
    }

    public String getId() {
        return RULE_ID;
    }

    private static CompoundWordTokenizer getCompoundSplitter() {
        try {
            GermanWordSplitter wordSplitter = new GermanWordSplitter(false);
            wordSplitter.setStrictMode(false);
            wordSplitter.setMinimumWordLength(3);
            return new CompoundWordTokenizer((AbstractWordSplitter)wordSplitter){
                final /* synthetic */ AbstractWordSplitter val$wordSplitter;
                {
                    this.val$wordSplitter = abstractWordSplitter;
                }

                public List<String> tokenize(String word) {
                    return new ArrayList<String>(this.val$wordSplitter.splitWord(word));
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException("Could not set up German compound splitter", e);
        }
    }

    private static MorfologikSpeller getSpeller(Language language) {
        if (!language.getShortName().equals(Locale.GERMAN.getLanguage())) {
            throw new RuntimeException("Language is not a variant of German: " + language);
        }
        try {
            String morfoFile = "/de/hunspell/de_" + language.getCountries()[0] + ".dict";
            if (JLanguageTool.getDataBroker().resourceExists(morfoFile)) {
                return new MorfologikSpeller(morfoFile, Locale.getDefault(), 2);
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not set up morfologik spell checker", e);
        }
    }

    protected List<String> sortSuggestionByQuality(String misspelling, List<String> suggestions) {
        List<String> sorted1 = this.sortByReplacements(misspelling, suggestions);
        List<String> sorted2 = this.sortByCase(misspelling, sorted1);
        return sorted2;
    }

    protected boolean ignoreWord(List<String> words, int idx) throws IOException {
        boolean ignore = super.ignoreWord(words, idx);
        boolean ignoreByHyphen = !ignore && words.get(idx).endsWith("-") && this.ignoreByHangingHyphen(words, idx);
        return ignore || ignoreByHyphen;
    }

    private boolean ignoreByHangingHyphen(List<String> words, int idx) {
        boolean isCompound;
        String word = words.get(idx);
        String nextWord = this.getWordAfterEnumerationOrNull(words, idx);
        boolean bl = isCompound = nextWord != null && this.compoundTokenizer.tokenize(nextWord).size() > 1;
        if (isCompound) {
            return !this.dictionary.misspelled(word.replaceFirst("-$", ""));
        }
        return false;
    }

    private String getWordAfterEnumerationOrNull(List<String> words, int idx) {
        for (int i = idx; i < words.size(); ++i) {
            boolean inEnumeration;
            String word = words.get(i);
            boolean bl = inEnumeration = ",".equals(word) || "und".equals(word) || "oder".equals(word) || word.trim().isEmpty() || word.endsWith("-");
            if (inEnumeration) continue;
            return word;
        }
        return null;
    }

    private List<String> sortByReplacements(String misspelling, List<String> suggestions) {
        ArrayList<String> result = new ArrayList<String>();
        for (String suggestion : suggestions) {
            boolean moveSuggestionToTop = false;
            for (Replacement replacement : REPL) {
                String modifiedMisspelling = misspelling.replace(replacement.key, replacement.value);
                boolean equalsAfterReplacement = modifiedMisspelling.equals(suggestion);
                if (!equalsAfterReplacement) continue;
                moveSuggestionToTop = true;
                break;
            }
            if (this.ignoreSuggestion(suggestion)) continue;
            if (moveSuggestionToTop) {
                result.add(0, suggestion);
                continue;
            }
            result.add(suggestion);
        }
        return result;
    }

    private List<String> sortByCase(String misspelling, List<String> suggestions) {
        ArrayList<String> result = new ArrayList<String>();
        for (String suggestion : suggestions) {
            if (misspelling.equalsIgnoreCase(suggestion)) {
                result.add(0, suggestion);
                continue;
            }
            result.add(suggestion);
        }
        return result;
    }

    private boolean ignoreSuggestion(String suggestion) {
        String[] parts = suggestion.split(" ");
        if (parts.length > 1) {
            for (String part : parts) {
                if (part.length() >= 2) continue;
                return true;
            }
        }
        return false;
    }

    static {
        REPL.add(new Replacement("f", "ph"));
        REPL.add(new Replacement("ph", "f"));
        REPL.add(new Replacement("\u00df", "ss"));
        REPL.add(new Replacement("ss", "\u00df"));
        REPL.add(new Replacement("s", "ss"));
        REPL.add(new Replacement("ss", "s"));
        REPL.add(new Replacement("i", "ie"));
        REPL.add(new Replacement("ie", "i"));
        REPL.add(new Replacement("ee", "e"));
        REPL.add(new Replacement("o", "oh"));
        REPL.add(new Replacement("oh", "o"));
        REPL.add(new Replacement("a", "ah"));
        REPL.add(new Replacement("ah", "a"));
        REPL.add(new Replacement("e", "eh"));
        REPL.add(new Replacement("eh", "e"));
        REPL.add(new Replacement("ae", "\u00e4"));
        REPL.add(new Replacement("oe", "\u00f6"));
        REPL.add(new Replacement("ue", "\u00fc"));
        REPL.add(new Replacement("Ae", "\u00c4"));
        REPL.add(new Replacement("Oe", "\u00d6"));
        REPL.add(new Replacement("Ue", "\u00dc"));
        REPL.add(new Replacement("d", "t"));
        REPL.add(new Replacement("t", "d"));
        REPL.add(new Replacement("th", "t"));
        REPL.add(new Replacement("t", "th"));
        REPL.add(new Replacement("r", "rh"));
        REPL.add(new Replacement("ch", "k"));
        REPL.add(new Replacement("k", "ch"));
        REPL.add(new Replacement("F", "Ph"));
        REPL.add(new Replacement("Ph", "F"));
    }

    private static class Replacement {
        String key;
        String value;

        private Replacement(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

