/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.ca.PronomsFeblesHelper;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.tools.StringTools;

public class PossessiusRedundantsFilter
extends RuleFilter {
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens, List<Integer> tokenPositions) throws IOException {
        boolean apostropheNeeded;
        String pronounPostag;
        int posPronoun;
        int posVerb;
        int posPossessive;
        AnalyzedTokenReadings[] tokens = match.getSentence().getTokensWithoutWhitespace();
        for (posPossessive = patternTokenPos; posPossessive < tokens.length && !tokens[posPossessive].hasPartialPosTag("PX"); ++posPossessive) {
        }
        String possessivePostag = tokens[posPossessive].readingWithTagRegex("PX.*").getPOSTag();
        String number = possessivePostag.substring(6, 7);
        String persona = possessivePostag.substring(2, 3);
        for (posVerb = patternTokenPos - 1; posVerb > 0 && tokens[posVerb].getChunkTags().stream().anyMatch(x -> x.getChunkTag().equals("GV")); --posVerb) {
        }
        boolean pronounFound = false;
        boolean hasSomePronoun = false;
        for (posPronoun = ++posVerb - 1; !pronounFound && posPronoun > 0 && tokens[posPronoun].hasPosTagStartingWith("P"); --posPronoun) {
            hasSomePronoun = true;
            pronounPostag = tokens[posPronoun].readingWithTagRegex("P.*").getPOSTag();
            pronounFound = pronounPostag.substring(2, 3).equals(persona) && (number.equals("C") || pronounPostag.substring(4, 5).equals(number));
        }
        for (posPronoun = patternTokenPos + 1; !pronounFound && posPronoun < tokens.length && tokens[posPronoun].hasPosTagStartingWith("P"); ++posPronoun) {
            hasSomePronoun = true;
            pronounPostag = tokens[posPronoun].readingWithTagRegex("P.*").getPOSTag();
            pronounFound = pronounPostag.substring(2, 3).equals(persona) && (number.equals("C") || pronounPostag.substring(4, 5).equals(number));
        }
        boolean bl = apostropheNeeded = tokens[posPossessive - 1].hasAnyPartialPosTag(new String[]{"DA0MS0", "DA0FS0"}) && PronomsFeblesHelper.pApostropheNeeded.matcher(tokens[posPossessive + 1].getToken()).matches();
        if (pronounFound) {
            if (apostropheNeeded) {
                match.setOffsetPosition(tokens[posPossessive - 1].getStartPos(), tokens[posPossessive + 1].getEndPos());
                match.setSuggestedReplacement("l'" + tokens[posPossessive + 1].getToken());
            } else {
                match.setOffsetPosition(tokens[posPossessive].getStartPos(), tokens[posPossessive].getEndPos());
                match.setSuggestedReplacement("");
            }
            return match;
        }
        if (!hasSomePronoun) {
            int i;
            String pronounSugg;
            StringBuilder suggestion = new StringBuilder();
            if (tokens[posVerb].hasAnyPartialPosTag(new String[]{"VMN", "VMG"})) {
                pronounSugg = PronomsFeblesHelper.transformDarrere(PronomsFeblesHelper.dativePronoun.get(persona + number), tokens[posVerb].getToken());
                suggestion.append(tokens[posVerb].getToken());
                suggestion.append(pronounSugg);
            } else {
                pronounSugg = PronomsFeblesHelper.transformDavant(PronomsFeblesHelper.dativePronoun.get(persona + number), tokens[posVerb].getToken());
                suggestion.append(StringTools.preserveCase((String)pronounSugg, (String)tokens[posVerb].getToken()));
                suggestion.append(tokens[posVerb].getToken().toLowerCase());
            }
            for (i = posVerb + 1; i <= posPossessive - 2; ++i) {
                if (tokens[i].isWhitespaceBefore()) {
                    suggestion.append(" ");
                }
                suggestion.append(tokens[i].getToken().toLowerCase());
            }
            if (apostropheNeeded) {
                suggestion.append(" ");
                suggestion.append("l'" + tokens[posPossessive + 1].getToken());
            } else {
                for (i = posPossessive - 1; i <= posPossessive + 1; ++i) {
                    if (i == posPossessive) continue;
                    if (tokens[i].isWhitespaceBefore()) {
                        suggestion.append(" ");
                    }
                    suggestion.append(tokens[i].getToken());
                }
            }
            match.setOffsetPosition(tokens[posVerb].getStartPos(), tokens[posPossessive + 1].getEndPos());
            match.setSuggestedReplacement(suggestion.toString());
            return match;
        }
        return null;
    }
}

