/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.Tag;
import org.languagetool.rules.AbstractRepeatedWordsRule;
import org.languagetool.rules.SynonymsData;
import org.languagetool.rules.patterns.PatternRuleBuilderHelper;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;

public class CatalanRepeatedWordsRule
extends AbstractRepeatedWordsRule {
    private final Supplier<List<DisambiguationPatternRule>> antiPatterns;
    private static final List<List<PatternToken>> ANTI_PATTERNS = Arrays.asList(Arrays.asList(PatternRuleBuilderHelper.csRegex((String)"[Tt]ema|TEMA"), PatternRuleBuilderHelper.csRegex((String)"\\d+|[IXVC]+")));
    private static final Map<String, SynonymsData> wordsToCheck = CatalanRepeatedWordsRule.loadWords((String)"/ca/synonyms.txt");

    public List<DisambiguationPatternRule> getAntiPatterns() {
        return this.antiPatterns.get();
    }

    public CatalanRepeatedWordsRule(ResourceBundle messages, Language lang) {
        super(messages, lang);
        this.antiPatterns = CatalanRepeatedWordsRule.cacheAntiPatterns((Language)lang, ANTI_PATTERNS);
        super.setTags(Arrays.asList(Tag.picky));
    }

    protected String getMessage() {
        return "Aquesta paraula apareix en una de les frases anteriors. Podeu substituir-la per un sin\u00f2nim per a fer m\u00e9s variat el text, llevat que la repetici\u00f3 sigui intencionada.";
    }

    public String getDescription() {
        return "Sin\u00f2nims per a paraules repetides.";
    }

    protected Map<String, SynonymsData> getWordsToCheck() {
        return wordsToCheck;
    }

    protected String getShortMessage() {
        return "Estil: paraula repetida";
    }

    protected Synthesizer getSynthesizer() {
        return this.language.getSynthesizer();
    }

    protected String adjustPostag(String postag) {
        if (postag.contains("CN")) {
            return postag.replaceFirst("CN", "..");
        }
        if (postag.contains("MS")) {
            return postag.replaceFirst("MS", "[MC][SN]");
        }
        if (postag.contains("FS")) {
            return postag.replaceFirst("FS", "[FC][SN]");
        }
        if (postag.contains("MP")) {
            return postag.replaceFirst("MP", "[MC][PN]");
        }
        if (postag.contains("FP")) {
            return postag.replaceFirst("FP", "[FC][PN]");
        }
        if (postag.contains("CS")) {
            return postag.replaceFirst("CS", "[MFC][SN]");
        }
        if (postag.contains("CP")) {
            return postag.replaceFirst("CP", "[MFC][PN]");
        }
        if (postag.contains("MN")) {
            return postag.replaceFirst("MN", "[MC][SPN]");
        }
        if (postag.contains("FN")) {
            return postag.replaceFirst("FN", "[FC][SPN]");
        }
        return postag;
    }

    protected boolean isException(AnalyzedTokenReadings[] tokens, int i, boolean sentStart, boolean isCapitalized, boolean isAllUppercase) {
        if (isAllUppercase || isCapitalized && !sentStart) {
            return true;
        }
        return tokens[i].hasPosTagStartingWith("NP") || tokens[i].hasPosTag("_english_ignore_");
    }
}

