/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.synthesis.ca;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.languagetool.AnalyzedToken;
import org.languagetool.synthesis.BaseSynthesizer;

public class CatalanSynthesizer
extends BaseSynthesizer {
    private static final Map<String, String> verbTags = new HashMap<String, String>();
    public static final List<String> LemmasToIgnore;
    private static final Pattern pVerb;
    private static final Pattern pLemmaSpace;
    public static final CatalanSynthesizer INSTANCE;

    protected CatalanSynthesizer() {
        super("/ca/ca.sor", "/ca/ca-ES-valencia_synth.dict", "/ca/ca-ES-valencia_tags.txt", "ca");
    }

    public String[] synthesize(AnalyzedToken token, String posTag) throws IOException {
        return this.synthesize(token, posTag, "ca-ES");
    }

    public String[] synthesize(AnalyzedToken token, String posTag, String langVariantCode) throws IOException {
        Matcher mLemmaSpace;
        if (posTag.startsWith("_spell_number_")) {
            return super.synthesize(token, posTag);
        }
        String lemma = token.getLemma();
        String toAddAfter = "";
        if (posTag.startsWith("V") && (mLemmaSpace = pLemmaSpace.matcher(lemma)).matches()) {
            lemma = mLemmaSpace.group(1);
            toAddAfter = mLemmaSpace.group(2);
        }
        this.initPossibleTags();
        Pattern p = Pattern.compile(posTag);
        ArrayList<String> results = new ArrayList<String>();
        for (String tag : this.possibleTags) {
            Matcher m = p.matcher(tag);
            if (!m.matches()) continue;
            results.addAll(this.lookup(lemma, tag));
        }
        if (results.isEmpty() && posTag.startsWith("V")) {
            return this.synthesize(token, posTag.substring(0, posTag.length() - 1).concat(verbTags.get(langVariantCode)), true);
        }
        return this.addWordsAfter(results, toAddAfter).toArray(new String[0]);
    }

    public String[] synthesize(AnalyzedToken token, String posTag, boolean posTagRegExp) throws IOException {
        return this.synthesize(token, posTag, posTagRegExp, "ca-ES");
    }

    public String[] synthesize(AnalyzedToken token, String posTag, boolean posTagRegExp, String langVariantCode) throws IOException {
        if (posTag.startsWith("_spell_number_")) {
            return this.synthesize(token, posTag);
        }
        if (posTagRegExp) {
            Matcher mVerb;
            Pattern p;
            Matcher mLemmaSpace;
            String lemma = token.getLemma();
            if (LemmasToIgnore.contains(lemma)) {
                return new String[0];
            }
            String toAddAfter = "";
            if (posTag.startsWith("V") && (mLemmaSpace = pLemmaSpace.matcher(lemma)).matches()) {
                lemma = mLemmaSpace.group(1);
                toAddAfter = mLemmaSpace.group(2);
            }
            this.initPossibleTags();
            try {
                p = Pattern.compile(posTag);
            }
            catch (PatternSyntaxException e) {
                System.err.println("WARNING: Error trying to synthesize POS tag " + posTag + " from token " + token.getToken() + ": " + e.getMessage());
                return null;
            }
            ArrayList<String> results = new ArrayList<String>();
            for (String tag : this.possibleTags) {
                Matcher m = p.matcher(tag);
                if (!m.matches()) continue;
                results.addAll(this.lookup(lemma, tag));
            }
            if (results.isEmpty() && (mVerb = pVerb.matcher(posTag)).matches()) {
                p = Pattern.compile(posTag.substring(0, posTag.length() - 1).concat(verbTags.get(langVariantCode)));
                for (String tag : this.possibleTags) {
                    Matcher m = p.matcher(tag);
                    if (!m.matches()) continue;
                    results.addAll(this.lookup(lemma, tag));
                }
            }
            return this.addWordsAfter(results, toAddAfter).toArray(new String[0]);
        }
        return this.synthesize(token, posTag);
    }

    private List<String> addWordsAfter(List<String> results, String toAddAfter) {
        if (!toAddAfter.isEmpty()) {
            ArrayList<String> output = new ArrayList<String>();
            for (String result : results) {
                output.add(result + " " + toAddAfter);
            }
            return output;
        }
        return results;
    }

    public String getTargetPosTag(List<String> posTags, String targetPosTag) {
        if (posTags.isEmpty()) {
            return targetPosTag;
        }
        PostagComparator postagComparator = new PostagComparator();
        posTags.sort(postagComparator);
        return posTags.get(posTags.size() - 1);
    }

    public List<String> getPossibleTags() throws IOException {
        this.initPossibleTags();
        return this.possibleTags;
    }

    static {
        verbTags.put("ca-ES", "[0CXY12]");
        verbTags.put("ca-ES-valencia", "[0VXZ13567]");
        verbTags.put("ca-ES-balear", "[0BYZ1247]");
        LemmasToIgnore = Arrays.asList("enterar", "sentar", "conseguir", "alcan\u00e7ar");
        pVerb = Pattern.compile("V.*[CVBXYZ0123456]");
        pLemmaSpace = Pattern.compile("([^ ]+) (.+)");
        INSTANCE = new CatalanSynthesizer();
    }

    private static class PostagComparator
    implements Comparator<String> {
        private PostagComparator() {
        }

        @Override
        public int compare(String arg0, String arg1) {
            int len0 = arg0.length();
            int len1 = arg1.length();
            if (len0 > 4 && len1 > 4) {
                if (arg0.equals("VMIS3S00") && arg1.equals("VMIS1S00")) {
                    return 150;
                }
                if (arg0.equals("VMIS1S00") && arg1.equals("VMIS3S00")) {
                    return -150;
                }
                if (arg0.equals("VMIP2P00") && arg1.equals("VMIS3S00")) {
                    return 150;
                }
                if (arg1.equals("VMIP2P00") && arg0.equals("VMIS3S00")) {
                    return -150;
                }
                if (arg0.charAt(2) == 'I' && arg1.charAt(2) != 'I') {
                    return 100;
                }
                if (arg1.charAt(2) == 'I' && arg0.charAt(2) != 'I') {
                    return -100;
                }
                if (arg0.charAt(4) == '3' && arg1.charAt(4) == '1') {
                    return 50;
                }
                if (arg1.charAt(4) == '1' && arg0.charAt(4) == '3') {
                    return -50;
                }
            }
            return 0;
        }
    }
}

