/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.languagetool.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.ca.AbstractSimpleReplaceLemmasRule;

public class SimpleReplaceDNVColloquialRule
extends AbstractSimpleReplaceLemmasRule {
    private static final LoadingCache<String, Map<String, List<String>>> cache = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Map<String, List<String>>>(){

        public Map<String, List<String>> load(@NotNull String path) {
            return SimpleReplaceDNVColloquialRule.loadFromPath((String)path);
        }
    });

    public SimpleReplaceDNVColloquialRule(ResourceBundle messages, Language language) throws IOException {
        super(messages, language);
        this.wrongLemmas = (Map)cache.getUnchecked((Object)"/ca/replace_dnv_colloquial.txt");
        super.setCategory(Categories.COLLOQUIALISMS.getCategory(messages));
        super.setLocQualityIssueType(ITSIssueType.Style);
        super.useSubRuleSpecificIds();
    }

    public final String getId() {
        return "CA_SIMPLE_REPLACE_DNV_COLLOQUIAL";
    }

    public String getDescription() {
        return "Detecta paraules marcades com a col\u00b7loquials en el DNV.";
    }

    public String getShort() {
        return "Paraula o expressi\u00f3 col\u00b7loquial.";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return "Paraula o expressi\u00f3 col\u00b7loquial.";
    }
}

