/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.util.regex.Pattern;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;

public class PronomsFeblesHelper {
    private static final String[] pronomsFebles = new String[]{"el", "l'", "-lo", "'l", "els el", "els l'", "-los-el", "'ls-el", "els els", "els els", "-los-els", "'ls-els", "els en", "els n'", "-los-en", "'ls-en", "els hi", "els hi", "-los-hi", "'ls-hi", "els ho", "els ho", "-los-ho", "'ls-ho", "els la", "els l'", "-los-la", "'ls-la", "els les", "els les", "-los-les", "'ls-les", "els", "els", "-los", "'ls", "em", "m'", "-me", "'m", "en", "n'", "-ne", "'n", "ens el", "ens l'", "-nos-el", "'ns-el", "ens els", "ens els", "-nos-els", "'ns-els", "ens en", "ens n'", "-nos-en", "'ns-en", "ens hi", "ens hi", "-nos-hi", "'ns-hi", "ens ho", "ens ho", "-nos-ho", "'ns-ho", "ens la", "ens l'", "-nos-la", "'ns-la", "ens les", "ens les", "-nos-les", "'ns-les", "ens li", "ens li", "-nos-li", "'ns-li", "ens", "ens", "-nos", "'ns", "es", "s'", "-se", "'s", "et", "t'", "-te", "'t", "hi", "hi", "-hi", "-hi", "ho", "ho", "-ho", "-ho", "l'en", "el n'", "-l'en", "-l'en", "l'hi", "l'hi", "-l'hi", "-l'hi", "la hi", "la hi", "-la-hi", "-la-hi", "la", "l'", "-la", "-la", "la'n", "la n'", "-la'n", "-la'n", "les en", "les n'", "-les-en", "-les-en", "les hi", "les hi", "-les-hi", "-les-hi", "les", "les", "-les", "-les", "li hi", "li hi", "-li-hi", "-li-hi", "li ho", "li ho", "-li-ho", "-li-ho", "li la", "li l'", "-li-la", "-li-la", "li les", "li les", "-li-les", "-li-les", "li", "li", "-li", "-li", "li'l", "li l'", "-li'l", "-li'l", "li'ls", "li'ls", "-li'ls", "-li'ls", "li'n", "li n'", "-li'n", "-li'n", "m'hi", "m'hi", "-m'hi", "-m'hi", "m'ho", "m'ho", "-m'ho", "-m'ho", "me la", "me l'", "-me-la", "-me-la", "me les", "me les", "-me-les", "-me-les", "me li", "me li", "-me-li", "-me-li", "me'l", "me l'", "-me'l", "-me'l", "me'ls", "me'ls", "-me'ls", "-me'ls", "me'n", "me n'", "-me'n", "-me'n", "n'hi", "n'hi", "-n'hi", "-n'hi", "s'hi", "s'hi", "-s'hi", "-s'hi", "s'ho", "s'ho", "-s'ho", "-s'ho", "se la", "se l'", "-se-la", "-se-la", "se les", "se les", "-se-les", "-se-les", "se li", "se li", "-se-li", "-se-li", "se us", "se us", "-se-us", "-se-us", "se vos", "se vos", "-se-vos", "-se-vos", "se'l", "se l'", "-se'l", "-se'l", "se'ls", "se'ls", "-se'ls", "-se'ls", "se'm", "se m'", "-se'm", "-se'm", "se'n", "se n'", "-se'n", "-se'n", "se'ns", "se'ns", "-se'ns", "-se'ns", "se't", "se t'", "-se't", "-se't", "t'hi", "t'hi", "-t'hi", "-t'hi", "t'ho", "t'ho", "-t'ho", "-t'ho", "te la", "te l'", "-te-la", "-te-la", "te les", "te les", "-te-les", "-te-les", "te li", "te li", "-te-li", "-te-li", "te'l", "te l'", "-te'l", "-te'l", "te'ls", "te'ls", "-te'ls", "-te'ls", "te'm", "te m'", "-te'm", "-te'm", "te'n", "te n'", "-te'n", "-te'n", "te'ns", "te'ns", "-te'ns", "-te'ns", "us el", "us l'", "-vos-el", "-us-el", "us els", "us els", "-vos-els", "-us-els", "us em", "us m'", "-vos-em", "-us-em", "us en", "us n'", "-vos-en", "-us-en", "us ens", "us ens", "-vos-ens", "-us-ens", "us hi", "us hi", "-vos-hi", "-us-hi", "us ho", "us ho", "-vos-ho", "-us-ho", "us la", "us l'", "-vos-la", "-us-la", "us les", "us les", "-vos-les", "-us-les", "us li", "us li", "-vos-li", "-us-li", "us", "us", "-vos", "-us"};
    static Pattern pApostropheNeeded = Pattern.compile("h?[aeiou\u00e0\u00e8\u00e9\u00ed\u00f2\u00f3\u00fa].*", 2);
    static Pattern pApostropheNeededEnd = Pattern.compile(".*[aei]", 2);

    PronomsFeblesHelper() {
    }

    public static String transform(String inputPronom, PronounPosition pronounPos) {
        int i;
        for (i = 0; i < pronomsFebles.length && !inputPronom.equalsIgnoreCase(pronomsFebles[i]); ++i) {
        }
        int pfPos = 4 * (i / 4) + pronounPos.ordinal();
        if (pfPos > pronomsFebles.length - 1) {
            return "";
        }
        String pronom = pronomsFebles[pfPos];
        if (pronounPos == PronounPosition.DAVANT || pronounPos == PronounPosition.DAVANT_APOS && !pronom.endsWith("'")) {
            pronom = pronom + " ";
        }
        return pronom;
    }

    public static String transformDavant(String inputPronom, String nextWord) {
        if (pApostropheNeeded.matcher(nextWord).matches()) {
            return PronomsFeblesHelper.transform(inputPronom, PronounPosition.DAVANT_APOS);
        }
        return PronomsFeblesHelper.transform(inputPronom, PronounPosition.DAVANT);
    }

    public static String transformDarrere(String inputPronom, String previousWord) {
        if (pApostropheNeededEnd.matcher(previousWord).matches()) {
            return PronomsFeblesHelper.transform(inputPronom, PronounPosition.DARRERE_APOS);
        }
        return PronomsFeblesHelper.transform(inputPronom, PronounPosition.DARRERE);
    }

    public static String[] getTwoNextPronouns(AnalyzedTokenReadings[] tokens, int from) {
        String[] result = new String[2];
        int numPronouns = 0;
        String pronoms = "";
        if (from < tokens.length && !tokens[from].isWhitespaceBefore()) {
            AnalyzedToken pronom2;
            AnalyzedToken pronom = tokens[from].readingWithTagRegex("P[P0].*");
            if (pronom != null) {
                pronoms = pronom.getToken();
                ++numPronouns;
            }
            if (from + 1 < tokens.length && !tokens[from + 1].isWhitespaceBefore() && (pronom2 = tokens[from + 1].readingWithTagRegex("P[P0].*")) != null) {
                pronoms = pronoms + pronom2.getToken();
                ++numPronouns;
            }
        }
        result[0] = pronoms;
        result[1] = String.valueOf(numPronouns);
        return result;
    }

    static enum PronounPosition {
        DAVANT,
        DAVANT_APOS,
        DARRERE,
        DARRERE_APOS;

    }
}

