/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.UserConfig;
import org.languagetool.language.Contributor;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.Example;
import org.languagetool.rules.LongSentenceRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.ca.CatalanUnpairedBracketsRule;
import org.languagetool.rules.ca.CatalanUnpairedExclamationMarksRule;
import org.languagetool.rules.ca.CatalanUnpairedQuestionMarksRule;
import org.languagetool.rules.ca.CatalanWordRepeatRule;
import org.languagetool.rules.ca.CatalanWrongWordInContextRule;
import org.languagetool.rules.ca.CheckCaseRule;
import org.languagetool.rules.ca.MorfologikCatalanSpellerRule;
import org.languagetool.rules.ca.PronomFebleDuplicateRule;
import org.languagetool.rules.ca.ReplaceOperationNamesRule;
import org.languagetool.rules.ca.SimpleReplaceAdverbsMent;
import org.languagetool.rules.ca.SimpleReplaceAnglicism;
import org.languagetool.rules.ca.SimpleReplaceBalearicRule;
import org.languagetool.rules.ca.SimpleReplaceDNVRule;
import org.languagetool.rules.ca.SimpleReplaceDiacriticsIEC;
import org.languagetool.rules.ca.SimpleReplaceRule;
import org.languagetool.rules.ca.SimpleReplaceVerbsRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.ca.CatalanSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.ca.CatalanTagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.ca.CatalanHybridDisambiguator;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.ca.CatalanWordTokenizer;

public class Catalan
extends Language {
    private static final Language DEFAULT_CATALAN = new Catalan();

    public String getName() {
        return "Catalan";
    }

    public String[] getCountries() {
        return new String[]{"ES"};
    }

    public String getShortCode() {
        return "ca";
    }

    public Language getDefaultLanguageVariant() {
        return DEFAULT_CATALAN;
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Ricard Roca"), new Contributor("Jaume Ortol\u00e0")};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages, Example.wrong((String)"A parer seu<marker> ,</marker> no era veritat."), Example.fixed((String)"A parer seu<marker>,</marker> no era veritat.")), new DoublePunctuationRule(messages), new CatalanUnpairedBracketsRule(messages, this), new UppercaseSentenceStartRule(messages, (Language)this, Example.wrong((String)"Preus de venda al p\u00fablic. <marker>han</marker> pujat molt."), Example.fixed((String)"Preus de venda al p\u00fablic. <marker>Han</marker> pujat molt.")), new MultipleWhitespaceRule(messages, (Language)this), new LongSentenceRule(messages, userConfig, 45, true, true), new CatalanWordRepeatRule(messages, this), new MorfologikCatalanSpellerRule(messages, this, userConfig, altLanguages), new CatalanUnpairedQuestionMarksRule(messages, this), new CatalanUnpairedExclamationMarksRule(messages, this), new CatalanWrongWordInContextRule(messages), new SimpleReplaceVerbsRule(messages, this), new SimpleReplaceBalearicRule(messages), new SimpleReplaceRule(messages), new ReplaceOperationNamesRule(messages, this), new SimpleReplaceDNVRule(messages, this), new SimpleReplaceDiacriticsIEC(messages), new SimpleReplaceAnglicism(messages), new PronomFebleDuplicateRule(messages), new CheckCaseRule(messages, this), new SimpleReplaceAdverbsMent(messages)});
    }

    @NotNull
    public Tagger createDefaultTagger() {
        return new CatalanTagger(this);
    }

    @Nullable
    public Synthesizer createDefaultSynthesizer() {
        return new CatalanSynthesizer(this);
    }

    public SentenceTokenizer createDefaultSentenceTokenizer() {
        return new SRXSentenceTokenizer((Language)this);
    }

    public Disambiguator createDefaultDisambiguator() {
        return new CatalanHybridDisambiguator();
    }

    public Tokenizer createDefaultWordTokenizer() {
        return new CatalanWordTokenizer();
    }

    public String getOpeningDoubleQuote() {
        return "\u00ab";
    }

    public String getClosingDoubleQuote() {
        return "\u00bb";
    }

    public String getOpeningSingleQuote() {
        return "\u2018";
    }

    public String getClosingSingleQuote() {
        return "\u2019";
    }

    public boolean isAdvancedTypographyEnabled() {
        return true;
    }

    public String toAdvancedTypography(String input) {
        String output = super.toAdvancedTypography(input);
        output = output.replaceAll("(\\b[lmnstdLMNSTD])'", "$1\u2019");
        output = output.replaceAll("(\\b[lmnstdLMNSTD])\u2019\"", "$1\u2019" + this.getOpeningDoubleQuote());
        output = output.replaceAll("(\\b[lmnstdLMNSTD])\u2019'", "$1\u2019" + this.getOpeningSingleQuote());
        return output;
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.ActivelyMaintained;
    }

    protected int getPriorityForId(String id) {
        switch (id) {
            case "CA_SIMPLE_REPLACE_BALEARIC": {
                return 100;
            }
            case "INCORRECT_EXPRESSIONS": {
                return 50;
            }
            case "PERSONATGES_FAMOSOS": {
                return 50;
            }
            case "MOTS_NO_SEPARATS": {
                return 40;
            }
            case "REPETEAD_ELEMENTS": {
                return 40;
            }
            case "ESPAIS_SOBRANTS": {
                return 40;
            }
            case "CONCORDANCES_CASOS_PARTICULARS": {
                return 30;
            }
            case "GERUNDI_PERD_T": {
                return 30;
            }
            case "CONFUSIONS": {
                return 30;
            }
            case "CA_SIMPLE_REPLACE": {
                return 30;
            }
            case "INCORRECT_WORDS_IN_CONTEXT": {
                return 30;
            }
            case "CONFUSIONS_ACCENT": {
                return 20;
            }
            case "DIACRITICS": {
                return 20;
            }
            case "MOTS_SENSE_GUIONETS": {
                return 20;
            }
            case "PASSAT_PERIFRASTIC": {
                return 20;
            }
            case "PRONOMS_FEBLES_SOLTS2": {
                return 20;
            }
            case "ORDINALS": {
                return 20;
            }
            case "SUPER": {
                return 20;
            }
            case "ACCENTUATION_CHECK": {
                return 10;
            }
            case "CONCORDANCES_NUMERALS": {
                return 10;
            }
            case "HAVER_SENSE_HAC": {
                return 10;
            }
            case "CASING": {
                return 10;
            }
            case "CONCORDANCES_DET_NOM": {
                return 5;
            }
            case "DET_GN": {
                return 5;
            }
            case "VENIR_NO_REFLEXIU": {
                return 5;
            }
            case "PEL_QUE": {
                return -10;
            }
            case "REGIONAL_VERBS": {
                return -10;
            }
            case "PRONOMS_FEBLES_SOLTS": {
                return -10;
            }
            case "AGREEMENT_POSTPONED_ADJ": {
                return -15;
            }
            case "FALTA_COMA_FRASE_CONDICIONAL": {
                return -20;
            }
            case "MUNDAR": {
                return -50;
            }
            case "NOMBRES_ROMANS": {
                return -90;
            }
            case "MORFOLOGIK_RULE_CA_ES": {
                return -100;
            }
            case "EXIGEIX_ACCENTUACIO_VALENCIANA": {
                return -120;
            }
            case "PHRASE_REPETITION": {
                return -150;
            }
            case "SUBSTANTIUS_JUNTS": {
                return -150;
            }
            case "FALTA_ELEMENT_ENTRE_VERBS": {
                return -200;
            }
            case "UPPERCASE_SENTENCE_START": {
                return -500;
            }
            case "MAJUSCULA_IMPROBABLE": {
                return -500;
            }
            case "ELA_GEMINADA_WIKI": {
                return -200;
            }
        }
        return super.getPriorityForId(id);
    }
}

