/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.spelling.morfologik.MorfologikSpellerRule;
import org.languagetool.tagging.ca.CatalanTagger;

public final class MorfologikCatalanSpellerRule
extends MorfologikSpellerRule {
    private String dictFilename;
    private static final String SPELLING_FILE = "/ca/spelling.txt";
    private static final Pattern PARTICULA_INICIAL = Pattern.compile("^(els?|als?|pels?|dels?|de|per|uns?|una|unes|la|les|[tms]eus?) (..+)$", 66);
    private static final Pattern APOSTROF_INICI_VERBS = Pattern.compile("^([lnmts])(h?[aeiou\u00e0\u00e9\u00e8\u00ed\u00f2\u00f3\u00fa].*)$", 66);
    private static final Pattern APOSTROF_INICI_NOM_SING = Pattern.compile("^([ld])(h?[aeiou\u00e0\u00e9\u00e8\u00ed\u00f2\u00f3\u00fa].+)$", 66);
    private static final Pattern APOSTROF_INICI_NOM_PLURAL = Pattern.compile("^(d)(h?[aeiou\u00e0\u00e9\u00e8\u00ed\u00f2\u00f3\u00fa].+)$", 66);
    private static final Pattern APOSTROF_FINAL = Pattern.compile("^(.+[aei])(l|ls|m|n|ns|s|t)$", 66);
    private static final Pattern GUIONET_FINAL = Pattern.compile("^([\\p{L}\u00b7]+)[\u2019']?(hi|ho|la|les|li|lo|los|me|ne|nos|se|te|vos)$", 66);
    private static final Pattern VERB_INDSUBJ = Pattern.compile("V.[SI].*");
    private static final Pattern NOM_SING = Pattern.compile("V.[NG].*|V.P..S..|N..[SN].*|A...[SN].|PX..S...|DD..S.");
    private static final Pattern NOM_PLURAL = Pattern.compile("V.P..P..|N..[PN].*|A...[PN].|PX..P...|DD..P.");
    private static final Pattern VERB_INFGERIMP = Pattern.compile("V.[NGM].*");
    private CatalanTagger tagger;

    public MorfologikCatalanSpellerRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages) throws IOException {
        super(messages, language, userConfig, altLanguages);
        this.setIgnoreTaggedWords();
        this.tagger = new CatalanTagger(language);
        this.dictFilename = "/ca/" + language.getShortCodeWithCountryAndVariant() + ".dict";
    }

    public String getFileName() {
        return this.dictFilename;
    }

    public String getSpellingFileName() {
        return SPELLING_FILE;
    }

    public String getId() {
        return "MORFOLOGIK_RULE_CA_ES";
    }

    public boolean useInOffice() {
        return true;
    }

    protected List<String> orderSuggestions(List<String> suggestions, String word) {
        ArrayList<String> newSuggestions = new ArrayList<String>();
        for (String suggestion : suggestions) {
            if (PARTICULA_INICIAL.matcher(suggestion).matches()) {
                newSuggestions.add(0, suggestion);
                continue;
            }
            newSuggestions.add(suggestion);
        }
        return newSuggestions;
    }

    protected List<String> getAdditionalTopSuggestions(List<String> suggestions, String word) throws IOException {
        String suggestion = "";
        suggestion = this.findSuggestion(suggestion, word, APOSTROF_INICI_VERBS, VERB_INDSUBJ, 2, "'");
        suggestion = this.findSuggestion(suggestion, word, APOSTROF_INICI_NOM_SING, NOM_SING, 2, "'");
        suggestion = this.findSuggestion(suggestion, word, APOSTROF_INICI_NOM_PLURAL, NOM_PLURAL, 2, "'");
        if (!word.endsWith("as") && !word.endsWith("et")) {
            suggestion = this.findSuggestion(suggestion, word, APOSTROF_FINAL, VERB_INFGERIMP, 1, "'");
        }
        if (!(suggestion = this.findSuggestion(suggestion, word, GUIONET_FINAL, VERB_INFGERIMP, 1, "-")).isEmpty()) {
            return Collections.singletonList(suggestion);
        }
        return Collections.emptyList();
    }

    private String findSuggestion(String suggestion, String word, Pattern wordPattern, Pattern postagPattern, int suggestionPosition, String separator) throws IOException {
        if (!suggestion.isEmpty()) {
            return suggestion;
        }
        Matcher matcher = wordPattern.matcher(word);
        if (matcher.matches()) {
            String newSuggestion = matcher.group(suggestionPosition);
            if (this.matchPostagRegexp(this.tagger.tag(Arrays.asList(newSuggestion)).get(0), postagPattern)) {
                return matcher.group(1) + separator + matcher.group(2);
            }
        }
        return "";
    }

    private boolean matchPostagRegexp(AnalyzedTokenReadings aToken, Pattern pattern) {
        for (AnalyzedToken analyzedToken : aToken) {
            Matcher m;
            String posTag = analyzedToken.getPOSTag();
            if (posTag == null) {
                posTag = "UNKNOWN";
            }
            if (!(m = pattern.matcher(posTag)).matches()) continue;
            return true;
        }
        return false;
    }
}

