/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.synthesis.ca;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import morfologik.stemming.IStemmer;
import morfologik.stemming.WordData;
import org.languagetool.AnalyzedToken;
import org.languagetool.Language;
import org.languagetool.synthesis.BaseSynthesizer;

public class CatalanSynthesizer
extends BaseSynthesizer {
    private static final Pattern pMS = Pattern.compile("(N|A.).[MC][SN].*|V.P.*SM.?");
    private static final Pattern pFS = Pattern.compile("(N|A.).[FC][SN].*|V.P.*SF.?");
    private static final Pattern pMP = Pattern.compile("(N|A.).[MC][PN].*|V.P.*PM.?");
    private static final Pattern pFP = Pattern.compile("(N|A.).[FC][PN].*|V.P.*PF.?");
    private static final Pattern pPrep = Pattern.compile("(DT)(.*)");
    private static final Pattern pMascYes = Pattern.compile("h?[aeiou\u00e0\u00e8\u00e9\u00ed\u00f2\u00f3\u00fa].*", 66);
    private static final Pattern pMascNo = Pattern.compile("h?[ui][aeio\u00e0\u00e8\u00e9\u00f3\u00f2].+", 66);
    private static final Pattern pFemYes = Pattern.compile("h?[aeo\u00e0\u00e8\u00e9\u00ed\u00f2\u00f3\u00fa].*|h?[ui][^aeiou\u00e0\u00e8\u00e9\u00ed\u00f2\u00f3\u00fa\u00fc\u00ef]+[aeiou][ns]?|urbs", 66);
    private static final Pattern pFemNo = Pattern.compile("host|ira|inxa", 66);
    private static final Pattern pVerb = Pattern.compile("V.*[CVBXYZ0123456]");

    public CatalanSynthesizer(Language lang) {
        super("/ca/ca-ES-valencia_synth.dict", "/ca/ca-ES-valencia_tags.txt", lang);
    }

    public String[] synthesize(AnalyzedToken token, String posTag) throws IOException {
        this.initPossibleTags();
        boolean addDt = false;
        String prep = "";
        Matcher mPrep = pPrep.matcher(posTag);
        if (mPrep.matches()) {
            addDt = true;
            if (mPrep.groupCount() > 1) {
                prep = mPrep.group(2);
            }
        }
        Pattern p = addDt ? Pattern.compile("N.*|A.*|V.P.*|PX.") : Pattern.compile(posTag);
        ArrayList<String> results = new ArrayList<String>();
        IStemmer synthesizer = this.createStemmer();
        for (String tag : this.possibleTags) {
            Matcher m = p.matcher(tag);
            if (!m.matches()) continue;
            if (addDt) {
                this.lookupWithEl(token.getLemma(), tag, prep, results, synthesizer);
                continue;
            }
            this.lookup(token.getLemma(), tag, results);
        }
        if (results.isEmpty() && posTag.startsWith("V")) {
            if (posTag.endsWith("V") || posTag.endsWith("B")) {
                this.lookup(token.getLemma(), posTag.substring(0, posTag.length() - 1).concat("Z"), results);
            }
            if (results.isEmpty() && !posTag.endsWith("0")) {
                this.lookup(token.getLemma(), posTag.substring(0, posTag.length() - 1).concat("0"), results);
            }
            if (results.isEmpty()) {
                return this.synthesize(token, posTag.substring(0, posTag.length() - 1).concat("."), true);
            }
        }
        return results.toArray(new String[0]);
    }

    public String[] synthesize(AnalyzedToken token, String posTag, boolean posTagRegExp) throws IOException {
        if (posTagRegExp) {
            Matcher mVerb;
            Pattern p;
            this.initPossibleTags();
            try {
                p = Pattern.compile(posTag);
            }
            catch (PatternSyntaxException e) {
                System.err.println("WARNING: Error trying to synthesize POS tag " + posTag + " from token " + token.getToken() + ": " + e.getMessage());
                return null;
            }
            ArrayList results = new ArrayList();
            for (String tag : this.possibleTags) {
                Matcher m = p.matcher(tag);
                if (!m.matches()) continue;
                this.lookup(token.getLemma(), tag, results);
            }
            if (results.isEmpty() && (mVerb = pVerb.matcher(posTag)).matches()) {
                Matcher m;
                if (!posTag.endsWith("0")) {
                    p = Pattern.compile(posTag.substring(0, posTag.length() - 1).concat("0"));
                    for (String tag : this.possibleTags) {
                        m = p.matcher(tag);
                        if (!m.matches()) continue;
                        this.lookup(token.getLemma(), tag, results);
                    }
                }
                if (results.isEmpty()) {
                    p = Pattern.compile(posTag.substring(0, posTag.length() - 1).concat("."));
                    for (String tag : this.possibleTags) {
                        m = p.matcher(tag);
                        if (!m.matches()) continue;
                        this.lookup(token.getLemma(), tag, results);
                    }
                }
            }
            return results.toArray(new String[0]);
        }
        return this.synthesize(token, posTag);
    }

    private void lookupWithEl(String lemma, String posTag, String prep, List<String> results, IStemmer synthesizer) {
        List wordForms = synthesizer.lookup((CharSequence)(lemma + "|" + posTag));
        Matcher mMS = pMS.matcher(posTag);
        Matcher mFS = pFS.matcher(posTag);
        Matcher mMP = pMP.matcher(posTag);
        Matcher mFP = pFP.matcher(posTag);
        for (WordData wd : wordForms) {
            String word = wd.getStem().toString();
            if (mMS.matches()) {
                Matcher mMascYes = pMascYes.matcher(word);
                Matcher mMascNo = pMascNo.matcher(word);
                if (prep.equals("per")) {
                    if (mMascYes.matches() && !mMascNo.matches()) {
                        results.add("per l'" + word);
                    } else {
                        results.add("pel " + word);
                    }
                } else if (prep.isEmpty()) {
                    if (mMascYes.matches() && !mMascNo.matches()) {
                        results.add("l'" + word);
                    } else {
                        results.add("el " + word);
                    }
                } else if (mMascYes.matches() && !mMascNo.matches()) {
                    results.add(prep + " l'" + word);
                } else {
                    results.add(prep + "l " + word);
                }
            }
            if (mFS.matches()) {
                Matcher mFemYes = pFemYes.matcher(word);
                Matcher mFemNo = pFemNo.matcher(word);
                if (prep.equals("per")) {
                    if (mFemYes.matches() && !mFemNo.matches()) {
                        results.add("per l'" + word);
                    } else {
                        results.add("per la " + word);
                    }
                } else if (prep.isEmpty()) {
                    if (mFemYes.matches() && !mFemNo.matches()) {
                        results.add("l'" + word);
                    } else {
                        results.add("la " + word);
                    }
                } else if (mFemYes.matches() && !mFemNo.matches()) {
                    results.add(prep + " l'" + word);
                } else {
                    results.add(prep + " la " + word);
                }
            }
            if (mMP.matches()) {
                if (prep.equals("per")) {
                    results.add("pels " + word);
                } else if (prep.isEmpty()) {
                    results.add("els " + word);
                } else {
                    results.add(prep + "ls " + word);
                }
            }
            if (!mFP.matches()) continue;
            if (prep.isEmpty()) {
                results.add("les " + word);
                continue;
            }
            results.add(prep + " les " + word);
        }
    }
}

