/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.ITSIssueType;

public class SimpleReplaceDiacriticsTraditional
extends AbstractSimpleReplaceRule {
    private static final Map<String, List<String>> wrongWords = SimpleReplaceDiacriticsTraditional.load((String)"/ca/replace_diacritics_traditional.txt");
    private static final Locale CA_LOCALE = new Locale("CA");

    protected Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public SimpleReplaceDiacriticsTraditional(ResourceBundle messages) throws IOException {
        super(messages);
        super.setCategory(new Category(new CategoryId("DIACRITICS_TRADITIONAL"), "Z) Accents diacr\u00edtics tradicionals"));
        super.setLocQualityIssueType(ITSIssueType.Misspelling);
        super.setDefaultOn();
        this.setCheckLemmas(false);
    }

    public final String getId() {
        return "CA_SIMPLEREPLACE_DIACRITICS_TRADITIONAL";
    }

    public String getDescription() {
        return "Falta l'accent diacr\u00edtic segons les normes tradicionals.";
    }

    public String getShort() {
        return "Falta l'accent.";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return "Falta l'accent diacr\u00edtic.";
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Locale getLocale() {
        return CA_LOCALE;
    }
}

