/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.synthesis.ca.CatalanSynthesizer;

public class ReplaceOperationNamesRule
extends AbstractSimpleReplaceRule {
    private static final Map<String, List<String>> wrongWords = ReplaceOperationNamesRule.load((String)"/ca/replace_operationnames.txt");
    private static final Locale CA_LOCALE = new Locale("CA");
    private static final CatalanSynthesizer synth = new CatalanSynthesizer();
    private static final Pattern PrevToken_POS = Pattern.compile("D[^R].*|PX.*|SPS00|SENT_START");
    private static final Pattern PrevToken_POS_Excep = Pattern.compile("RG_anteposat|N.*|CC|_PUNCT.*|_loc_unavegada|RN");
    private static final Pattern NextToken_POS_Excep = Pattern.compile("N.*");
    private static final Pattern PUNTUACIO = Pattern.compile("PUNCT.*|SENT_START");
    private static final Pattern DETERMINANT = Pattern.compile("D[^R].M.*");

    protected Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public ReplaceOperationNamesRule(ResourceBundle messages) throws IOException {
        super(messages);
        super.setLocQualityIssueType(ITSIssueType.Style);
        super.setCategory(new Category(new CategoryId("FORMES_SECUNDARIES"), "C8) Formes secund\u00e0ries"));
    }

    public final String getId() {
        return "NOMS_OPERACIONS";
    }

    public String getDescription() {
        return "Noms d'operaci\u00f3 t\u00e8cnica: buidat/buidatge";
    }

    public String getShort() {
        return "Forma preferible";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return "Si \u00e9s el nom d'una operaci\u00f3 t\u00e8cnica, val m\u00e9s usar una altra forma.";
    }

    public Locale getLocale() {
        return CA_LOCALE;
    }

    public final RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        for (int i = 1; i < tokens.length; ++i) {
            List<String> replacementLemmas = null;
            String token = tokens[i].getToken().toLowerCase();
            if (token.length() > 3 && token.endsWith("s")) {
                token = token.substring(0, token.length() - 1);
            }
            if (!wrongWords.containsKey(token)) continue;
            replacementLemmas = wrongWords.get(token);
            if (token.equals("duplicat") && tokens[i - 1].getToken().equalsIgnoreCase("per") || i + 1 < tokens.length && this.matchPostagRegexp(tokens[i - 1], PUNTUACIO) && this.matchPostagRegexp(tokens[i + 1], DETERMINANT) || tokens[i].hasPosTag("_GV_") || i + 1 < tokens.length && (tokens[i + 1].hasLemma("per") || tokens[i + 1].hasLemma("com") || tokens[i + 1].hasLemma("des") || tokens[i + 1].hasLemma("amb") || this.matchPostagRegexp(tokens[i + 1], NextToken_POS_Excep)) || !this.matchPostagRegexp(tokens[i - 1], PrevToken_POS) || this.matchPostagRegexp(tokens[i - 1], PrevToken_POS_Excep) || replacementLemmas == null) continue;
            ArrayList<String> possibleReplacements = new ArrayList<String>();
            String[] synthesized = null;
            if (!tokens[i].getToken().toLowerCase().endsWith("s")) {
                possibleReplacements.addAll(replacementLemmas);
            } else {
                for (String replacementLemma : replacementLemmas) {
                    try {
                        synthesized = synth.synthesize(new AnalyzedToken(replacementLemma, "NCMS000", replacementLemma), "NC.P.*");
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Could not synthesize: " + replacementLemma + " with tag NC.P.*.", e);
                    }
                    possibleReplacements.addAll(Arrays.asList(synthesized));
                }
            }
            if (possibleReplacements.size() <= 0) continue;
            RuleMatch potentialRuleMatch = this.createRuleMatch(tokens[i], possibleReplacements);
            ruleMatches.add(potentialRuleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private boolean matchPostagRegexp(AnalyzedTokenReadings aToken, Pattern pattern) {
        boolean matches = false;
        for (AnalyzedToken analyzedToken : aToken) {
            Matcher m;
            String posTag = analyzedToken.getPOSTag();
            if (posTag == null) {
                posTag = "UNKNOWN";
            }
            if (!(m = pattern.matcher(posTag)).matches()) continue;
            matches = true;
            break;
        }
        return matches;
    }
}

