/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.Contributor;
import org.languagetool.language.GeneralCatalan;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.LongSentenceRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.ca.AccentuationCheckRule;
import org.languagetool.rules.ca.CatalanUnpairedBracketsRule;
import org.languagetool.rules.ca.CatalanUnpairedExclamationMarksRule;
import org.languagetool.rules.ca.CatalanUnpairedQuestionMarksRule;
import org.languagetool.rules.ca.CatalanWordRepeatRule;
import org.languagetool.rules.ca.CatalanWrongWordInContextRule;
import org.languagetool.rules.ca.ComplexAdjectiveConcordanceRule;
import org.languagetool.rules.ca.MorfologikCatalanSpellerRule;
import org.languagetool.rules.ca.ReflexiveVerbsRule;
import org.languagetool.rules.ca.ReplaceOperationNamesRule;
import org.languagetool.rules.ca.SimpleReplaceRule;
import org.languagetool.rules.ca.SimpleReplaceVerbsRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.ca.CatalanSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.ca.CatalanTagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.ca.CatalanHybridDisambiguator;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.ca.CatalanWordTokenizer;

public class Catalan
extends Language {
    private Tagger tagger;
    private SentenceTokenizer sentenceTokenizer;
    private Tokenizer wordTokenizer;
    private Synthesizer synthesizer;
    private Disambiguator disambiguator;
    private static final Language GENERAL_CATALAN = new GeneralCatalan();

    public String getName() {
        return "Catalan";
    }

    public String[] getCountries() {
        return new String[0];
    }

    public String getShortName() {
        return "ca";
    }

    public Language getDefaultLanguageVariant() {
        return GENERAL_CATALAN;
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Ricard Roca"), new Contributor("Jaume Ortol\u00e0")};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages), new DoublePunctuationRule(messages), new CatalanUnpairedBracketsRule(messages, this), new UppercaseSentenceStartRule(messages, (Language)this), new MultipleWhitespaceRule(messages, (Language)this), new LongSentenceRule(messages), new CatalanWordRepeatRule(messages, this), new MorfologikCatalanSpellerRule(messages, this), new CatalanUnpairedQuestionMarksRule(messages, this), new CatalanUnpairedExclamationMarksRule(messages, this), new AccentuationCheckRule(messages), new ComplexAdjectiveConcordanceRule(messages), new CatalanWrongWordInContextRule(messages), new ReflexiveVerbsRule(messages), new SimpleReplaceVerbsRule(messages), new SimpleReplaceRule(messages), new ReplaceOperationNamesRule(messages)});
    }

    public Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new CatalanTagger();
        }
        return this.tagger;
    }

    public Synthesizer getSynthesizer() {
        if (this.synthesizer == null) {
            this.synthesizer = new CatalanSynthesizer();
        }
        return this.synthesizer;
    }

    public SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public Disambiguator getDisambiguator() {
        if (this.disambiguator == null) {
            this.disambiguator = new CatalanHybridDisambiguator();
        }
        return this.disambiguator;
    }

    public Tokenizer getWordTokenizer() {
        if (this.wordTokenizer == null) {
            this.wordTokenizer = new CatalanWordTokenizer();
        }
        return this.wordTokenizer;
    }
}

