/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.Category;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.synthesis.ca.CatalanSynthesizer;
import org.languagetool.tagging.ca.CatalanTagger;
import org.languagetool.tools.StringTools;

public class SimpleReplaceVerbsRule
extends Rule {
    private static final String FILE_NAME = "/ca/replace_verbs.txt";
    private static final Locale CA_LOCALE = new Locale("CA");
    private static final String FILE_ENCODING = "utf-8";
    protected final Map<String, List<String>> wrongWords;
    protected boolean ignoreTaggedWords = true;
    private static final Pattern[] desinencies_1conj = new Pattern[2];
    private final CatalanTagger tagger;
    private final CatalanSynthesizer synth;

    public final String getFileName() {
        return FILE_NAME;
    }

    public String getEncoding() {
        return FILE_ENCODING;
    }

    public SimpleReplaceVerbsRule(ResourceBundle messages) throws IOException {
        super.setLocQualityIssueType(ITSIssueType.Misspelling);
        super.setCategory(new Category("Errors ortogr\u00e0fics"));
        this.wrongWords = this.loadWords(JLanguageTool.getDataBroker().getFromRulesDirAsStream(this.getFileName()));
        this.tagger = new CatalanTagger();
        this.synth = new CatalanSynthesizer();
        SimpleReplaceVerbsRule.desinencies_1conj[0] = Pattern.compile("(.+?)(a|\u00e0|ada|ades|am|ant|ar|ara|ar\u00e0|aran|ar\u00e0s|ar\u00e9|arem|\u00e0rem|aren|ares|areu|\u00e0reu|aria|ar\u00edem|arien|aries|ar\u00edeu|\u00e0s|\u00e0ssem|assen|asses|\u00e0sseu|\u00e0ssim|assin|assis|\u00e0ssiu|at|ats|au|ava|\u00e0vem|aven|aves|\u00e0veu|e|em|en|es|\u00e9s|\u00e9ssem|essen|esses|\u00e9sseu|\u00e9ssim|essin|essis|\u00e9ssiu|eu|i|\u00ed|in|is|o)");
        SimpleReplaceVerbsRule.desinencies_1conj[1] = Pattern.compile("(.+)(a|\u00e0|ada|ades|am|ant|ar|ara|ar\u00e0|aran|ar\u00e0s|ar\u00e9|arem|\u00e0rem|aren|ares|areu|\u00e0reu|aria|ar\u00edem|arien|aries|ar\u00edeu|\u00e0s|\u00e0ssem|assen|asses|\u00e0sseu|\u00e0ssim|assin|assis|\u00e0ssiu|at|ats|au|ava|\u00e0vem|aven|aves|\u00e0veu|e|em|en|es|\u00e9s|\u00e9ssem|essen|esses|\u00e9sseu|\u00e9ssim|essin|essis|\u00e9ssiu|eu|i|\u00ed|in|is|o)");
    }

    public final String getId() {
        return "CA_SIMPLE_REPLACE_VERBS";
    }

    public String getDescription() {
        return "Detecta verbs incorrectes i proposa suggeriments de canvi";
    }

    public String getShort() {
        return "Verb incorrecte";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return "Verb incorrecte.";
    }

    public Locale getLocale() {
        return CA_LOCALE;
    }

    public final RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        AnalyzedTokenReadings[] tokens;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        for (AnalyzedTokenReadings tokenReadings : tokens = sentence.getTokensWithoutWhitespace()) {
            String originalTokenStr = tokenReadings.getToken();
            if (this.ignoreTaggedWords && tokenReadings.isTagged()) continue;
            String tokenString = originalTokenStr.toLowerCase(this.getLocale());
            AnalyzedTokenReadings analyzedTokenReadings = null;
            String infinitive = null;
            for (int i = 0; i < 2 && analyzedTokenReadings == null; ++i) {
                List<String> wordAsArray;
                List<AnalyzedTokenReadings> analyzedTokenReadingsList;
                Matcher m = desinencies_1conj[i].matcher(tokenString);
                if (!m.matches()) continue;
                String lexeme = m.group(1);
                String desinence = m.group(2);
                if (desinence.startsWith("e") || desinence.startsWith("\u00e9") || desinence.startsWith("i") || desinence.startsWith("\u00ef")) {
                    if (lexeme.endsWith("c")) {
                        lexeme = lexeme.substring(0, lexeme.length() - 1).concat("\u00e7");
                    } else if (lexeme.endsWith("qu")) {
                        lexeme = lexeme.substring(0, lexeme.length() - 2).concat("c");
                    } else if (lexeme.endsWith("g")) {
                        lexeme = lexeme.substring(0, lexeme.length() - 1).concat("j");
                    } else if (lexeme.endsWith("g\u00fc")) {
                        lexeme = lexeme.substring(0, lexeme.length() - 2).concat("gu");
                    }
                }
                if (!this.wrongWords.containsKey(infinitive = lexeme.concat("ar")) || (analyzedTokenReadingsList = this.tagger.tag(wordAsArray = Arrays.asList("cant".concat(desinence)))) == null) continue;
                analyzedTokenReadings = analyzedTokenReadingsList.get(0);
            }
            if (analyzedTokenReadings == null) continue;
            ArrayList<String> possibleReplacements = new ArrayList<String>();
            String[] synthesized = null;
            List<String> replacementInfinitives = this.wrongWords.get(infinitive);
            for (String replacementInfinitive : replacementInfinitives) {
                String[] parts = replacementInfinitive.split(" ");
                AnalyzedToken infinitiveAsAnTkn = new AnalyzedToken(parts[0], "V.*", parts[0]);
                for (AnalyzedToken analyzedToken : analyzedTokenReadings) {
                    for (String s : synthesized = this.synth.synthesize(infinitiveAsAnTkn, analyzedToken.getPOSTag())) {
                        for (int j = 1; j < parts.length; ++j) {
                            s = s.concat(" ").concat(parts[j]);
                        }
                        if (possibleReplacements.contains(s)) continue;
                        possibleReplacements.add(s);
                    }
                }
            }
            if (possibleReplacements.size() <= 0) continue;
            RuleMatch potentialRuleMatch = this.createRuleMatch(tokenReadings, possibleReplacements);
            ruleMatches.add(potentialRuleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private RuleMatch createRuleMatch(AnalyzedTokenReadings tokenReadings, List<String> replacements) {
        String tokenString = tokenReadings.getToken();
        int pos = tokenReadings.getStartPos();
        RuleMatch potentialRuleMatch = new RuleMatch((Rule)this, pos, pos + tokenString.length(), this.getMessage(tokenString, replacements), this.getShort());
        if (StringTools.startsWithUppercase((String)tokenString)) {
            for (int i = 0; i < replacements.size(); ++i) {
                replacements.set(i, StringTools.uppercaseFirstChar((String)replacements.get(i)));
            }
        }
        potentialRuleMatch.setSuggestedReplacements(replacements);
        return potentialRuleMatch;
    }

    private Map<String, List<String>> loadWords(InputStream stream) throws IOException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        try (Scanner scanner = new Scanner(stream, this.getEncoding());){
            while (scanner.hasNextLine()) {
                String[] wrongForms;
                String line = scanner.nextLine();
                if (line.length() < 1 || line.charAt(0) == '#') continue;
                String[] parts = line.split("=");
                if (parts.length != 2) {
                    throw new IOException("Format error in file " + JLanguageTool.getDataBroker().getFromRulesDirAsUrl(this.getFileName()) + ", line: " + line);
                }
                String[] replacements = parts[1].split("\\|");
                for (String wrongForm : wrongForms = parts[0].split("\\|")) {
                    map.put(wrongForm, Arrays.asList(replacements));
                }
            }
        }
        return map;
    }

    public void reset() {
    }
}

