/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.ca;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.IStemmer;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.chunking.ChunkTag;
import org.languagetool.tagging.BaseTagger;
import org.languagetool.tagging.ManualTagger;
import org.languagetool.tools.StringTools;

public class CatalanTagger
extends BaseTagger {
    private static final String DICT_FILENAME = "/ca/catalan.dict";
    private static final String USER_DICT_FILENAME = "/ca/manual-tagger.txt";
    private volatile ManualTagger manualTagger;
    private static final Pattern ADJ_PART_FS = Pattern.compile("VMP00SF.|A[QO].[FC][SN].");
    private static final Pattern VERB = Pattern.compile("V.+");
    private static final Pattern PREFIXES_FOR_VERBS = Pattern.compile("(auto)(.+)", 66);

    public final String getFileName() {
        return DICT_FILENAME;
    }

    public String getManualAdditionsFileName() {
        return null;
    }

    public CatalanTagger() {
        this.setLocale(new Locale("ca"));
        this.dontTagLowercaseWithUppercase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeIfRequired() throws IOException {
        ManualTagger mTagger = this.manualTagger;
        if (mTagger == null) {
            CatalanTagger catalanTagger = this;
            synchronized (catalanTagger) {
                mTagger = this.manualTagger;
                if (mTagger == null) {
                    this.manualTagger = new ManualTagger(JLanguageTool.getDataBroker().getFromResourceDirAsStream(USER_DICT_FILENAME));
                }
            }
        }
    }

    public List<AnalyzedTokenReadings> tag(List<String> sentenceTokens) throws IOException {
        this.initializeIfRequired();
        ArrayList<AnalyzedTokenReadings> tokenReadings = new ArrayList<AnalyzedTokenReadings>();
        int pos = 0;
        DictionaryLookup dictLookup = new DictionaryLookup(this.getDictionary());
        for (String word : sentenceTokens) {
            boolean containsTypewriterApostrophe = false;
            if (word.length() > 1) {
                if (word.contains("'")) {
                    containsTypewriterApostrophe = true;
                }
                word = word.replace("\u2019", "'");
            }
            ArrayList<AnalyzedToken> l = new ArrayList<AnalyzedToken>();
            String lowerWord = word.toLowerCase(this.conversionLocale);
            boolean isLowercase = word.equals(lowerWord);
            boolean isMixedCase = StringTools.isMixedCase((String)word);
            List<AnalyzedToken> manualTaggerTokens = this.manualTagsAsAnalyzedTokenList(word, this.manualTagger.lookup(word));
            List<AnalyzedToken> manualLowerTaggerTokens = this.manualTagsAsAnalyzedTokenList(word, this.manualTagger.lookup(lowerWord));
            this.addTokens(manualTaggerTokens, l);
            if (manualTaggerTokens.isEmpty()) {
                this.addTokens(this.asAnalyzedTokenList(word, dictLookup.lookup((CharSequence)word)), l);
            }
            if (!isLowercase && !isMixedCase) {
                this.addTokens(manualLowerTaggerTokens, l);
                if (manualLowerTaggerTokens.isEmpty()) {
                    this.addTokens(this.asAnalyzedTokenList(word, dictLookup.lookup((CharSequence)lowerWord)), l);
                }
            }
            if (l.isEmpty() && !isMixedCase) {
                this.addTokens(this.additionalTags(word, (IStemmer)dictLookup), l);
            }
            if (l.isEmpty()) {
                l.add(new AnalyzedToken(word, null, null));
            }
            AnalyzedTokenReadings atr = new AnalyzedTokenReadings(l, pos);
            if (containsTypewriterApostrophe) {
                ArrayList<ChunkTag> listChunkTags = new ArrayList<ChunkTag>();
                listChunkTags.add(new ChunkTag("containsTypewriterApostrophe"));
                atr.setChunkTags(listChunkTags);
            }
            tokenReadings.add(atr);
            pos += word.length();
        }
        return tokenReadings;
    }

    protected List<AnalyzedToken> additionalTags(String word, IStemmer stemmer) {
        Matcher matcher;
        Matcher m;
        String posTag;
        List taggerTokens;
        DictionaryLookup dictLookup;
        try {
            dictLookup = new DictionaryLookup(this.getDictionary());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load Catalan dictionary from " + this.getFileName(), e);
        }
        ArrayList<AnalyzedToken> additionalTaggedTokens = new ArrayList<AnalyzedToken>();
        if (word.endsWith("ment")) {
            String lowerWord = word.toLowerCase(this.conversionLocale);
            String possibleAdj = lowerWord.replaceAll("^(.+)ment$", "$1");
            taggerTokens = this.asAnalyzedTokenList(possibleAdj, dictLookup.lookup((CharSequence)possibleAdj));
            for (AnalyzedToken taggerToken : taggerTokens) {
                posTag = taggerToken.getPOSTag();
                if (posTag == null || !(m = ADJ_PART_FS.matcher(posTag)).matches()) continue;
                additionalTaggedTokens.add(new AnalyzedToken(word, "RG", lowerWord));
                return additionalTaggedTokens;
            }
        }
        if ((matcher = PREFIXES_FOR_VERBS.matcher(word)).matches()) {
            String possibleVerb = matcher.group(2).toLowerCase();
            taggerTokens = this.asAnalyzedTokenList(possibleVerb, dictLookup.lookup((CharSequence)possibleVerb));
            for (AnalyzedToken taggerToken : taggerTokens) {
                posTag = taggerToken.getPOSTag();
                if (posTag == null || !(m = VERB.matcher(posTag)).matches()) continue;
                String lemma = matcher.group(1).toLowerCase().concat(taggerToken.getLemma());
                additionalTaggedTokens.add(new AnalyzedToken(word, posTag, lemma));
            }
            return additionalTaggedTokens;
        }
        if (word.contains("\u0140") || word.contains("\u013f")) {
            String lowerWord = word.toLowerCase(this.conversionLocale);
            String possibleWord = lowerWord.replaceAll("\u0140", "l\u00b7");
            List taggerTokens2 = this.asAnalyzedTokenList(word, dictLookup.lookup((CharSequence)possibleWord));
            return taggerTokens2;
        }
        return null;
    }

    private List<AnalyzedToken> manualTagsAsAnalyzedTokenList(String word, String[] lemmasAndTags) {
        ArrayList<AnalyzedToken> aTokenList = new ArrayList<AnalyzedToken>();
        if (lemmasAndTags != null) {
            for (int i = 0; i < lemmasAndTags.length - 1; i += 2) {
                AnalyzedToken aToken = new AnalyzedToken(word, lemmasAndTags[i + 1], lemmasAndTags[i]);
                aTokenList.add(aToken);
            }
        }
        return aTokenList;
    }

    private void addTokens(List<AnalyzedToken> taggedTokens, List<AnalyzedToken> l) {
        if (taggedTokens != null) {
            for (AnalyzedToken at : taggedTokens) {
                l.add(at);
            }
        }
    }
}

