/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.ca;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import morfologik.stemming.DictionaryLookup;
import org.languagetool.AnalyzedToken;
import org.languagetool.tagging.BaseTagger;

public class CatalanTagger
extends BaseTagger {
    private static final String DICT_FILENAME = "/ca/catalan.dict";
    private static final Pattern ADJ_PART_FS = Pattern.compile("VMP00SF.|A[QO].[FC][SN].");
    private static final Pattern VERB = Pattern.compile("V.+");
    private static final Pattern NOUN = Pattern.compile("NC.+");
    private static final Pattern PREFIXES_FOR_VERBS = Pattern.compile("(auto|re)(.+)", 66);

    public final String getFileName() {
        return DICT_FILENAME;
    }

    public CatalanTagger() {
        this.setLocale(new Locale("ca"));
        this.dontTagLowercaseWithUppercase();
    }

    public boolean existsWord(String word) throws IOException {
        String lowerWord;
        DictionaryLookup dictLookup = new DictionaryLookup(this.getDictionary());
        List posTagsFromDict = dictLookup.lookup((CharSequence)(lowerWord = word.toLowerCase(this.conversionLocale)));
        return !posTagsFromDict.isEmpty() || !(posTagsFromDict = dictLookup.lookup((CharSequence)word)).isEmpty();
    }

    public List<AnalyzedToken> additionalTags(String word) {
        Matcher matcher;
        Matcher m;
        String posTag;
        List taggerTokens;
        DictionaryLookup dictLookup;
        try {
            dictLookup = new DictionaryLookup(this.getDictionary());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load Catalan dictionary from " + this.getFileName(), e);
        }
        ArrayList<AnalyzedToken> additionalTaggedTokens = new ArrayList<AnalyzedToken>();
        if (word.endsWith("ment")) {
            String lowerWord = word.toLowerCase(this.conversionLocale);
            String possibleAdj = lowerWord.replaceAll("^(.+)ment$", "$1");
            taggerTokens = this.asAnalyzedTokenList(possibleAdj, dictLookup.lookup((CharSequence)possibleAdj));
            for (AnalyzedToken taggerToken : taggerTokens) {
                posTag = taggerToken.getPOSTag();
                if (posTag == null || !(m = ADJ_PART_FS.matcher(posTag)).matches()) continue;
                additionalTaggedTokens.add(new AnalyzedToken(word, "RG", lowerWord));
                return additionalTaggedTokens;
            }
        }
        if ((matcher = PREFIXES_FOR_VERBS.matcher(word)).matches()) {
            String possibleVerb = matcher.group(2).toLowerCase();
            taggerTokens = this.asAnalyzedTokenList(possibleVerb, dictLookup.lookup((CharSequence)possibleVerb));
            for (AnalyzedToken taggerToken : taggerTokens) {
                posTag = taggerToken.getPOSTag();
                if (posTag == null || !(m = VERB.matcher(posTag)).matches()) continue;
                String lemma = matcher.group(1).toLowerCase().concat(taggerToken.getLemma());
                additionalTaggedTokens.add(new AnalyzedToken(word, posTag, lemma));
            }
            return additionalTaggedTokens;
        }
        if (word.startsWith("ex")) {
            String lowerWord = word.toLowerCase(this.conversionLocale);
            String possibleNoun = lowerWord.replaceAll("^ex(.+)$", "$1");
            List taggerTokens2 = this.asAnalyzedTokenList(possibleNoun, dictLookup.lookup((CharSequence)possibleNoun));
            for (AnalyzedToken taggerToken : taggerTokens2) {
                Matcher m2;
                String posTag2 = taggerToken.getPOSTag();
                if (posTag2 == null || !(m2 = NOUN.matcher(posTag2)).matches()) continue;
                String lemma = "ex".concat(taggerToken.getLemma());
                additionalTaggedTokens.add(new AnalyzedToken(word, posTag2, lemma));
            }
            return additionalTaggedTokens;
        }
        return null;
    }
}

