/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.br;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.concurrent.ArrayBlockingQueue;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.language.Breton;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tools.StringTools;

public class TopoReplaceRule
extends Rule {
    public static final String BRETON_TOPO = "BR_TOPO";
    private static final String FILE_NAME = "/br/topo.txt";
    private static final String FILE_ENCODING = "utf-8";
    private static final Locale BR_LOCALE = new Locale("br");
    private final List<Map<String, String>> wrongWords;
    private final Tokenizer wordTokenizer = new Breton().getWordTokenizer();

    public final String getFileName() {
        return FILE_NAME;
    }

    public TopoReplaceRule(ResourceBundle messages) throws IOException {
        super(messages);
        super.setCategory(Categories.MISC.getCategory(messages));
        this.wrongWords = this.loadWords(JLanguageTool.getDataBroker().getFromRulesDirAsStream(this.getFileName()));
    }

    public final String getId() {
        return BRETON_TOPO;
    }

    public String getDescription() {
        return "anvio\u00f9-lec\u2019h e brezhoneg";
    }

    public String getShort() {
        return "anvio\u00f9 lec\u2019h";
    }

    public String getSuggestion() {
        return " zo un anv lec\u2019h gallek. Ha fellout a rae deoc\u2019h skriva\u00f1 ";
    }

    public String getSuggestionsSeparator() {
        return " pe ";
    }

    public boolean isCaseSensitive() {
        return true;
    }

    public Locale getLocale() {
        return BR_LOCALE;
    }

    public String getEncoding() {
        return FILE_ENCODING;
    }

    protected Tokenizer getWordTokenizer() {
        return this.wordTokenizer;
    }

    public List<Map<String, String>> getWrongWords() {
        return this.wrongWords;
    }

    private List<Map<String, String>> loadWords(InputStream stream) throws IOException {
        ArrayList list = new ArrayList();
        InputStreamReader isr = new InputStreamReader(stream, this.getEncoding());
        Object object = null;
        try (BufferedReader bufferedReader = new BufferedReader(isr);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                String[] wrongForms;
                if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
                String[] parts = line.split("=");
                if (parts.length != 2) {
                    throw new IOException("Format error in file " + JLanguageTool.getDataBroker().getFromRulesDirAsUrl(this.getFileName()) + ", line: " + line);
                }
                for (String wrongForm : wrongForms = parts[0].split("\\|")) {
                    int wordCount = 0;
                    List tokens = this.getWordTokenizer().tokenize(wrongForm);
                    for (String token : tokens) {
                        if (StringTools.isWhitespace((String)token)) continue;
                        ++wordCount;
                    }
                    for (int i = list.size(); i < wordCount; ++i) {
                        list.add(new HashMap());
                    }
                    ((Map)list.get(wordCount - 1)).put(wrongForm, parts[1]);
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (isr != null) {
                if (object != null) {
                    try {
                        isr.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    isr.close();
                }
            }
        }
        ArrayList result = new ArrayList();
        for (Map map : list) {
            result.add(Collections.unmodifiableMap(map));
        }
        return Collections.unmodifiableList(result);
    }

    private void addToQueue(AnalyzedTokenReadings token, Queue<AnalyzedTokenReadings> prevTokens) {
        boolean inserted = prevTokens.offer(token);
        if (!inserted) {
            prevTokens.poll();
            prevTokens.offer(token);
        }
    }

    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        ArrayBlockingQueue<AnalyzedTokenReadings> prevTokens = new ArrayBlockingQueue<AnalyzedTokenReadings>(this.wrongWords.size());
        block0: for (int i = 1; i < tokens.length; ++i) {
            this.addToQueue(tokens[i], prevTokens);
            StringBuilder sb = new StringBuilder();
            ArrayList<String> variants = new ArrayList<String>();
            ArrayList<AnalyzedTokenReadings> prevTokensList = new ArrayList<AnalyzedTokenReadings>(prevTokens);
            for (int j = prevTokensList.size() - 1; j >= 0; --j) {
                if (j != prevTokensList.size() - 1 && ((AnalyzedTokenReadings)prevTokensList.get(j + 1)).isWhitespaceBefore()) {
                    sb.insert(0, " ");
                }
                sb.insert(0, ((AnalyzedTokenReadings)prevTokensList.get(j)).getToken());
                variants.add(0, sb.toString());
            }
            int len = variants.size();
            for (int j = 0; j < len; ++j) {
                String crtMatch;
                int crtWordCount = len - j;
                if (((AnalyzedTokenReadings)prevTokensList.get(len - crtWordCount)).isImmunized()) continue;
                String crt = (String)variants.get(j);
                String string = crtMatch = this.isCaseSensitive() ? this.wrongWords.get(crtWordCount - 1).get(crt) : this.wrongWords.get(crtWordCount - 1).get(crt.toLowerCase(this.getLocale()));
                if (crtMatch == null) continue;
                List<String> replacements = Arrays.asList(crtMatch.split("\\|"));
                String msg = crt + this.getSuggestion();
                for (int k = 0; k < replacements.size(); ++k) {
                    if (k > 0) {
                        msg = msg + (k == replacements.size() - 1 ? this.getSuggestionsSeparator() : ", ");
                    }
                    msg = msg + "<suggestion>" + replacements.get(k) + "</suggestion>";
                }
                msg = msg + "?";
                int startPos = ((AnalyzedTokenReadings)prevTokensList.get(len - crtWordCount)).getStartPos();
                int endPos = ((AnalyzedTokenReadings)prevTokensList.get(len - 1)).getEndPos();
                RuleMatch potentialRuleMatch = new RuleMatch((Rule)this, startPos, endPos, msg, this.getShort());
                if (!this.isCaseSensitive() && StringTools.startsWithUppercase((String)crt)) {
                    for (int k = 0; k < replacements.size(); ++k) {
                        replacements.set(k, StringTools.uppercaseFirstChar((String)replacements.get(k)));
                    }
                }
                potentialRuleMatch.setSuggestedReplacements(replacements);
                ruleMatches.add(potentialRuleMatch);
                continue block0;
            }
        }
        return this.toRuleMatchArray(ruleMatches);
    }
}

