/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.language.Contributor;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.LongParagraphRule;
import org.languagetool.rules.LongSentenceRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.ParagraphRepeatBeginningRule;
import org.languagetool.rules.PunctuationMarkAtParagraphEnd2;
import org.languagetool.rules.Rule;
import org.languagetool.rules.SentenceWhitespaceRule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WhiteSpaceAtBeginOfParagraph;
import org.languagetool.rules.WhiteSpaceBeforeParagraphEnd;
import org.languagetool.rules.be.BelarusianSpecificCaseRule;
import org.languagetool.rules.be.MorfologikBelarusianSpellerRule;
import org.languagetool.rules.be.SimpleReplaceRule;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.xx.DemoTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.be.BelarusianWordTokenizer;

@Deprecated
public class Belarusian
extends Language
implements AutoCloseable {
    private LanguageModel languageModel;

    public Pattern getIgnoredCharactersRegex() {
        return Pattern.compile("[\u00ad\u0301\u0300]");
    }

    public String getName() {
        return "Belarusian";
    }

    public String getShortCode() {
        return "be";
    }

    public String[] getCountries() {
        return new String[]{"BY"};
    }

    @NotNull
    public Tagger createDefaultTagger() {
        return new DemoTagger();
    }

    public SentenceTokenizer createDefaultSentenceTokenizer() {
        return new SRXSentenceTokenizer((Language)this);
    }

    public Tokenizer createDefaultWordTokenizer() {
        return new BelarusianWordTokenizer();
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Alex Buloichik")};
    }

    public String getOpeningDoubleQuote() {
        return "\u00ab";
    }

    public String getClosingDoubleQuote() {
        return "\u00bb";
    }

    public String getOpeningSingleQuote() {
        return "\u2018";
    }

    public String getClosingSingleQuote() {
        return "\u2019";
    }

    public boolean isAdvancedTypographyEnabled() {
        return true;
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages), new DoublePunctuationRule(messages), new MorfologikBelarusianSpellerRule(messages, this, userConfig, altLanguages), new UppercaseSentenceStartRule(messages, (Language)this), new MultipleWhitespaceRule(messages, (Language)this), new SentenceWhitespaceRule(messages), new WhiteSpaceBeforeParagraphEnd(messages, (Language)this), new WhiteSpaceAtBeginOfParagraph(messages), new LongSentenceRule(messages, userConfig, 50), new LongParagraphRule(messages, (Language)this, userConfig), new ParagraphRepeatBeginningRule(messages, (Language)this), new PunctuationMarkAtParagraphEnd2(messages, (Language)this), new SimpleReplaceRule(messages), new BelarusianSpecificCaseRule(messages)});
    }

    public synchronized LanguageModel getLanguageModel(File indexDir) throws IOException {
        this.languageModel = this.initLanguageModel(indexDir, this.languageModel);
        return this.languageModel;
    }

    @Override
    public void close() throws Exception {
        if (this.languageModel != null) {
            this.languageModel.close();
        }
    }

    protected int getPriorityForId(String id) {
        switch (id) {
            case "RUSSIAN_SIMPLE_REPLACE_RULE": {
                return 10;
            }
            case "BELARUSIAN_SPECIFIC_CASE": {
                return 9;
            }
            case "Word_root_repeat": {
                return -1;
            }
            case "PUNCT_DPT_2": {
                return -2;
            }
            case "TOO_LONG_PARAGRAPH": {
                return -15;
            }
        }
        return super.getPriorityForId(id);
    }

    @Nullable
    protected SpellingCheckRule createDefaultSpellingRule(ResourceBundle messages) throws IOException {
        return new MorfologikBelarusianSpellerRule(messages, this, null, null);
    }
}

