/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.synthesis.ar;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import morfologik.stemming.IStemmer;
import morfologik.stemming.WordData;
import org.languagetool.AnalyzedToken;
import org.languagetool.Language;
import org.languagetool.synthesis.BaseSynthesizer;
import org.languagetool.tagging.ar.ArabicTagManager;

public class ArabicSynthesizer
extends BaseSynthesizer {
    private static final String RESOURCE_FILENAME = "/ar/arabic_synth.dict";
    private static final String TAGS_FILE_NAME = "/ar/arabic_tags.txt";
    private final ArabicTagManager tagmanager = new ArabicTagManager();

    public ArabicSynthesizer(Language lang) {
        super(RESOURCE_FILENAME, TAGS_FILE_NAME, lang);
    }

    public String[] synthesize(AnalyzedToken token, String posTag) {
        IStemmer synthesizer = this.createStemmer();
        List wordData = synthesizer.lookup((CharSequence)(token.getLemma() + "|" + posTag));
        ArrayList<String> wordForms = new ArrayList<String>();
        for (WordData wd : wordData) {
            String stem = this.correctStem(wd.getStem().toString(), posTag);
            wordForms.add(stem);
        }
        return wordForms.toArray(new String[0]);
    }

    public String[] synthesize(AnalyzedToken token, String posTag, boolean posTagRegExp) throws IOException {
        if (posTag != null && posTagRegExp) {
            String myPosTag = posTag;
            this.initPossibleTags();
            myPosTag = this.correctTag(myPosTag);
            Pattern p = Pattern.compile(myPosTag);
            ArrayList<String> results = new ArrayList<String>();
            for (String tag : this.possibleTags) {
                Matcher m = p.matcher(tag);
                if (!m.matches() || token.getLemma() == null) continue;
                List result_one = this.lookup(token.getLemma(), tag);
                for (String wd : result_one) {
                    String stem = this.correctStem(wd, posTag);
                    results.add(stem);
                }
            }
            return results.toArray(new String[0]);
        }
        return this.synthesize(token, posTag);
    }

    public String correctTag(String postag) {
        String mypostag = postag;
        if (postag == null) {
            return null;
        }
        mypostag = this.tagmanager.setConjunction(mypostag, "-");
        mypostag = this.tagmanager.setDefinite(mypostag, "-");
        mypostag = this.tagmanager.unifyPronounTag(mypostag);
        return mypostag;
    }

    public String getPosTagCorrection(String posTag) {
        return this.correctTag(posTag);
    }

    public String correctStem(String stem, String postag) {
        String prefix;
        String correct_stem = stem;
        if (postag == null) {
            return stem;
        }
        if (this.tagmanager.isAttached(postag)) {
            correct_stem = correct_stem.replaceAll("\u0647$", "");
        }
        if (this.tagmanager.isDefinite(postag)) {
            prefix = this.tagmanager.getDefinitePrefix(postag);
            correct_stem = prefix + correct_stem;
        }
        if (this.tagmanager.hasJar(postag)) {
            prefix = this.tagmanager.getJarPrefix(postag);
            correct_stem = prefix + correct_stem;
        }
        if (this.tagmanager.hasConjunction(postag)) {
            prefix = this.tagmanager.getConjunctionPrefix(postag);
            correct_stem = prefix + correct_stem;
        }
        return correct_stem;
    }
}

