/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl.components;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.edl.impl.RequestParser;
import org.kuali.rice.edl.impl.components.MatchingParam;
import org.kuali.rice.edl.impl.components.SimpleWorkflowEDLConfigComponent;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.w3c.dom.Element;

public class NetworkIdWorkflowEDLConfigComponent
extends SimpleWorkflowEDLConfigComponent {
    private boolean required = false;

    @Override
    public Element getReplacementConfigElement(Element element) {
        Element replacementEl = (Element)element.cloneNode(true);
        Element type = (Element)replacementEl.getElementsByTagName("type").item(0);
        type.setTextContent("text");
        Element validation = (Element)replacementEl.getElementsByTagName("validation").item(0);
        if (validation != null && validation.getAttribute("required").equals("true")) {
            this.required = true;
        }
        return replacementEl;
    }

    @Override
    public String getErrorMessage(Element originalConfigElement, RequestParser requestParser, MatchingParam param) {
        if (!this.getEdlContext().getUserAction().isValidatableAction()) {
            return null;
        }
        if (StringUtils.isBlank((String)param.getParamValue()) && this.required) {
            return "Network ID is a required field";
        }
        if (StringUtils.isBlank((String)param.getParamValue()) && !this.required) {
            return null;
        }
        Principal principal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(param.getParamValue());
        if (principal == null) {
            return "The value " + param.getParamValue() + " is an invalid principal name";
        }
        return null;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }
}

