/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl;

import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.kuali.rice.core.api.util.RiceUtilities;
import org.kuali.rice.edl.impl.EDLGlobalConfig;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EDLGlobalConfigFactory {
    private static final String CONFIG_PROCESSOR_XPATH_XPRSN = "xpathExp";
    private static final String CONFIG_PROCESSOR_CLASS_NAME = "className";

    public static EDLGlobalConfig createEDLGlobalConfig(String edlConfigLocation) throws Exception {
        EDLGlobalConfig edlConfig = new EDLGlobalConfig();
        InputStream configStream = RiceUtilities.getResourceAsStream((String)edlConfigLocation);
        Document configXml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(configStream);
        edlConfig.setPreProcessors(EDLGlobalConfigFactory.createProcessorMap("//preProcessors/preProcessor", configXml));
        edlConfig.setPostProcessors(EDLGlobalConfigFactory.createProcessorMap("//postProcessors/postProcessor", configXml));
        edlConfig.setStateComponents(EDLGlobalConfigFactory.createProcessorMap("//stateComponents/stateComponent", configXml));
        edlConfig.setConfigProcessors(EDLGlobalConfigFactory.createConfigProcessorMap("//configProcessors/configProcessor", configXml));
        return edlConfig;
    }

    private static Map createProcessorMap(String xpathExpression, Document doc) throws Exception {
        LinkedHashMap processors = new LinkedHashMap();
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList globalProcessorDeclarations = (NodeList)xpath.evaluate(xpathExpression, doc, XPathConstants.NODESET);
        for (int i = 0; i < globalProcessorDeclarations.getLength(); ++i) {
            Element globalProcessorDeclaraion = (Element)globalProcessorDeclarations.item(i);
            processors.put(globalProcessorDeclaraion, Class.forName(globalProcessorDeclaraion.getFirstChild().getNodeValue()));
        }
        return processors;
    }

    private static Map createConfigProcessorMap(String xpathExpression, Document doc) throws Exception {
        LinkedHashMap configProcessors = new LinkedHashMap();
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList globalConfigProcessorDeclarations = (NodeList)xpath.evaluate(xpathExpression, doc, XPathConstants.NODESET);
        for (int i = 0; i < globalConfigProcessorDeclarations.getLength(); ++i) {
            Element globalProcessorDeclaraion = (Element)globalConfigProcessorDeclarations.item(i);
            String xpathEx = (String)xpath.evaluate(CONFIG_PROCESSOR_XPATH_XPRSN, globalProcessorDeclaraion, XPathConstants.STRING);
            String className = (String)xpath.evaluate(CONFIG_PROCESSOR_CLASS_NAME, globalProcessorDeclaraion, XPathConstants.STRING);
            configProcessors.put(xpathEx, Class.forName(className));
        }
        return configProcessors;
    }
}

