/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl.components;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.edl.impl.EDLContext;
import org.kuali.rice.edl.impl.EDLModelComponent;
import org.kuali.rice.edl.impl.EDLXmlUtils;
import org.kuali.rice.edl.impl.RequestParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PageHandler
implements EDLModelComponent {
    public static final String CURRENT_PAGE = "currentPage";
    public static final String PREVIOUS_PAGE = "previousPage";
    public static final String GOTO_PAGE = "edl.gotoPage";

    @Override
    public void updateDOM(Document dom, Element configElement, EDLContext edlContext) {
        String currentPage = edlContext.getRequestParser().getParameterValue("edl.currentPage");
        String previousPage = edlContext.getRequestParser().getParameterValue("edl.previousPage");
        String gotoPage = this.findGotoPage(edlContext.getRequestParser(), currentPage);
        if (!StringUtils.isBlank((String)gotoPage)) {
            previousPage = currentPage;
            currentPage = gotoPage;
        }
        this.establishCurrentPage(dom, currentPage);
        this.establishPreviousPage(dom, previousPage);
    }

    private String findGotoPage(RequestParser requestParser, String currentPage) {
        List<String> parameterNames = requestParser.getParameterNames();
        for (String parameterName : parameterNames) {
            if (!parameterName.startsWith("edl.gotoPage:")) continue;
            return parameterName.split(":")[1];
        }
        return null;
    }

    private void establishCurrentPage(Document dom, String currentPage) {
        if (!StringUtils.isBlank((String)currentPage)) {
            Element currentPageElement = EDLXmlUtils.getOrCreateChildElement(dom.getDocumentElement(), CURRENT_PAGE, true);
            currentPageElement.appendChild(dom.createTextNode(currentPage));
        }
    }

    private void establishPreviousPage(Document dom, String previousPage) {
        if (!StringUtils.isBlank((String)previousPage)) {
            Element previousPageElement = EDLXmlUtils.getOrCreateChildElement(dom.getDocumentElement(), PREVIOUS_PAGE, true);
            previousPageElement.appendChild(dom.createTextNode(previousPage));
        }
    }
}

