/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.kuali.rice.edl.impl.components.MatchingParam;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class EDLXmlUtils {
    private static final Logger LOG = Logger.getLogger(EDLXmlUtils.class);
    public static final String EDL_E = "edl";
    public static final String EDLCONTENT_E = "edlContent";
    public static final String DATA_E = "data";
    public static final String TYPE_E = "type";
    public static final String VALIDATION_E = "validation";
    public static final String VERSION_E = "version";
    public static final String DOCID_E = "docId";

    private EDLXmlUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static DocumentBuilder getDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            String message = "Error obtaining document builder";
            LOG.error((Object)message, (Throwable)pce);
            throw new RuntimeException(message, pce);
        }
    }

    public static Element createFieldDataElement(Element parentVersionElement, MatchingParam matchingParam) {
        Element fieldData = EDLXmlUtils.createChildElement(parentVersionElement, "field");
        fieldData.setAttribute("name", matchingParam.getParamName());
        if (matchingParam.getError().booleanValue()) {
            fieldData.setAttribute("invalid", "true");
            Element errorMessage = EDLXmlUtils.getOrCreateChildElement(fieldData, "errorMessage", true);
            EDLXmlUtils.placeTextInElement(errorMessage, matchingParam.getErrorMessage());
        }
        Element fieldValue = EDLXmlUtils.getOrCreateChildElement(fieldData, "value", true);
        EDLXmlUtils.placeTextInElement(fieldValue, matchingParam.getParamValue());
        return fieldData;
    }

    public static Element createChildElement(Element parentElement, String elementName) {
        Element child = parentElement.getOwnerDocument().createElement(elementName);
        parentElement.appendChild(child);
        return child;
    }

    public static Element getDocumentStateElement(Document dom) {
        return EDLXmlUtils.getOrCreateChildElement(dom.getDocumentElement(), "documentState", true);
    }

    public static void addGlobalErrorMessage(Document dom, String errorMessage) {
        Element documentState = EDLXmlUtils.getDocumentStateElement(dom);
        EDLXmlUtils.createTextElementOnParent(documentState, "error", errorMessage);
    }

    private static void placeTextInElement(Element element, String text) {
        if (element.getOwnerDocument() == null) {
            throw new WorkflowRuntimeException("The element must have an owner document in order to add text");
        }
        element.appendChild(element.getOwnerDocument().createTextNode(text));
    }

    public static Element createTextElementOnParent(Element parent, String childElementName, String text) {
        if (text == null) {
            throw new WorkflowRuntimeException("The text placed in an Element cannot be null");
        }
        Element childElement = parent.getOwnerDocument().createElement(childElementName);
        parent.appendChild(childElement);
        childElement.appendChild(parent.getOwnerDocument().createTextNode(text));
        return childElement;
    }

    public static Element getVersionFromData(Element dataElement, Integer versionCount) {
        if (dataElement == null) {
            throw new WorkflowRuntimeException("Attempting to put version element inside null data Element");
        }
        if (!dataElement.getTagName().equals(DATA_E)) {
            throw new WorkflowRuntimeException("Attempting to put version element inside a parent that is not a data element " + dataElement.getTagName());
        }
        Element version = EDLXmlUtils.createChildElement(dataElement, VERSION_E);
        version.setAttribute("current", "true");
        version.setAttribute("date", new Date().toString());
        version.setAttribute(VERSION_E, versionCount.toString());
        return version;
    }

    public static Element getDataFromEDLDocument(Element edlContent, boolean create) {
        return EDLXmlUtils.getOrCreateChildElement(edlContent, DATA_E, create);
    }

    public static Element getEDLContent(Document displayDoc, boolean create) {
        return EDLXmlUtils.getOrCreateChildElement(displayDoc.getDocumentElement(), EDLCONTENT_E, create);
    }

    public static Element getOrCreateChildElement(Element parent, String name, boolean create) {
        if (parent == null) {
            throw new WorkflowRuntimeException("Passed in null parent element attempting to create child element '" + name + "'");
        }
        Element child = EDLXmlUtils.getChildElement(parent, name);
        if (child == null && create) {
            LOG.debug((Object)("Creating child element '" + name + "' of parent: " + parent));
            child = parent.getOwnerDocument().createElement(name);
            parent.appendChild(child);
        }
        return child;
    }

    public static Element getChildElement(Node parent, String name) {
        NodeList childList = parent.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node node = childList.item(i);
            if (node.getNodeType() != 1 || !name.equals(node.getLocalName()) && !name.equals(node.getNodeName())) continue;
            return (Element)node;
        }
        return null;
    }

    public static String getChildElementTextValue(Node parent, String name) {
        Element child = EDLXmlUtils.getChildElement(parent, name);
        if (child == null) {
            return null;
        }
        Node textNode = child.getFirstChild();
        if (textNode == null) {
            return null;
        }
        return textNode.getNodeValue();
    }

    public static void addErrorsAndMessagesToDocument(Document doc, List errors, List messages, Map<String, String> fieldErrors) {
        Element error;
        Element documentState = EDLXmlUtils.getDocumentStateElement(doc);
        Iterator it = errors.iterator();
        while (it.hasNext()) {
            error = doc.createElement("error");
            error.appendChild(doc.createTextNode(it.next().toString()));
            documentState.appendChild(error);
        }
        it = messages.iterator();
        while (it.hasNext()) {
            error = doc.createElement("message");
            error.appendChild(doc.createTextNode(it.next().toString()));
            documentState.appendChild(error);
        }
        for (String errorKey : fieldErrors.keySet()) {
            Element error2 = doc.createElement("fieldError");
            error2.setAttribute("key", errorKey);
            error2.appendChild(doc.createTextNode(fieldErrors.get(errorKey)));
            documentState.appendChild(error2);
        }
    }
}

