/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl.components;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.util.xml.XmlJotter;
import org.kuali.rice.edl.impl.EDLContext;
import org.kuali.rice.edl.impl.EDLModelComponent;
import org.kuali.rice.edl.impl.EDLXmlUtils;
import org.kuali.rice.edl.impl.components.VersioningPreprocessor;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.action.ActionTaken;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AnnotationComponent
implements EDLModelComponent {
    private static final Logger LOG = Logger.getLogger(AnnotationComponent.class);

    @Override
    public void updateDOM(Document dom, Element configElement, EDLContext edlContext) {
        WorkflowDocument document = (WorkflowDocument)edlContext.getRequestParser().getAttribute("workflowDocument");
        Element currentVersion = VersioningPreprocessor.findCurrentVersion(dom);
        String annotation = edlContext.getRequestParser().getParameterValue("annotation");
        if (!StringUtils.isEmpty((String)annotation)) {
            EDLXmlUtils.createTextElementOnParent(currentVersion, "currentAnnotation", annotation);
        }
        LOG.debug((Object)("Inserting annotation: " + annotation));
        List actionsTaken = document.getActionsTaken();
        if (actionsTaken != null) {
            for (ActionTaken actionTaken : actionsTaken) {
                if (actionTaken == null || (annotation = actionTaken.getAnnotation()) == null) continue;
                LOG.debug((Object)("Adding annotation: " + annotation));
                Person person = KimApiServiceLocator.getPersonService().getPerson(actionTaken.getPrincipalId());
                EDLXmlUtils.createTextElementOnParent(currentVersion, "annotation", person.getName() + ": " + annotation);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("dom: " + XmlJotter.jotNode((Node)dom)));
            }
        }
    }
}

