/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl.components;

import java.util.ArrayList;
import java.util.List;
import org.kuali.rice.edl.impl.EDLContext;
import org.kuali.rice.edl.impl.EDLModelComponent;
import org.kuali.rice.edl.impl.EDLXmlUtils;
import org.kuali.rice.edl.impl.RequestParser;
import org.kuali.rice.edl.impl.components.MatchingParam;
import org.kuali.rice.edl.impl.components.VersioningPreprocessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SimpleWorkflowEDLConfigComponent
implements EDLModelComponent {
    protected Element definitionElement;
    private EDLContext edlContext;

    @Override
    public void updateDOM(Document dom, Element currentDefinitionElement, EDLContext edlContext) {
        RequestParser requestParser = edlContext.getRequestParser();
        this.edlContext = edlContext;
        this.definitionElement = currentDefinitionElement;
        Element configElementForDOM = this.getReplacementConfigElement(currentDefinitionElement);
        if (configElementForDOM == null) {
            configElementForDOM = currentDefinitionElement;
        }
        Element edlContentElement = EDLXmlUtils.getEDLContent(dom, false);
        edlContentElement.appendChild(configElementForDOM);
        Element currentVersion = VersioningPreprocessor.findCurrentVersion(dom);
        List matchingParams = this.getMatchingParams(configElementForDOM, requestParser, edlContext);
        for (MatchingParam matchingParam : matchingParams) {
            EDLXmlUtils.createFieldDataElement(currentVersion, matchingParam);
        }
    }

    public Element getReplacementConfigElement(Element element) {
        return null;
    }

    public List getMatchingParams(Element originalConfigElement, RequestParser requestParser, EDLContext edlContext) {
        ArrayList<MatchingParam> params = new ArrayList<MatchingParam>();
        String paramName = originalConfigElement.getAttribute("name");
        String[] paramValues = requestParser.getParameterValues(paramName);
        if (paramValues == null) {
            return params;
        }
        for (int i = 0; i < paramValues.length; ++i) {
            String value = paramValues[i];
            MatchingParam matchingParam = new MatchingParam();
            matchingParam.setParamName(paramName);
            matchingParam.setParamValue(value);
            String errorMessage = this.getErrorMessage(originalConfigElement, requestParser, matchingParam);
            if (errorMessage != null) {
                matchingParam.setError(Boolean.TRUE);
                matchingParam.setErrorMessage(errorMessage);
                edlContext.setInError(true);
            }
            params.add(matchingParam);
        }
        return params;
    }

    public String getErrorMessage(Element originalConfigElement, RequestParser requestParser, MatchingParam matchingParam) {
        return null;
    }

    public Element getDefinitionElement() {
        return this.definitionElement;
    }

    public void setDefinitionElement(Element definitionElement) {
        this.definitionElement = definitionElement;
    }

    public EDLContext getEdlContext() {
        return this.edlContext;
    }

    public void setEdlContext(EDLContext edlContext) {
        this.edlContext = edlContext;
    }
}

