/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode.xalan;

import javax.xml.transform.TransformerException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.xalan.extensions.XSLProcessorContext;
import org.apache.xalan.templates.ElemExtensionCall;
import org.krysalis.barcode.BarcodeGenerator;
import org.krysalis.barcode.BarcodeUtil;
import org.krysalis.barcode.output.svg.SVGCanvasProvider;
import org.krysalis.barcode.tools.ConfigurationUtil;
import org.krysalis.barcode.xalan.ElemWrappingConfiguration;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BarcodeExt {
    private Logger log = new ConsoleLogger();

    public DocumentFragment generate(NodeList nl, String message) throws SAXException {
        try {
            Configuration cfg = ConfigurationUtil.buildConfiguration(nl.item(0));
            BarcodeGenerator gen = BarcodeUtil.getInstance().createBarcodeGenerator(cfg, this.log);
            SVGCanvasProvider svg = cfg.getAttributeAsBoolean("useNamespace", true) ? new SVGCanvasProvider(cfg.getAttribute("prefix", "svg")) : new SVGCanvasProvider(false);
            gen.generateBarcode(svg, message);
            return svg.getDOMFragment();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SAXException(e);
        }
    }

    public DocumentFragment barcode(XSLProcessorContext context, ElemExtensionCall elem) throws TransformerException {
        try {
            String message = elem.getAttribute("message", context.getContextNode(), context.getTransformer());
            ElemWrappingConfiguration cfg = new ElemWrappingConfiguration((Element)elem);
            BarcodeGenerator gen = BarcodeUtil.getInstance().createBarcodeGenerator((Configuration)cfg, this.log);
            SVGCanvasProvider svg = cfg.getAttributeAsBoolean("useNamespace", true) ? new SVGCanvasProvider(cfg.getAttribute("prefix", "svg")) : new SVGCanvasProvider(false);
            gen.generateBarcode(svg, message);
            return svg.getDOMFragment();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TransformerException(e);
        }
    }
}

